/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import harmonised.pmmo.config.SkillsConfig;
import harmonised.pmmo.config.codecs.SkillData;
import harmonised.pmmo.core.Core;
import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.scores.Objective;
import net.minecraft.world.scores.criteria.ObjectiveCriteria;
import net.minecraftforge.fml.LogicalSide;

public class CmdNodeStore {
    private static final String TARGET_ARG = "Target";
    private static final String SKILL_ARG = "Skill Name";

    public static ArgumentBuilder<CommandSourceStack, ?> register(CommandDispatcher<CommandSourceStack> dispatcher) {
        return ((LiteralArgumentBuilder)Commands.m_82127_((String)"store").requires(p -> p.m_6761_(2))).then(Commands.m_82129_((String)TARGET_ARG, (ArgumentType)EntityArgument.m_91470_()).then(Commands.m_82129_((String)SKILL_ARG, (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> SharedSuggestionProvider.m_82970_(SkillsConfig.SKILLS.get().keySet(), (SuggestionsBuilder)builder)).executes(ctx -> CmdNodeStore.store((CommandContext<CommandSourceStack>)ctx))));
    }

    public static int store(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        Collection players = EntityArgument.m_91477_(ctx, (String)TARGET_ARG);
        String skillName = StringArgumentType.getString(ctx, (String)SKILL_ARG);
        MinecraftServer server = ((CommandSourceStack)ctx.getSource()).m_81377_();
        for (ServerPlayer player : players) {
            int skillLevel = CmdNodeStore.getSkillLevel(skillName, player.m_20148_());
            server.m_129896_().m_83471_(player.m_6302_(), CmdNodeStore.getOrCreate(server, skillName)).m_83402_(skillLevel);
        }
        return 0;
    }

    private static Objective getOrCreate(MinecraftServer server, String objective) {
        Objective obtainedObjective = server.m_129896_().m_83477_(objective);
        if (obtainedObjective == null) {
            obtainedObjective = server.m_129896_().m_83436_(objective, ObjectiveCriteria.f_83588_, (Component)Component.m_237115_((String)("pmmo." + objective)), ObjectiveCriteria.RenderType.INTEGER);
        }
        return obtainedObjective;
    }

    private static int getSkillLevel(String skill, UUID pid) {
        Core core = Core.get(LogicalSide.SERVER);
        SkillData skillData = SkillsConfig.SKILLS.get().get(skill);
        if (skillData == null) {
            return 0;
        }
        if (skillData.isSkillGroup()) {
            int groupLevel = 0;
            double proportionModifier = skillData.getUseTotalLevels() ? 1.0 : skillData.groupedSkills().get().values().stream().collect(Collectors.summingDouble(Double::doubleValue));
            for (Map.Entry<String, Double> portion : skillData.groupedSkills().get().entrySet()) {
                groupLevel = (int)((double)groupLevel + (double)core.getData().getPlayerSkillLevel(portion.getKey(), pid) * (portion.getValue() / proportionModifier));
            }
            return groupLevel;
        }
        return core.getData().getPlayerSkillLevel(skill, pid);
    }
}

