/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.config.codecs;

import harmonised.pmmo.api.enums.EventType;
import harmonised.pmmo.api.enums.ModifierDataType;
import harmonised.pmmo.api.enums.ReqType;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;

public interface DataSource<T> {
    public T combine(T var1);

    public boolean isUnconfigured();

    default public Set<String> getTagValues() {
        return Set.of();
    }

    default public Map<String, Long> getXpValues(EventType type, CompoundTag nbt) {
        return new HashMap<String, Long>();
    }

    default public void setXpValues(EventType type, Map<String, Long> award) {
    }

    default public Map<String, Double> getBonuses(ModifierDataType type, CompoundTag nbt) {
        return new HashMap<String, Double>();
    }

    default public void setBonuses(ModifierDataType type, Map<String, Double> bonuses) {
    }

    default public Map<String, Integer> getReqs(ReqType type, CompoundTag nbt) {
        return new HashMap<String, Integer>();
    }

    default public void setReqs(ReqType type, Map<String, Integer> reqs) {
    }

    default public Map<ResourceLocation, Integer> getNegativeEffect() {
        return new HashMap<ResourceLocation, Integer>();
    }

    default public void setNegativeEffects(Map<ResourceLocation, Integer> neg) {
    }

    default public Map<ResourceLocation, Integer> getPositiveEffect() {
        return new HashMap<ResourceLocation, Integer>();
    }

    default public void setPositiveEffects(Map<ResourceLocation, Integer> pos) {
    }

    public static <K, V> HashMap<K, V> clearEmptyValues(Map<K, V> map) {
        HashMap outMap = new HashMap();
        map.forEach((key, value) -> {
            boolean isEmpty = false;
            if (value instanceof Collection) {
                isEmpty = ((Collection)value).isEmpty();
            } else if (value instanceof Map) {
                isEmpty = ((Map)value).isEmpty();
            }
            if (!isEmpty) {
                outMap.put(key, value);
            }
        });
        return outMap;
    }
}

