/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.config.readers;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import harmonised.pmmo.api.enums.EventType;
import harmonised.pmmo.config.codecs.DataSource;
import harmonised.pmmo.config.codecs.ObjectData;
import harmonised.pmmo.util.MsLoggy;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.OnDatapackSyncEvent;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;
import org.apache.logging.log4j.Logger;

public class MergeableCodecDataManager<T extends DataSource<T>, V>
extends SimplePreparableReloadListener<Map<ResourceLocation, T>> {
    protected static final String JSON_EXTENSION = ".json";
    protected static final int JSON_EXTENSION_LENGTH = ".json".length();
    protected static final Gson STANDARD_GSON = new Gson();
    @Nonnull
    protected Map<ResourceLocation, T> data = new HashMap<ResourceLocation, T>();
    private final String folderName;
    private final Logger logger;
    private final Codec<T> codec;
    private final Function<List<T>, T> merger;
    private final Consumer<Map<ResourceLocation, T>> finalizer;
    private final Gson gson;
    private final Supplier<T> defaultImpl;
    private final ResourceKey<Registry<V>> registry;
    private Map<ResourceLocation, T> defaultSettings = new HashMap<ResourceLocation, T>();
    private Map<ResourceLocation, T> overrideSettings = new HashMap<ResourceLocation, T>();

    public MergeableCodecDataManager(String folderName, Logger logger, Codec<T> codec, Function<List<T>, T> merger, Consumer<Map<ResourceLocation, T>> finalizer, Supplier<T> defaultImpl, ResourceKey<Registry<V>> registry) {
        this(folderName, logger, codec, merger, finalizer, STANDARD_GSON, defaultImpl, registry);
    }

    public MergeableCodecDataManager(String folderName, Logger logger, Codec<T> codec, Function<List<T>, T> merger, Consumer<Map<ResourceLocation, T>> finalizer, Gson gson, Supplier<T> defaultImpl, ResourceKey<Registry<V>> registry) {
        this.folderName = folderName;
        this.logger = logger;
        this.codec = codec;
        this.merger = merger;
        this.finalizer = finalizer;
        this.gson = gson;
        this.defaultImpl = defaultImpl;
        this.registry = registry;
    }

    public Map<ResourceLocation, T> getData() {
        return this.data;
    }

    public void clearData() {
        this.data.clear();
        this.overrideSettings.clear();
        this.defaultSettings.clear();
    }

    public T getData(ResourceLocation id) {
        return (T)this.data.computeIfAbsent(id, res -> this.getGenericTypeInstance());
    }

    public T getGenericTypeInstance() {
        return (T)((DataSource)this.defaultImpl.get());
    }

    public void registerDefault(ResourceLocation id, DataSource<?> data) {
        this.defaultSettings.merge(id, data, DataSource::combine);
    }

    public void registerOverride(ResourceLocation id, DataSource<?> data) {
        this.overrideSettings.merge(id, data, DataSource::combine);
    }

    protected Map<ResourceLocation, T> prepare(ResourceManager resourceManager, ProfilerFiller profiler) {
        HashMap map = new HashMap();
        this.defaultSettings.forEach((id, data) -> map.put((ResourceLocation)id, new ArrayList<DataSource>(List.of(data))));
        for (ResourceLocation resourceLocation : resourceManager.m_214159_(this.folderName, MergeableCodecDataManager::isStringJsonFile).keySet()) {
            String namespace = resourceLocation.m_135827_();
            String filePath = resourceLocation.m_135815_();
            String dataPath = filePath.substring(this.folderName.length() + 1, filePath.length() - JSON_EXTENSION_LENGTH);
            ResourceLocation jsonIdentifier = new ResourceLocation(namespace, dataPath);
            ArrayList unmergedRaws = new ArrayList();
            for (Resource resource : resourceManager.m_213829_(resourceLocation)) {
                try {
                    BufferedReader reader = resource.m_215508_();
                    try {
                        JsonElement jsonElement = (JsonElement)GsonHelper.m_13776_((Gson)this.gson, (Reader)reader, JsonElement.class);
                        this.codec.parse((DynamicOps)JsonOps.INSTANCE, (Object)jsonElement).resultOrPartial(MergeableCodecDataManager::throwJsonParseException).ifPresent(unmergedRaws::add);
                    }
                    finally {
                        if (reader == null) continue;
                        ((Reader)reader).close();
                    }
                }
                catch (IOException | RuntimeException exception) {
                    this.logger.error("Data loader for {} could not read data {} from file {} in data pack {}", (Object)this.folderName, (Object)jsonIdentifier, (Object)resourceLocation, (Object)resource.m_215506_(), (Object)exception);
                }
            }
            map.put(jsonIdentifier, unmergedRaws);
        }
        return MergeableCodecDataManager.mapValues(map, this.merger::apply);
    }

    static boolean isStringJsonFile(ResourceLocation file) {
        return file.m_135815_().endsWith(JSON_EXTENSION);
    }

    static void throwJsonParseException(String codecParseFailure) {
        throw new JsonParseException(codecParseFailure);
    }

    static <Key, In, Out> Map<Key, Out> mapValues(Map<Key, In> inputs, Function<In, Out> mapper) {
        HashMap newMap = new HashMap();
        inputs.forEach((key, input) -> {
            Object output = mapper.apply(input);
            if (output != null) {
                newMap.put(key, output);
            }
        });
        return newMap;
    }

    protected void apply(Map<ResourceLocation, T> processedData, ResourceManager resourceManager, ProfilerFiller profiler) {
        MsLoggy.INFO.log(MsLoggy.LOG_CODE.DATA, "Beginning loading of data for data loader: {}", this.folderName);
        MsLoggy.DEBUG.log(MsLoggy.LOG_CODE.DATA, processedData, "Loaded Data For: {} of: {}", new Object[0]);
        this.data.putAll(processedData);
        MsLoggy.DEBUG.log(MsLoggy.LOG_CODE.DATA, this.overrideSettings, "Loaded Override For: {} of: {}", new Object[0]);
        this.data.putAll(this.overrideSettings);
    }

    public void postProcess(RegistryAccess registryAccess) {
        Registry activeRegistry = registryAccess.m_175515_(this.registry);
        MsLoggy.DEBUG.log(MsLoggy.LOG_CODE.DATA, "Begin PostProcessing for {}", this.folderName);
        for (Map.Entry<ResourceLocation, T> dataRaw : new HashMap<ResourceLocation, T>(this.data).entrySet()) {
            DataSource dataValue = (DataSource)dataRaw.getValue();
            if (dataValue.getTagValues().isEmpty()) continue;
            MsLoggy.INFO.log(MsLoggy.LOG_CODE.DATA, "Tag Data Found for {}", dataRaw.getKey().toString());
            ArrayList<ResourceLocation> tags = new ArrayList<ResourceLocation>();
            for (String str : dataValue.getTagValues()) {
                MsLoggy.INFO.log(MsLoggy.LOG_CODE.DATA, "Applying Setting to Tag: {}", str);
                if (str.startsWith("#")) {
                    activeRegistry.m_203431_(TagKey.m_203882_(this.registry, (ResourceLocation)new ResourceLocation(str.substring(1)))).ifPresent(tag -> tags.addAll(tag.m_203614_().map(holder -> ((ResourceKey)holder.m_203543_().get()).m_135782_()).toList()));
                    continue;
                }
                if (str.endsWith(":*")) {
                    tags.addAll(activeRegistry.m_6566_().stream().filter(key -> key.m_135827_().equals(str.replace(":*", ""))).toList());
                    continue;
                }
                tags.add(new ResourceLocation(str));
            }
            dataValue.getTagValues().clear();
            if (dataValue instanceof ObjectData) {
                ObjectData entityData = (ObjectData)dataValue;
                ArrayList<ResourceLocation> damageMembers = new ArrayList<ResourceLocation>();
                for (EventType event : List.of(EventType.RECEIVE_DAMAGE, EventType.DEAL_DAMAGE)) {
                    Map values = entityData.damageXpValues().getOrDefault(event, new HashMap());
                    for (String str : values.keySet()) {
                        damageMembers.clear();
                        if (!str.startsWith("#")) continue;
                        damageMembers.addAll(registryAccess.m_175515_(Registries.f_268580_).m_203431_(TagKey.m_203882_((ResourceKey)Registries.f_268580_, (ResourceLocation)new ResourceLocation(str.substring(1)))).stream().map(type -> ((TagKey)type.m_245234_().get()).f_203868_()).toList());
                        damageMembers.forEach(damageType -> values.put(damageType.toString(), (Map)values.get(str)));
                    }
                }
            }
            tags.forEach(rl -> this.data.merge((ResourceLocation)rl, (T)dataValue, (o, n) -> o.combine(n)));
        }
        this.finalizer.accept(this.data);
    }

    public <PACKET> MergeableCodecDataManager<T, V> subscribeAsSyncable(SimpleChannel channel, Function<Map<ResourceLocation, T>, PACKET> packetFactory) {
        MinecraftForge.EVENT_BUS.addListener(this.getDatapackSyncListener(channel, packetFactory));
        return this;
    }

    private <PACKET> Consumer<OnDatapackSyncEvent> getDatapackSyncListener(SimpleChannel channel, Function<Map<ResourceLocation, T>, PACKET> packetFactory) {
        return event -> {
            ServerPlayer player = event.getPlayer();
            ArrayList packets = new ArrayList();
            for (Map.Entry<ResourceLocation, T> entry : new HashMap<ResourceLocation, T>(this.data).entrySet()) {
                if (entry.getKey() == null) continue;
                packets.add(packetFactory.apply(Map.of(entry.getKey(), (DataSource)entry.getValue())));
            }
            PacketDistributor.PacketTarget target = player == null ? PacketDistributor.ALL.noArg() : PacketDistributor.PLAYER.with(() -> player);
            packets.forEach(packet -> channel.send(target, packet));
        };
    }
}

