/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.config.scripting;

import com.mojang.datafixers.util.Pair;
import harmonised.pmmo.api.APIUtils;
import harmonised.pmmo.api.enums.EventType;
import harmonised.pmmo.api.enums.ModifierDataType;
import harmonised.pmmo.api.enums.ObjectType;
import harmonised.pmmo.api.enums.ReqType;
import harmonised.pmmo.config.codecs.MobModifier;
import harmonised.pmmo.config.codecs.ObjectData;
import harmonised.pmmo.config.codecs.VeinData;
import harmonised.pmmo.config.scripting.NodeConsumer;
import harmonised.pmmo.config.scripting.TargetSelector;
import harmonised.pmmo.core.Core;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.TieredItem;
import net.minecraftforge.fml.LogicalSide;

public class Functions {
    public static final Map<String, NodeConsumer> KEYWORDS = new HashMap<String, NodeConsumer>();
    public static final Map<String, TargetSelector> TARGETORS = new HashMap<String, TargetSelector>();
    public static final Pattern operationRegex = Pattern.compile("(>=|<=|>|<|=)\\s*([-+]?\\d*\\.?\\d+(?:[eE][-+]?\\d+)?)");

    private static Map<String, Long> mapValue(String value) {
        HashMap<String, Long> outMap = new HashMap<String, Long>();
        String[] elements = value.replaceAll("\\)", "").split(",");
        for (int i = 0; i <= elements.length - 2; i += 2) {
            outMap.put(elements[i], Long.valueOf(elements[i + 1]));
        }
        return outMap;
    }

    private static Map<String, Integer> intMap(String value) {
        HashMap<String, Integer> outMap = new HashMap<String, Integer>();
        String[] elements = value.replaceAll("\\)", "").split(",");
        for (int i = 0; i <= elements.length - 2; i += 2) {
            outMap.put(elements[i], Integer.valueOf(elements[i + 1]));
        }
        return outMap;
    }

    private static Map<String, Double> doubleMap(String value) {
        HashMap<String, Double> outMap = new HashMap<String, Double>();
        String[] elements = value.replaceAll("\\)", "").split(",");
        for (int i = 0; i <= elements.length - 2; i += 2) {
            outMap.put(elements[i], Double.valueOf(elements[i + 1]));
        }
        return outMap;
    }

    private static List<MobModifier> modifiers(String value) {
        ArrayList<MobModifier> output = new ArrayList<MobModifier>();
        String[] elements = value.replaceAll("\\)", "").split(",");
        if (elements.length % 3 != 0) {
            return output;
        }
        for (int i = 0; i <= elements.length - 3; i += 3) {
            output.add(new MobModifier(new ResourceLocation(elements[i]), Double.valueOf(elements[i + 1]), AttributeModifier.Operation.valueOf((String)elements[i + 2])));
        }
        return output;
    }

    static {
        KEYWORDS.put("xp", (param, id, type, value) -> {
            EventType event = EventType.byName(param.toUpperCase());
            if (event == null) {
                return;
            }
            Map<String, Long> award = Functions.mapValue(value.getOrDefault("award", ""));
            if (award.isEmpty()) {
                return;
            }
            APIUtils.registerXpAward(type, id, event, award, true);
        });
        KEYWORDS.put("deal_damage", (param, id, type, value) -> {
            Map<String, Long> award = Functions.mapValue(value.getOrDefault("award", ""));
            if (award.isEmpty()) {
                return;
            }
            APIUtils.registerXpAward(type, id, EventType.DEAL_DAMAGE, award, true);
        });
        KEYWORDS.put("receive_damage", (param, id, type, value) -> {
            Map<String, Long> award = Functions.mapValue(value.getOrDefault("award", ""));
            if (award.isEmpty()) {
                return;
            }
            APIUtils.registerXpAward(type, id, EventType.RECEIVE_DAMAGE, award, true);
        });
        KEYWORDS.put("req", (param, id, type, value) -> {
            ReqType reqType = ReqType.byName(param.toUpperCase());
            if (reqType == null) {
                return;
            }
            Map<String, Integer> reqs = Functions.intMap(value.getOrDefault("require", ""));
            if (reqs.isEmpty()) {
                return;
            }
            APIUtils.registerRequirement(type, id, reqType, reqs, true);
        });
        KEYWORDS.put("bonus", (param, id, type, value) -> {
            ModifierDataType bonusType = ModifierDataType.byName(param.toUpperCase());
            if (bonusType == null) {
                return;
            }
            Map<String, Double> bonus = Functions.doubleMap(value.getOrDefault("value", ""));
            if (bonus.isEmpty()) {
                return;
            }
            APIUtils.registerBonus(type, id, bonusType, bonus, true);
        });
        KEYWORDS.put("vein_charge", (param, id, type, value) -> {
            Object source = Core.get(LogicalSide.SERVER).getLoader().getLoader(type).getData(id);
            if (source instanceof ObjectData) {
                ObjectData data = (ObjectData)source;
                VeinData current = data.veinData();
                APIUtils.registerVeinData(type, id, current.chargeCap, Optional.of(Double.valueOf(param)), current.consumeAmount, true);
            }
        });
        KEYWORDS.put("vein_capacity", (param, id, type, value) -> {
            Object source = Core.get(LogicalSide.SERVER).getLoader().getLoader(type).getData(id);
            if (source instanceof ObjectData) {
                ObjectData data = (ObjectData)source;
                VeinData current = data.veinData();
                APIUtils.registerVeinData(type, id, Optional.of(Integer.valueOf(param)), current.chargeRate, current.consumeAmount, true);
            }
        });
        KEYWORDS.put("vein_consume", (param, id, type, value) -> {
            Object source = Core.get(LogicalSide.SERVER).getLoader().getLoader(type).getData(id);
            if (source instanceof ObjectData) {
                ObjectData data = (ObjectData)source;
                VeinData current = data.veinData();
                APIUtils.registerVeinData(type, id, current.chargeCap, current.chargeRate, Optional.of(Integer.valueOf(param)), true);
            }
        });
        KEYWORDS.put("mob_scale", (param, id, type, value) -> {
            ResourceLocation entityID = new ResourceLocation(param);
            List<MobModifier> modifiers = Functions.modifiers(value.getOrDefault("attribute", ""));
            APIUtils.registerMobModifier(type, id, Map.of(entityID, modifiers), true);
        });
        KEYWORDS.put("positive_effect", (param, id, type, value) -> {
            Object data = Core.get(LogicalSide.SERVER).getLoader().getLoader(type).getData(id);
            String[] splitParam = param.split(",");
            if (splitParam.length < 2) {
                return;
            }
            ResourceLocation effectID = new ResourceLocation(splitParam[0]);
            int amplifier = Integer.parseInt(splitParam[1]);
            HashMap<ResourceLocation, Integer> current = new HashMap<ResourceLocation, Integer>(data.getPositiveEffect());
            current.put(effectID, amplifier);
            APIUtils.registerPositiveEffect(type, id, current, true);
        });
        KEYWORDS.put("negative_effect", (param, id, type, value) -> {
            Object data = Core.get(LogicalSide.SERVER).getLoader().getLoader(type).getData(id);
            String[] splitParam = param.split(",");
            if (splitParam.length < 2) {
                return;
            }
            ResourceLocation effectID = new ResourceLocation(splitParam[0]);
            int amplifier = Integer.parseInt(splitParam[1]);
            HashMap<ResourceLocation, Integer> current = new HashMap<ResourceLocation, Integer>(data.getNegativeEffect());
            current.put(effectID, amplifier);
            APIUtils.registerNegativeEffect(type, id, current, true);
        });
        KEYWORDS.put("salvage", (param, id, type, value) -> {
            APIUtils.SalvageBuilder builder = APIUtils.SalvageBuilder.start();
            if (value.containsKey("chance_level")) {
                builder.setChancePerLevel(Functions.doubleMap((String)value.get("chance_level")));
            }
            if (value.containsKey("chance_base")) {
                builder.setBaseChance(Double.parseDouble((String)value.get("chance_base")));
            }
            if (value.containsKey("chance_max")) {
                builder.setMaxChance(Double.parseDouble((String)value.get("chance_max")));
            }
            if (value.containsKey("level_req")) {
                builder.setLevelReq(Functions.intMap((String)value.get("level_req")));
            }
            if (value.containsKey("salvage_award")) {
                builder.setXpAward(Functions.mapValue((String)value.get("salvage_award")));
            }
            if (value.containsKey("max_drops")) {
                builder.setSalvageMax(Integer.parseInt((String)value.get("max_drops")));
            }
            ResourceLocation drop = new ResourceLocation(param);
            APIUtils.registerSalvage(id, Map.of(drop, builder), true);
        });
        TARGETORS.put("food", (param, access) -> {
            String[] exprStr = param.split(",");
            float nutVal = 0.0f;
            float satVal = 0.0f;
            Operator nutOp = Operator.GTE;
            Operator satOp = Operator.GTE;
            for (String str : exprStr) {
                Matcher match = operationRegex.matcher(str);
                if (!match.find()) continue;
                if (str.startsWith("nutrition")) {
                    nutOp = Operator.fromString(match.group(1));
                    nutVal = Float.valueOf(match.group(2)).floatValue();
                    continue;
                }
                if (!str.startsWith("saturation")) continue;
                satOp = Operator.fromString(match.group(1));
                satVal = Float.valueOf(match.group(2)).floatValue();
            }
            Pair values = Pair.of((Object)Float.valueOf(nutVal), (Object)Float.valueOf(satVal));
            Pair ops = Pair.of((Object)((Object)nutOp), (Object)((Object)satOp));
            List<ResourceLocation> food = access.m_175515_(Registries.f_256913_).m_6579_().stream().filter(entry -> {
                FoodProperties props = ((Item)entry.getValue()).getFoodProperties(((Item)entry.getValue()).m_7968_(), null);
                return props != null && ((Operator)((Object)((Object)((Object)ops.getFirst())))).evaluation.test(Float.valueOf(Integer.valueOf(props.m_38744_()).floatValue()), (Float)values.getFirst()) && ((Operator)((Object)((Object)((Object)ops.getSecond())))).evaluation.test(Float.valueOf(props.m_38745_()), (Float)values.getSecond());
            }).map(entry -> ((ResourceKey)entry.getKey()).m_135782_()).toList();
            return new TargetSelector.Selection(ObjectType.ITEM, food);
        });
        TARGETORS.put("tool", (param, access) -> {
            ArrayList<ResourceLocation> tools = new ArrayList<ResourceLocation>();
            if (param.isEmpty()) {
                tools.addAll(access.m_175515_(Registries.f_256913_).m_6579_().stream().filter(entry -> entry.getValue() instanceof TieredItem).map(entry -> ((ResourceKey)entry.getKey()).m_135782_()).toList());
            } else {
                ResourceLocation tag = new ResourceLocation(param);
                tools.addAll(access.m_175515_(Registries.f_256913_).m_203431_(TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)tag)).map(named -> named.m_203614_().filter(holder -> holder.m_203334_() instanceof TieredItem).map(holder -> ((ResourceKey)holder.m_203543_().get()).m_135782_()).toList()).orElse(List.of()));
            }
            return new TargetSelector.Selection(ObjectType.ITEM, tools);
        });
        TARGETORS.put("armor", (param, access) -> {
            ArrayList<ResourceLocation> tools = new ArrayList<ResourceLocation>();
            if (param.isEmpty()) {
                tools.addAll(access.m_175515_(Registries.f_256913_).m_6579_().stream().filter(entry -> entry.getValue() instanceof ArmorItem).map(entry -> ((ResourceKey)entry.getKey()).m_135782_()).toList());
            } else {
                ResourceLocation tag = new ResourceLocation(param);
                tools.addAll(access.m_175515_(Registries.f_256913_).m_203431_(TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)tag)).map(named -> named.m_203614_().filter(holder -> holder.m_203334_() instanceof ArmorItem).map(holder -> ((ResourceKey)holder.m_203543_().get()).m_135782_()).toList()).orElse(List.of()));
            }
            return new TargetSelector.Selection(ObjectType.ITEM, tools);
        });
        TARGETORS.put("weapon", (param, access) -> {
            ArrayList<ResourceLocation> tools = new ArrayList<ResourceLocation>();
            if (param.isEmpty()) {
                tools.addAll(access.m_175515_(Registries.f_256913_).m_6579_().stream().filter(entry -> ((Item)entry.getValue()).getAttributeModifiers(EquipmentSlot.MAINHAND, ((Item)entry.getValue()).m_7968_()).containsKey((Object)Attributes.f_22281_)).map(entry -> ((ResourceKey)entry.getKey()).m_135782_()).toList());
            } else {
                ResourceLocation tag = new ResourceLocation(param);
                tools.addAll(access.m_175515_(Registries.f_256913_).m_203431_(TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)tag)).map(named -> named.m_203614_().filter(holder -> ((Item)holder.m_203334_()).getAttributeModifiers(EquipmentSlot.MAINHAND, ((Item)holder.m_203334_()).m_7968_()).containsKey((Object)Attributes.f_22281_)).map(holder -> ((ResourceKey)holder.m_203543_().get()).m_135782_()).toList()).orElse(List.of()));
            }
            return new TargetSelector.Selection(ObjectType.ITEM, tools);
        });
    }

    private static enum Operator {
        GT((one, two) -> one.floatValue() > two.floatValue()),
        LT((one, two) -> one.floatValue() < two.floatValue()),
        EQ(Float::equals),
        GTE((one, two) -> one.floatValue() >= two.floatValue()),
        LTE((one, two) -> one.floatValue() <= two.floatValue());

        public final BiPredicate<Float, Float> evaluation;

        private Operator(BiPredicate<Float, Float> evaluation) {
            this.evaluation = evaluation;
        }

        public static Operator fromString(String str) {
            return switch (str) {
                case ">" -> GT;
                case "<" -> LT;
                case "=" -> EQ;
                case ">=" -> GTE;
                case "<=" -> LTE;
                default -> null;
            };
        }
    }
}

