/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.events.impl;

import harmonised.pmmo.api.enums.EventType;
import harmonised.pmmo.api.enums.ReqType;
import harmonised.pmmo.core.Core;
import harmonised.pmmo.util.MsLoggy;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.Event;

public class BreakSpeedHandler {
    private static Map<UUID, DetailsCache> resultCache = new HashMap<UUID, DetailsCache>();

    public static void handle(PlayerEvent.BreakSpeed event) {
        Core core = Core.get(event.getEntity().m_9236_());
        if (resultCache.containsKey(event.getEntity().m_20148_()) && BreakSpeedHandler.usingCache(event)) {
            MsLoggy.DEBUG.log(MsLoggy.LOG_CODE.EVENT, "Cache Used. Supplied: {}", Float.valueOf(event.getNewSpeed()));
            return;
        }
        if (!core.isActionPermitted(ReqType.TOOL, event.getEntity().m_21205_(), event.getEntity())) {
            event.setCanceled(true);
            resultCache.put(event.getEntity().m_20148_(), new DetailsCache(event.getEntity().m_21205_(), event.getPosition().orElse(new BlockPos(0, 0, 0)), event.getState(), true, event.getNewSpeed()));
            return;
        }
        if (!core.isActionPermitted(ReqType.BREAK, event.getPosition().orElse(new BlockPos(0, 0, 0)), event.getEntity())) {
            event.setCanceled(true);
            resultCache.put(event.getEntity().m_20148_(), new DetailsCache(event.getEntity().m_21205_(), event.getPosition().orElse(new BlockPos(0, 0, 0)), event.getState(), true, event.getNewSpeed()));
            return;
        }
        CompoundTag eventHookOutput = new CompoundTag();
        if (!event.getEntity().m_9236_().f_46443_ && (eventHookOutput = core.getEventTriggerRegistry().executeEventListeners(EventType.BREAK_SPEED, (Event)event, new CompoundTag())).m_128471_("is_cancelled")) {
            event.setCanceled(true);
            resultCache.put(event.getEntity().m_20148_(), new DetailsCache(event.getEntity().m_21205_(), event.getPosition().orElse(new BlockPos(0, 0, 0)), event.getState(), true, event.getNewSpeed()));
            return;
        }
        CompoundTag perkDataIn = eventHookOutput;
        perkDataIn.m_128350_("speedIn", event.getNewSpeed());
        perkDataIn.m_128356_("block_pos", event.getPosition().orElse(new BlockPos(0, 0, 0)).m_121878_());
        CompoundTag perkDataOut = core.getPerkRegistry().executePerk(EventType.BREAK_SPEED, event.getEntity(), perkDataIn);
        if (perkDataOut.m_128441_("speed")) {
            float newSpeed = event.getNewSpeed() * (1.0f + Math.max(0.0f, perkDataOut.m_128457_("speed")));
            MsLoggy.INFO.log(MsLoggy.LOG_CODE.EVENT, "BreakSpeed Original{}, New:{}", Float.valueOf(event.getOriginalSpeed()), Float.valueOf(newSpeed));
            event.setNewSpeed(newSpeed);
            resultCache.put(event.getEntity().m_20148_(), new DetailsCache(event.getEntity().m_21205_(), event.getPosition().orElse(new BlockPos(0, 0, 0)), event.getState(), event.getEntity().m_20096_(), false, newSpeed));
        }
    }

    private static boolean usingCache(PlayerEvent.BreakSpeed event) {
        DetailsCache cachedData = resultCache.get(event.getEntity().m_20148_());
        if (event.getEntity().m_20096_() == cachedData.isPlayerStanding() && event.getPosition().orElse(new BlockPos(0, 0, 0)).equals((Object)cachedData.pos) && event.getState().equals(cachedData.state) && event.getEntity().m_21205_().equals(cachedData.item, false)) {
            if (cachedData.cancelled) {
                event.setCanceled(true);
            } else {
                event.setNewSpeed(cachedData.newSpeed);
            }
            return true;
        }
        return false;
    }

    private record DetailsCache(ItemStack item, BlockPos pos, BlockState state, boolean isPlayerStanding, boolean cancelled, float newSpeed) {
        public DetailsCache(ItemStack item, BlockPos pos, BlockState state, boolean cancelled, float newSpeed) {
            this(item, pos, state, true, cancelled, newSpeed);
        }
    }
}

