/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.events.impl;

import harmonised.pmmo.api.enums.EventType;
import harmonised.pmmo.config.Config;
import harmonised.pmmo.core.Core;
import harmonised.pmmo.core.CoreUtils;
import harmonised.pmmo.features.party.PartyUtils;
import harmonised.pmmo.util.Functions;
import harmonised.pmmo.util.MsLoggy;
import harmonised.pmmo.util.RegistryUtil;
import harmonised.pmmo.util.TagUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.Event;

public class DamageReceivedHandler {
    public static void handle(LivingHurtEvent event) {
        if (event.getEntity() instanceof Player) {
            Player player = (Player)event.getEntity();
            if (player.equals((Object)event.getSource().m_7639_())) {
                return;
            }
            Core core = Core.get(player.m_9236_());
            String damageType = RegistryUtil.getId(event.getSource()).toString();
            MsLoggy.DEBUG.log(MsLoggy.LOG_CODE.EVENT, "Source Type: " + damageType + " | Source Raw: " + event.getSource().m_19385_(), new Object[0]);
            boolean serverSide = !player.m_9236_().f_46443_;
            CompoundTag eventHookOutput = new CompoundTag();
            if (serverSide && (eventHookOutput = core.getEventTriggerRegistry().executeEventListeners(EventType.RECEIVE_DAMAGE, (Event)event, new CompoundTag())).m_128471_("is_cancelled")) {
                event.setCanceled(true);
                return;
            }
            CompoundTag perkDataIn = eventHookOutput.m_6426_();
            perkDataIn.m_128359_("damage_type", damageType);
            perkDataIn.m_128350_("damageIn", event.getAmount());
            CompoundTag perkOutput = TagUtils.mergeTags(perkDataIn, core.getPerkRegistry().executePerk(EventType.RECEIVE_DAMAGE, player, perkDataIn));
            if (perkOutput.m_128441_("damage")) {
                float damageOut = perkOutput.m_128457_("damage");
                MsLoggy.DEBUG.log(MsLoggy.LOG_CODE.EVENT, "Damage Modified from %s to %s".formatted(Float.valueOf(event.getAmount()), Float.valueOf(damageOut)), new Object[0]);
                event.setAmount(damageOut);
            }
            if (serverSide) {
                perkOutput.m_128359_("damage_type", damageType);
                Map<String, Long> xpAward = DamageReceivedHandler.getExperienceAwards(core, event.getSource(), event.getAmount(), player, perkOutput);
                List<ServerPlayer> partyMembersInRange = PartyUtils.getPartyMembersInRange((ServerPlayer)player);
                core.awardXP(partyMembersInRange, xpAward);
            }
        }
    }

    private static Map<String, Long> getExperienceAwards(Core core, DamageSource source, float damage, Player player, CompoundTag dataIn) {
        HashMap<String, Long> mapOut = new HashMap<String, Long>();
        float ultimateDamage = Mth.m_14036_((float)damage, (float)0.0f, (float)player.m_21223_());
        if (source.m_7639_() != null) {
            core.getExperienceAwards(EventType.RECEIVE_DAMAGE, source.m_7639_(), player, dataIn).forEach((skill, value) -> mapOut.put((String)skill, (long)(value.floatValue() * ultimateDamage)));
        }
        Map<String, Map<String, Long>> config = Config.RECEIVE_DAMAGE_XP.get();
        List<String> tags = config.keySet().stream().filter(str -> {
            if (!str.contains("#")) {
                return false;
            }
            Registry registry = player.m_9236_().m_9598_().m_175515_(Registries.f_268580_);
            Optional tag = registry.m_203431_(TagKey.m_203882_((ResourceKey)Registries.f_268580_, (ResourceLocation)new ResourceLocation(str.substring(1))));
            return tag.map(type -> type.m_203333_(source.m_269150_())).orElse(false);
        }).toList();
        Map tagXp = tags.stream().map(str -> (Map)config.get(str)).reduce((mapA, mapB) -> Functions.mergeMaps(mapA, mapB)).orElse(new HashMap());
        Functions.mergeMaps((Map)config.getOrDefault(RegistryUtil.getId(source).toString(), new HashMap()), tagXp).forEach((skill, xp) -> mapOut.putIfAbsent((String)skill, (long)(xp.floatValue() * ultimateDamage)));
        CoreUtils.applyXpModifiers(mapOut, core.getConsolidatedModifierMap(player));
        return mapOut;
    }
}

