/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.features.autovalues;

import harmonised.pmmo.api.enums.EventType;
import harmonised.pmmo.api.enums.ReqType;
import harmonised.pmmo.features.autovalues.AutoBlock;
import harmonised.pmmo.features.autovalues.AutoValueConfig;
import harmonised.pmmo.util.MsLoggy;
import harmonised.pmmo.util.Reference;
import harmonised.pmmo.util.RegistryUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.ArmorMaterials;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ElytraItem;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.registries.ForgeRegistries;

public class AutoItem {
    private static final double BASE_ATK_SPD = 1.6;
    private static final double BASE_DURABILITY = 59.0;
    private static final double BASE_DAMAGE = 4.0;
    public static final ReqType[] REQTYPES = new ReqType[]{ReqType.WEAR, ReqType.USE_ENCHANTMENT, ReqType.TOOL, ReqType.WEAPON};
    public static final EventType[] EVENTTYPES = new EventType[]{EventType.ANVIL_REPAIR, EventType.BLOCK_PLACE, EventType.CRAFT, EventType.CONSUME, EventType.ENCHANT, EventType.FISH, EventType.SMELT};

    public static Map<String, Integer> processReqs(ReqType type, ResourceLocation stackID) {
        if (!type.itemApplicable || !AutoValueConfig.isReqEnabled(type)) {
            return new HashMap<String, Integer>();
        }
        HashMap<String, Integer> outMap = new HashMap<String, Integer>();
        ItemStack stack = new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(stackID));
        switch (type) {
            case WEAR: {
                if (stack.m_41720_() instanceof TieredItem) {
                    if (stack.m_41720_() instanceof SwordItem) {
                        outMap.putAll(AutoItem.getUtensilData(AutoValueConfig.UtensilTypes.SWORD, type, stack, true));
                        break;
                    }
                    if (stack.m_41720_() instanceof AxeItem) {
                        outMap.putAll(AutoItem.getUtensilData(AutoValueConfig.UtensilTypes.AXE, type, stack, false));
                        break;
                    }
                    if (stack.m_41720_() instanceof PickaxeItem) {
                        outMap.putAll(AutoItem.getUtensilData(AutoValueConfig.UtensilTypes.PICKAXE, type, stack, false));
                        break;
                    }
                    if (stack.m_41720_() instanceof ShovelItem) {
                        outMap.putAll(AutoItem.getUtensilData(AutoValueConfig.UtensilTypes.SHOVEL, type, stack, false));
                        break;
                    }
                    if (!(stack.m_41720_() instanceof HoeItem)) break;
                    outMap.putAll(AutoItem.getUtensilData(AutoValueConfig.UtensilTypes.HOE, type, stack, false));
                    break;
                }
                if (stack.m_41720_() instanceof ArmorItem) {
                    outMap.putAll(AutoItem.getWearableData(type, stack, true));
                    break;
                }
                if (!(stack.m_41720_() instanceof ElytraItem)) break;
                outMap.putAll(AutoItem.getWearableData(type, stack, false));
                break;
            }
            case USE_ENCHANTMENT: {
                double scale = 0.0;
                for (Map.Entry entry : EnchantmentHelper.m_44831_((ItemStack)stack).entrySet()) {
                    scale += (double)((Integer)entry.getValue() / ((Enchantment)entry.getKey()).m_6586_());
                }
                for (Map.Entry<Object, Object> entry : AutoValueConfig.getItemReq(type).entrySet()) {
                    outMap.put((String)entry.getKey(), (int)((double)((Integer)entry.getValue()).intValue() * scale));
                }
                break;
            }
            case TOOL: {
                if (!(stack.m_41720_() instanceof TieredItem)) break;
                if (stack.m_41720_() instanceof SwordItem) {
                    outMap.putAll(AutoItem.getUtensilData(AutoValueConfig.UtensilTypes.SWORD, type, stack, false));
                    break;
                }
                if (stack.m_41720_() instanceof AxeItem) {
                    outMap.putAll(AutoItem.getUtensilData(AutoValueConfig.UtensilTypes.AXE, type, stack, false));
                    break;
                }
                if (stack.m_41720_() instanceof PickaxeItem) {
                    outMap.putAll(AutoItem.getUtensilData(AutoValueConfig.UtensilTypes.PICKAXE, type, stack, false));
                    break;
                }
                if (stack.m_41720_() instanceof ShovelItem) {
                    outMap.putAll(AutoItem.getUtensilData(AutoValueConfig.UtensilTypes.SHOVEL, type, stack, false));
                    break;
                }
                if (!(stack.m_41720_() instanceof HoeItem)) break;
                outMap.putAll(AutoItem.getUtensilData(AutoValueConfig.UtensilTypes.HOE, type, stack, false));
                break;
            }
            case WEAPON: {
                if (!(stack.m_41720_() instanceof TieredItem)) break;
                if (stack.m_41720_() instanceof SwordItem) {
                    outMap.putAll(AutoItem.getUtensilData(AutoValueConfig.UtensilTypes.SWORD, type, stack, true));
                    break;
                }
                if (stack.m_41720_() instanceof AxeItem) {
                    outMap.putAll(AutoItem.getUtensilData(AutoValueConfig.UtensilTypes.AXE, type, stack, true));
                    break;
                }
                if (stack.m_41720_() instanceof PickaxeItem) {
                    outMap.putAll(AutoItem.getUtensilData(AutoValueConfig.UtensilTypes.PICKAXE, type, stack, true));
                    break;
                }
                if (stack.m_41720_() instanceof ShovelItem) {
                    outMap.putAll(AutoItem.getUtensilData(AutoValueConfig.UtensilTypes.SHOVEL, type, stack, true));
                    break;
                }
                if (!(stack.m_41720_() instanceof HoeItem)) break;
                outMap.putAll(AutoItem.getUtensilData(AutoValueConfig.UtensilTypes.HOE, type, stack, true));
                break;
            }
            case BREAK: {
                if (!(stack.m_41720_() instanceof BlockItem)) break;
                outMap.putAll(AutoBlock.processReqs(type, stackID));
                break;
            }
        }
        return outMap;
    }

    public static Map<String, Long> processXpGains(EventType type, ResourceLocation stackID) {
        if (!type.itemApplicable || !AutoValueConfig.isXpGainEnabled(type)) {
            return new HashMap<String, Long>();
        }
        HashMap<String, Long> outMap = new HashMap<String, Long>();
        ItemStack stack = new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(stackID));
        switch (type) {
            case ANVIL_REPAIR: {
                if (!stack.isRepairable()) break;
                AutoValueConfig.getItemXpAward(type).forEach((skill, xp) -> outMap.put((String)skill, (long)((double)xp.longValue() * ((double)stack.m_41776_() * 0.25))));
                break;
            }
            case BLOCK_PLACE: 
            case BLOCK_BREAK: {
                if (!(stack.m_41720_() instanceof BlockItem)) break;
                outMap.putAll(AutoBlock.processXpGains(type, RegistryUtil.getId(((BlockItem)stack.m_41720_()).m_40614_())));
                break;
            }
            case CRAFT: {
                if (stack.m_41720_() instanceof TieredItem) {
                    if (stack.m_41720_() instanceof SwordItem) {
                        outMap.putAll(AutoItem.getUtensilData(AutoValueConfig.UtensilTypes.SWORD, type, stack, true));
                        break;
                    }
                    if (stack.m_41720_() instanceof AxeItem) {
                        outMap.putAll(AutoItem.getUtensilData(AutoValueConfig.UtensilTypes.AXE, type, stack, false));
                        break;
                    }
                    if (stack.m_41720_() instanceof PickaxeItem) {
                        outMap.putAll(AutoItem.getUtensilData(AutoValueConfig.UtensilTypes.PICKAXE, type, stack, false));
                        break;
                    }
                    if (stack.m_41720_() instanceof ShovelItem) {
                        outMap.putAll(AutoItem.getUtensilData(AutoValueConfig.UtensilTypes.SHOVEL, type, stack, false));
                        break;
                    }
                    if (!(stack.m_41720_() instanceof HoeItem)) break;
                    outMap.putAll(AutoItem.getUtensilData(AutoValueConfig.UtensilTypes.HOE, type, stack, false));
                    break;
                }
                if (stack.m_41720_() instanceof ArmorItem) {
                    outMap.putAll(AutoItem.getWearableData(type, stack, true));
                    break;
                }
                if (stack.m_41720_() instanceof ElytraItem) {
                    outMap.putAll(AutoItem.getWearableData(type, stack, false));
                    break;
                }
                outMap.putAll(AutoValueConfig.getItemXpAward(type));
                break;
            }
            case CONSUME: {
                if (stack.m_41720_().m_41473_() != null) {
                    FoodProperties properties = stack.m_41720_().m_41473_();
                    float nutritionScale = (float)properties.m_38744_() * properties.m_38745_();
                    AutoValueConfig.getItemXpAward(type).forEach((skill, xp) -> {
                        Float xpAward = Float.valueOf(nutritionScale * (float)xp.longValue());
                        outMap.put((String)skill, xpAward.longValue());
                    });
                }
            }
            case BREW: {
                if (!ForgeRegistries.ITEMS.tags().getTag(Reference.BREWABLES).contains((Object)stack.m_41720_())) break;
                outMap.putAll(AutoValueConfig.BREWABLES_OVERRIDE.get());
                break;
            }
            case SMELT: {
                if (!ForgeRegistries.ITEMS.tags().getTag(Reference.SMELTABLES).contains((Object)stack.m_41720_())) break;
                outMap.putAll(AutoValueConfig.SMELTABLES_OVERRIDE.get());
                break;
            }
            case ENCHANT: 
            case FISH: {
                outMap.putAll(AutoValueConfig.getItemXpAward(type));
                break;
            }
        }
        return outMap;
    }

    private static Map<String, Integer> getUtensilData(AutoValueConfig.UtensilTypes utensil, ReqType type, ItemStack stack, boolean asWeapon) {
        HashMap<String, Integer> outMap = new HashMap<String, Integer>();
        if (stack.m_41720_() instanceof TieredItem && AutoItem.getTier((TieredItem)stack.m_41720_()) <= 0.0) {
            return outMap;
        }
        double scale = AutoItem.getUtensilAttributes(utensil, stack, asWeapon);
        Map<String, Integer> configValue = type == ReqType.TOOL || type == ReqType.WEAR && !asWeapon ? AutoValueConfig.getToolReq(stack) : (type == ReqType.WEAR && asWeapon ? AutoValueConfig.getItemReq(ReqType.WEAPON) : AutoValueConfig.getItemReq(type));
        configValue.forEach((skill, level) -> outMap.put((String)skill, (int)Math.max(0.0, (double)level.intValue() * scale)));
        MsLoggy.DEBUG.log(MsLoggy.LOG_CODE.AUTO_VALUES, "AutoItem Req Map: " + MsLoggy.mapToString(outMap), new Object[0]);
        return outMap;
    }

    private static Map<String, Long> getUtensilData(AutoValueConfig.UtensilTypes utensil, EventType type, ItemStack stack, boolean asWeapon) {
        HashMap<String, Long> outMap = new HashMap<String, Long>();
        double scale = AutoItem.getUtensilAttributes(utensil, stack, asWeapon);
        AutoValueConfig.getItemXpAward(type).forEach((skill, level) -> outMap.put((String)skill, Double.valueOf(Math.max(0.0, (double)level.longValue() * scale)).longValue()));
        MsLoggy.DEBUG.log(MsLoggy.LOG_CODE.AUTO_VALUES, "AutoItem XpGain Map: " + MsLoggy.mapToString(outMap), new Object[0]);
        return outMap;
    }

    private static Map<String, Integer> getWearableData(ReqType type, ItemStack stack, boolean isArmor) {
        HashMap<String, Integer> outMap = new HashMap<String, Integer>();
        if (stack.m_41720_() instanceof ArmorItem && ((ArmorItem)stack.m_41720_()).m_40401_().equals(ArmorMaterials.LEATHER)) {
            return outMap;
        }
        double scale = AutoItem.getWearableAttributes(AutoValueConfig.WearableTypes.fromSlot(LivingEntity.m_147233_((ItemStack)stack), !isArmor), stack, isArmor);
        AutoValueConfig.getItemReq(type).forEach((skill, level) -> outMap.put((String)skill, (int)Math.max(0.0, (double)level.intValue() * scale)));
        return outMap;
    }

    private static Map<String, Long> getWearableData(EventType type, ItemStack stack, boolean isArmor) {
        HashMap<String, Long> outMap = new HashMap<String, Long>();
        double scale = AutoItem.getWearableAttributes(AutoValueConfig.WearableTypes.fromSlot(LivingEntity.m_147233_((ItemStack)stack), !isArmor), stack, isArmor);
        AutoValueConfig.getItemXpAward(type).forEach((skill, level) -> outMap.put((String)skill, Double.valueOf(Math.max(0.0, (double)level.longValue() * scale)).longValue()));
        return outMap;
    }

    private static double getAttributeAmount(ItemStack stack, EquipmentSlot slot, Attribute attribute) {
        return stack.m_41638_(slot).get((Object)attribute).stream().collect(Collectors.summingDouble(a -> a.m_22218_()));
    }

    private static double getTier(TieredItem item) {
        return item.m_43314_().m_6604_();
    }

    private static double getDamage(ItemStack stack) {
        return AutoItem.getAttributeAmount(stack, EquipmentSlot.MAINHAND, Attributes.f_22281_) + (double)EnchantmentHelper.m_44833_((ItemStack)stack, null) - 4.0;
    }

    private static double getAttackSpeed(ItemStack stack) {
        return Math.abs(AutoItem.getAttributeAmount(stack, EquipmentSlot.MAINHAND, Attributes.f_22283_)) - 1.6;
    }

    private static double getDurability(ItemStack stack) {
        return (double)stack.m_41776_() - 59.0;
    }

    private static double getUtensilAttributes(AutoValueConfig.UtensilTypes type, ItemStack stack, boolean asWeapon) {
        double durabilityScale = AutoItem.getDurability(stack) * AutoValueConfig.getUtensilAttribute(type, AutoValueConfig.AttributeKey.DUR);
        double tierScale = AutoItem.getTier((TieredItem)stack.m_41720_()) * AutoValueConfig.getUtensilAttribute(type, AutoValueConfig.AttributeKey.TIER);
        double damageScale = asWeapon ? AutoItem.getDamage(stack) * AutoValueConfig.getUtensilAttribute(type, AutoValueConfig.AttributeKey.DMG) : 0.0;
        double atkSpdScale = asWeapon ? AutoItem.getAttackSpeed(stack) * AutoValueConfig.getUtensilAttribute(type, AutoValueConfig.AttributeKey.SPD) : 0.0;
        double digSpeedScale = asWeapon ? 0.0 : (double)stack.m_41691_(Blocks.f_50033_.m_49966_()) + AutoValueConfig.getUtensilAttribute(type, AutoValueConfig.AttributeKey.DIG);
        MsLoggy.DEBUG.log(MsLoggy.LOG_CODE.AUTO_VALUES, "AutoItem Attributes: DUR=" + durabilityScale + " TIER=" + tierScale + " DMG=" + damageScale + " SPD=" + atkSpdScale + " DIG=" + digSpeedScale, new Object[0]);
        return damageScale + atkSpdScale + digSpeedScale + durabilityScale + tierScale;
    }

    private static double getWearableAttributes(AutoValueConfig.WearableTypes type, ItemStack stack, boolean isArmor) {
        double durabilityScale = (double)stack.m_41776_() * AutoValueConfig.getWearableAttribute(type, AutoValueConfig.AttributeKey.DUR);
        ArmorMaterial material = isArmor ? ((ArmorItem)stack.m_41720_()).m_40401_() : null;
        double armorScale = isArmor ? (double)material.m_7366_(((ArmorItem)stack.m_41720_()).m_266204_()) * AutoValueConfig.getWearableAttribute(type, AutoValueConfig.AttributeKey.AMR) : 0.0;
        double toughnessScale = isArmor ? (double)material.m_6651_() * AutoValueConfig.getWearableAttribute(type, AutoValueConfig.AttributeKey.TUF) : 0.0;
        double knockbackScale = isArmor ? (double)material.m_6649_() * AutoValueConfig.getWearableAttribute(type, AutoValueConfig.AttributeKey.KBR) : 0.0;
        MsLoggy.DEBUG.log(MsLoggy.LOG_CODE.AUTO_VALUES, "AutoItem Attributes: DUR=" + durabilityScale + " ARM=" + armorScale + " TUF=" + toughnessScale + " KBR=" + knockbackScale, new Object[0]);
        return durabilityScale + armorScale + toughnessScale + knockbackScale;
    }
}

