/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.features.loot_modifiers;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import harmonised.pmmo.config.Config;
import harmonised.pmmo.core.Core;
import harmonised.pmmo.util.MsLoggy;
import harmonised.pmmo.util.RegistryUtil;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class RareDropModifier
extends LootModifier {
    public static final Codec<RareDropModifier> CODEC = RecordCodecBuilder.create(instance -> RareDropModifier.codecStart((RecordCodecBuilder.Instance)instance).and(instance.group((App)ResourceLocation.f_135803_.fieldOf("item").forGetter(tlm -> RegistryUtil.getId(tlm.drop)), (App)Codec.INT.fieldOf("count").forGetter(tlm -> tlm.drop.m_41613_()), (App)Codec.DOUBLE.fieldOf("chance").forGetter(tlm -> tlm.chance), (App)Codec.BOOL.optionalFieldOf("per_level").forGetter(tlm -> Optional.of(tlm.perLevel)), (App)Codec.STRING.optionalFieldOf("skill").forGetter(tlm -> Optional.of(tlm.skill)))).apply((Applicative)instance, RareDropModifier::new));
    public ItemStack drop;
    public double chance;
    public boolean perLevel;
    public String skill;

    public RareDropModifier(LootItemCondition[] conditionsIn, ResourceLocation lootItemID, int count, double chance) {
        this(conditionsIn, lootItemID, count, chance, Optional.of(false), Optional.empty());
    }

    public RareDropModifier(LootItemCondition[] conditionsIn, ResourceLocation lootItemID, int count, double chance, Optional<Boolean> perLevel, Optional<String> skill) {
        super(conditionsIn);
        this.chance = chance;
        this.drop = new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(lootItemID));
        this.drop.m_41764_(count);
        this.perLevel = perLevel.orElse(false);
        this.skill = skill.orElse("");
    }

    public LootItemCondition[] getConditions() {
        return this.conditions;
    }

    public Codec<? extends IGlobalLootModifier> codec() {
        return CODEC;
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        double rand;
        Object object;
        if (!((Boolean)Config.TREASURE_ENABLED.get()).booleanValue()) {
            return generatedLoot;
        }
        if (this.perLevel && (object = context.m_165124_(LootContextParams.f_81455_)) instanceof Player) {
            Player player = (Player)object;
            this.chance *= (double)Core.get(player.m_9236_()).getData().getPlayerSkillLevel(this.skill, player.m_20148_());
        }
        if ((rand = MsLoggy.DEBUG.logAndReturn(context.m_230907_().m_188500_(), MsLoggy.LOG_CODE.FEATURE, "Rand: {} as test for " + this.drop.serializeNBT().toString(), new Object[0]).doubleValue()) <= this.chance) {
            generatedLoot.add((Object)this.drop.m_41777_());
        }
        return generatedLoot;
    }
}

