/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.features.mobscaling;

import harmonised.pmmo.config.Config;
import harmonised.pmmo.config.codecs.LocationData;
import harmonised.pmmo.config.codecs.MobModifier;
import harmonised.pmmo.core.Core;
import harmonised.pmmo.util.MsLoggy;
import harmonised.pmmo.util.Reference;
import harmonised.pmmo.util.RegistryUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.Tags;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.MobSpawnEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="pmmo", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class MobAttributeHandler {
    private static final UUID ADDITION_MODIFIER_ID = UUID.fromString("c95a6e8c-a1c3-4177-9118-1e2cf49b7fcd");
    private static final UUID MULTIPLY_BASE_MODIFIER_ID = UUID.fromString("c95a6e8c-a1c3-4177-9118-1e2cf49b7fce");
    private static final UUID MULTIPLY_TOTAL_MODIFIER_ID = UUID.fromString("c95a6e8c-a1c3-4177-9118-1e2cf49b7fcf");
    private static final Map<ResourceLocation, Float> CAPS = Map.of(new ResourceLocation("generic.max_health"), Float.valueOf(1024.0f), new ResourceLocation("generic.movement_speed"), Float.valueOf(1.5f), new ResourceLocation("generic.attack_damage"), Float.valueOf(2048.0f), new ResourceLocation("zombie.spawn_reinforcements"), Float.valueOf(1.0f));

    @SubscribeEvent
    public static void onBossAdd(EntityJoinLevelEvent event) {
        Entity entity;
        if (!((Boolean)Config.MOB_SCALING_ENABLED.get()).booleanValue()) {
            return;
        }
        if (event.getEntity().m_6095_().m_204039_(Tags.EntityTypes.BOSSES) && (entity = event.getEntity()) instanceof LivingEntity) {
            LivingEntity entity2 = (LivingEntity)entity;
            entity = event.getLevel();
            if (entity instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)entity;
                MobAttributeHandler.handle(entity2, level, new Vec3(entity2.m_20185_(), entity2.m_20186_(), entity2.m_20189_()), level.m_46791_().m_19028_());
            }
        }
    }

    @SubscribeEvent
    public static void onMobSpawn(MobSpawnEvent.FinalizeSpawn event) {
        if (!((Boolean)Config.MOB_SCALING_ENABLED.get()).booleanValue()) {
            return;
        }
        if (event.getEntity().m_6095_().m_204039_(Reference.MOB_TAG)) {
            MobAttributeHandler.handle((LivingEntity)event.getEntity(), event.getLevel().m_6018_(), new Vec3(event.getX(), event.getY(), event.getZ()), event.getLevel().m_46791_().m_19028_());
        }
    }

    private static void handle(LivingEntity entity, ServerLevel level, Vec3 spawnPos, int diffScale) {
        int range = (Integer)Config.MOB_SCALING_AOE.get();
        TargetingConditions targetCondition = TargetingConditions.m_148353_().m_26893_().m_148355_().m_26883_(Math.pow(range, 2.0) * 3.0);
        List nearbyPlayers = level.m_45955_(targetCondition, entity, AABB.m_165882_((Vec3)spawnPos, (double)range, (double)range, (double)range));
        MsLoggy.DEBUG.log(MsLoggy.LOG_CODE.FEATURE, "NearbyPlayers on Spawn: " + MsLoggy.listToString(nearbyPlayers), new Object[0]);
        Core core = Core.get((Level)level.m_6018_());
        LocationData dimData = core.getLoader().DIMENSION_LOADER.getData(level.m_6018_().m_46472_().m_135782_());
        LocationData bioData = core.getLoader().BIOME_LOADER.getData(RegistryUtil.getId((Holder<Biome>)level.m_204166_(entity.m_20097_())));
        List dimMods = dimData.mobModifiers().getOrDefault(RegistryUtil.getId((Entity)entity), new ArrayList(0));
        List bioMods = bioData.mobModifiers().getOrDefault(RegistryUtil.getId((Entity)entity), new ArrayList(0));
        List<MobModifier> globalDimMods = dimData.globalMobModifiers();
        List<MobModifier> globalBioMods = bioData.globalMobModifiers();
        List<MobModifier> mergedModifiers = MobAttributeHandler.mergeModifiers(Stream.of(dimMods, bioMods, globalDimMods, globalBioMods).collect(Collectors.toList()));
        float bossMultiplier = entity.m_6095_().m_204039_(Tags.EntityTypes.BOSSES) ? ((Double)Config.BOSS_SCALING_RATIO.get()).floatValue() : 1.0f;
        MobAttributeHandler.computeAndApplyModifiers(entity, mergedModifiers, nearbyPlayers, diffScale, bossMultiplier);
        entity.m_21153_(entity.m_21233_());
    }

    private static List<MobModifier> mergeModifiers(List<List<MobModifier>> modifiers) {
        return modifiers.stream().flatMap(Collection::stream).collect(Collectors.toList());
    }

    private static void computeAndApplyModifiers(LivingEntity entity, List<MobModifier> modifiers, List<Player> nearbyPlayers, int diffScale, float bossMultiplier) {
        ArrayList<MobModifier> additionModifiers = new ArrayList<MobModifier>();
        ArrayList<MobModifier> multiplyBaseModifiers = new ArrayList<MobModifier>();
        ArrayList<MobModifier> multiplyTotalModifiers = new ArrayList<MobModifier>();
        modifiers.forEach(mod -> {
            switch (mod.operation()) {
                case ADDITION: {
                    additionModifiers.add((MobModifier)mod);
                    break;
                }
                case MULTIPLY_BASE: {
                    multiplyBaseModifiers.add((MobModifier)mod);
                    break;
                }
                case MULTIPLY_TOTAL: {
                    multiplyTotalModifiers.add((MobModifier)mod);
                }
            }
        });
        modifiers.clear();
        HashMap<ResourceLocation, Double> collapsedAdditionModifiers = MobAttributeHandler.collapseModifiers(additionModifiers);
        HashMap<ResourceLocation, Double> collapsedMultiplyBaseModifiers = MobAttributeHandler.collapseModifiers(multiplyBaseModifiers);
        HashMap<ResourceLocation, Double> collapsedMultiplyTotalModifiers = MobAttributeHandler.collapseModifiers(multiplyTotalModifiers);
        Map<ResourceLocation, Map<String, Double>> mobScalingMultipliers = Config.MOB_SCALING.get();
        MobAttributeHandler.applyMobScaling(collapsedAdditionModifiers, entity, mobScalingMultipliers, nearbyPlayers, diffScale);
        MobAttributeHandler.applyBossMultiplier(collapsedAdditionModifiers, bossMultiplier);
        MobAttributeHandler.applyModifiers(entity, ADDITION_MODIFIER_ID, AttributeModifier.Operation.ADDITION, collapsedAdditionModifiers);
        MobAttributeHandler.applyModifiers(entity, MULTIPLY_BASE_MODIFIER_ID, AttributeModifier.Operation.MULTIPLY_BASE, collapsedMultiplyBaseModifiers);
        MobAttributeHandler.applyModifiers(entity, MULTIPLY_TOTAL_MODIFIER_ID, AttributeModifier.Operation.MULTIPLY_TOTAL, collapsedMultiplyTotalModifiers);
    }

    private static void applyModifiers(LivingEntity entity, UUID modifierId, AttributeModifier.Operation operation, Map<ResourceLocation, Double> collapsedModifiers) {
        collapsedModifiers.forEach((attributeID, amount) -> {
            if (Math.abs(amount) < (double)1.0E-4f) {
                return;
            }
            Attribute attribute = (Attribute)ForgeRegistries.ATTRIBUTES.getValue(attributeID);
            if (attribute == null) {
                return;
            }
            AttributeInstance attributeInstance = entity.m_21051_(attribute);
            if (attributeInstance == null) {
                return;
            }
            AttributeModifier modifier = new AttributeModifier(modifierId, "Boost to Mob Scaling", amount.doubleValue(), operation);
            attributeInstance.m_22120_(modifierId);
            attributeInstance.m_22125_(modifier);
            MsLoggy.DEBUG.log(MsLoggy.LOG_CODE.FEATURE, "Entity={} Attribute={} value={} operation={}", entity.m_5446_().getString(), attributeID, amount, operation);
        });
    }

    private static HashMap<ResourceLocation, Double> collapseModifiers(List<MobModifier> modifiers) {
        HashMap<ResourceLocation, Double> modifierMap = new HashMap<ResourceLocation, Double>();
        for (MobModifier mod : modifiers) {
            if (modifierMap.containsKey(mod.attribute())) {
                modifierMap.put(mod.attribute(), modifierMap.get(mod.attribute()) + mod.amount());
                continue;
            }
            modifierMap.put(mod.attribute(), mod.amount());
        }
        return modifierMap;
    }

    private static void applyMobScaling(HashMap<ResourceLocation, Double> collapsedModifiers, LivingEntity entity, Map<ResourceLocation, Map<String, Double>> config, List<Player> nearbyPlayers, int difficultyScale) {
        config.forEach((attributeID, configMap) -> {
            Float cap;
            Map attributeScalingConfig = config.getOrDefault(attributeID, new HashMap());
            if (attributeScalingConfig.isEmpty()) {
                return;
            }
            Attribute attribute = (Attribute)ForgeRegistries.ATTRIBUTES.getValue(attributeID);
            if (attribute == null) {
                return;
            }
            AttributeInstance attributeInstance = entity.m_21051_(attribute);
            if (attributeInstance == null) {
                return;
            }
            double baseValue = MobAttributeHandler.baseValue(entity, attributeID, attributeInstance);
            float bonus = MobAttributeHandler.getBonus(nearbyPlayers, attributeScalingConfig, difficultyScale, baseValue, (cap = CAPS.getOrDefault(attributeID, Float.valueOf(Float.MAX_VALUE))).floatValue());
            if (Math.abs(bonus) < 1.0E-4f) {
                return;
            }
            if (collapsedModifiers.containsKey(attributeID)) {
                collapsedModifiers.put((ResourceLocation)attributeID, (Double)collapsedModifiers.get(attributeID) + (double)bonus);
            } else {
                collapsedModifiers.put((ResourceLocation)attributeID, Double.valueOf(bonus));
            }
        });
    }

    private static void applyBossMultiplier(HashMap<ResourceLocation, Double> collapsedModifiers, float multiplier) {
        if (Math.abs(multiplier - 1.0f) < 1.0E-4f) {
            return;
        }
        collapsedModifiers.replaceAll((attribute, value) -> value * (double)multiplier);
    }

    private static double baseValue(LivingEntity entity, ResourceLocation id, AttributeInstance ai) {
        return switch (id.toString()) {
            case "minecraft:generic.attack_damage" -> 1.0;
            case "minecraft:generic.movement_speed" -> entity.m_6113_();
            default -> ai.m_22115_();
        };
    }

    private static float getBonus(List<Player> nearbyPlayers, Map<String, Double> config, int scale, double ogValue, float cap) {
        HashMap totalLevel = new HashMap();
        if (nearbyPlayers.isEmpty()) {
            return 0.0f;
        }
        nearbyPlayers.forEach(player -> config.keySet().stream().collect(Collectors.toMap(str -> str, str -> Core.get(player.m_9236_()).getData().getPlayerSkillLevel((String)str, player.m_20148_()))).forEach((skill, level) -> totalLevel.merge(skill, (Integer)level, Integer::sum)));
        float outValue = 0.0f;
        for (Map.Entry<String, Double> configEntry : config.entrySet()) {
            int averageLevel = totalLevel.getOrDefault(configEntry.getKey(), 0) / nearbyPlayers.size();
            if (averageLevel < (Integer)Config.MOB_SCALING_BASE_LEVEL.get()) continue;
            outValue = (float)((double)outValue + ((Boolean)Config.MOB_USE_EXPONENTIAL_FORMULA.get() != false ? Math.pow((Double)Config.MOB_EXPONENTIAL_POWER_BASE.get(), (Double)Config.MOB_EXPONENTIAL_LEVEL_MOD.get() * (double)(averageLevel - (Integer)Config.MOB_SCALING_BASE_LEVEL.get())) : (double)(averageLevel - (Integer)Config.MOB_SCALING_BASE_LEVEL.get()) * (Double)Config.MOB_LINEAR_PER_LEVEL.get()));
            outValue = (float)((double)outValue * configEntry.getValue());
        }
        MsLoggy.DEBUG.log(MsLoggy.LOG_CODE.FEATURE, "Modifier Value: " + outValue * (float)scale, new Object[0]);
        return (double)outValue + ogValue > (double)cap ? cap : (outValue *= (float)scale);
    }
}

