/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.features.veinmining;

import harmonised.pmmo.api.enums.ReqType;
import harmonised.pmmo.compat.curios.CurioCompat;
import harmonised.pmmo.config.Config;
import harmonised.pmmo.config.codecs.VeinData;
import harmonised.pmmo.core.Core;
import harmonised.pmmo.features.veinmining.VeinShapeData;
import harmonised.pmmo.features.veinmining.capability.VeinProvider;
import harmonised.pmmo.network.Networking;
import harmonised.pmmo.network.clientpackets.CP_SyncVein;
import harmonised.pmmo.util.MsLoggy;
import harmonised.pmmo.util.RegistryUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public class VeinMiningLogic {
    public static final String VEIN_DATA = "vein_data";
    public static final String CURRENT_CHARGE = "vein_charge";
    public static final Map<UUID, Integer> maxBlocksPerPlayer = new HashMap<UUID, Integer>();
    public static final Map<UUID, VeinShapeData.ShapeType> shapePerPlayer = new HashMap<UUID, VeinShapeData.ShapeType>();

    public static void applyVein(ServerPlayer player, BlockPos pos) {
        if (!((Boolean)Config.VEIN_ENABLED.get()).booleanValue()) {
            return;
        }
        ServerLevel level = player.m_284548_();
        Block block = level.m_8055_(pos).m_60734_();
        int cost = Core.get((Level)level).getBlockConsume(block);
        if (cost <= 0) {
            return;
        }
        int charge = VeinMiningLogic.getCurrentCharge((Player)player);
        int consumed = 0;
        int maxBlocks = Math.min(charge / cost, maxBlocksPerPlayer.computeIfAbsent(player.m_20148_(), id -> 64));
        VeinShapeData.ShapeType mode = shapePerPlayer.computeIfAbsent(player.m_20148_(), id -> VeinShapeData.ShapeType.AOE);
        VeinShapeData veinData = new VeinShapeData((Level)level, pos, maxBlocks, mode, player.m_6350_());
        for (BlockPos veinable : veinData.getVein()) {
            consumed += cost;
            player.f_8941_.m_215116_(veinable, 1, "Vein Break");
        }
        MsLoggy.DEBUG.log(MsLoggy.LOG_CODE.FEATURE, "Vein Consumed: " + consumed + " charge", new Object[0]);
        VeinMiningLogic.applyChargeCost(player, consumed, charge);
    }

    public static void regenerateVein(ServerPlayer player) {
        if (!((Boolean)Config.VEIN_ENABLED.get()).booleanValue()) {
            return;
        }
        Inventory inv = player.m_150109_();
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        items.addAll((Collection<ItemStack>)inv.f_35975_);
        items.add(inv.m_36056_());
        items.addAll((Collection<ItemStack>)inv.f_35976_);
        if (CurioCompat.hasCurio) {
            items = new ArrayList(items);
            items.addAll(CurioCompat.getItems((Player)player));
        }
        Core core = Core.get(player.m_9236_());
        double currentCharge = VeinMiningLogic.getCurrentCharge((Player)player);
        int chargeCap = (Integer)Config.BASE_CHARGE_CAP.get();
        double chargeRate = (Double)Config.BASE_CHARGE_RATE.get();
        for (ItemStack stack : items) {
            if (!core.isActionPermitted(ReqType.WEAR, stack, (Player)player)) continue;
            VeinData data = core.getLoader().ITEM_LOADER.getData(RegistryUtil.getId(stack)).veinData();
            if (!data.chargeRate.isPresent()) continue;
            chargeCap += data.chargeCap.orElse(0).intValue();
            chargeRate += data.chargeRate.orElse(0.0).doubleValue();
        }
        if (chargeRate == 0.0 || chargeCap == 0 || currentCharge >= (double)chargeCap) {
            return;
        }
        int fCap = chargeCap;
        double fRate = chargeRate * (Double)Config.VEIN_CHARGE_MODIFIER.get();
        if (currentCharge + fRate >= (double)fCap) {
            player.getCapability(VeinProvider.VEIN_CAP).ifPresent(vein -> {
                vein.setCharge(fCap);
                MsLoggy.DEBUG.log(MsLoggy.LOG_CODE.FEATURE, "Regen at Cap: " + fCap, new Object[0]);
                Networking.sendToClient(new CP_SyncVein(fCap), player);
            });
        } else {
            player.getCapability(VeinProvider.VEIN_CAP).ifPresent(vein -> {
                vein.setCharge(vein.getCharge() + fRate);
                MsLoggy.DEBUG.log(MsLoggy.LOG_CODE.FEATURE, "Regen: " + (vein.getCharge() + fRate), new Object[0]);
                Networking.sendToClient(new CP_SyncVein(vein.getCharge() + fRate), player);
            });
        }
    }

    public static int getCurrentCharge(Player player) {
        return player.getCapability(VeinProvider.VEIN_CAP).map(vein -> (int)vein.getCharge()).orElse(0);
    }

    public static int getMaxChargeFromAllItems(Player player) {
        Inventory inv = player.m_150109_();
        List<ItemStack> items = List.of(inv.m_8020_(36), inv.m_8020_(37), inv.m_8020_(38), inv.m_8020_(39), player.m_21205_(), player.m_21206_());
        if (CurioCompat.hasCurio) {
            items = new ArrayList<ItemStack>(items);
            items.addAll(CurioCompat.getItems(player));
        }
        int totalCapacity = (Integer)Config.BASE_CHARGE_CAP.get();
        for (ItemStack stack : items) {
            if (!Core.get(player.m_9236_()).isActionPermitted(ReqType.WEAR, stack, player)) continue;
            totalCapacity += Core.get((Level)player.m_9236_()).getLoader().ITEM_LOADER.getData((ResourceLocation)RegistryUtil.getId((ItemStack)stack)).veinData().chargeCap.orElse(0).intValue();
        }
        MsLoggy.DEBUG.log(MsLoggy.LOG_CODE.FEATURE, "Vein Capacity: " + totalCapacity, new Object[0]);
        return totalCapacity;
    }

    private static void applyChargeCost(ServerPlayer player, int cost, double currentCharge) {
        player.getCapability(VeinProvider.VEIN_CAP).ifPresent(vein -> vein.setCharge(currentCharge - (double)cost));
        Networking.sendToClient(new CP_SyncVein(currentCharge - (double)cost), player);
    }
}

