/*
 * Decompiled with CFR 0.152.
 */
package io.github.fnewell;

import io.github.fnewell.CommandUtils;
import io.github.fnewell.DataUtils;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeepXP
implements ModInitializer {
    public static final String MODID = "keep-xp";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"keep-xp");
    private static MinecraftServer server;
    public static boolean keepXPoverride;
    public static boolean permissionsAPI;

    public void onInitialize() {
        ServerLifecycleEvents.SERVER_STARTED.register(this::onServerStarted);
        CommandUtils.RegisterCommands();
    }

    private void onServerStarted(MinecraftServer server) {
        KeepXP.server = server;
        DataUtils serverState = DataUtils.getServerState(server);
        keepXPoverride = serverState.keepXPoverride;
        permissionsAPI = FabricLoader.getInstance().isModLoaded("fabric-permissions-api-v0");
        if (keepXPoverride) {
            LOGGER.info("KeepXP is turned on for all players (override).");
        } else if (permissionsAPI) {
            LOGGER.info("Permissions API found. KeepXP is turned on for players based on permissions.");
        } else {
            LOGGER.info("Permissions API not found. KeepXP is turned on for all players.");
        }
    }

    public static MinecraftServer getServer() {
        return server;
    }

    static {
        keepXPoverride = false;
        permissionsAPI = false;
    }
}

