/*
 * Decompiled with CFR 0.152.
 */
package com.razznature.decocraft;

import com.razznature.decocraft.Decocraft;
import com.razznature.decocraft.client.ClientHandler;
import com.razznature.decocraft.models.bbmodel.BBModelGeometryLoader;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.IExtensionPoint;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.gui.ConfigurationScreen;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import net.neoforged.neoforge.client.model.geometry.IGeometryLoader;

@Mod(value="decocraft_nature", dist={Dist.CLIENT})
@EventBusSubscriber(modid="decocraft_nature", value={Dist.CLIENT})
public class DecocraftClient {
    public DecocraftClient(ModContainer container) {
        Decocraft.LOGGER.info("Decocraft client mod constructor started");
        container.registerExtensionPoint(IConfigScreenFactory.class, (IExtensionPoint)((IConfigScreenFactory)ConfigurationScreen::new));
        container.getEventBus().addListener(event -> {
            Decocraft.LOGGER.info("Registering BBModel geometry loader...");
            event.register(ResourceLocation.fromNamespaceAndPath((String)"decocraft_nature", (String)"bbmodel"), (IGeometryLoader)BBModelGeometryLoader.INSTANCE);
            Decocraft.LOGGER.info("BBModel geometry loader registered successfully");
        });
        Decocraft.LOGGER.info("Decocraft client mod constructor complete");
    }

    @SubscribeEvent
    public static void onClientSetup(FMLClientSetupEvent event) {
        Decocraft.LOGGER.info("Decocraft client setup started");
        event.enqueueWork(() -> {
            ClientHandler.setup();
            Decocraft.LOGGER.info("Decocraft client setup complete");
        });
    }
}

