/*
 * Decompiled with CFR 0.152.
 */
package com.razznature.decocraft.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.razznature.decocraft.models.bbmodel.BBModelParts;
import com.razznature.decocraft.models.bbmodel.BlockbenchLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Matrix3fc;
import org.joml.Vector3f;

@OnlyIn(value=Dist.CLIENT)
public class AnimatedModelRenderer {
    public final String name;
    public final BBModelParts.Element element;
    private final int textureWidth;
    private final int textureHeight;
    private final BlockbenchLoader.BlockbenchSetting settings;
    private boolean mirror;
    public float pitch;
    public float yaw;
    public float roll;
    public float pivotX;
    public float pivotY;
    public float pivotZ;
    private static final ThreadLocal<float[][]> VERTEX_POOL = ThreadLocal.withInitial(() -> new float[][]{new float[3], new float[3], new float[3], new float[3]});
    public boolean visible = true;
    public final List<AnimatedModelRenderer> children = new ArrayList<AnimatedModelRenderer>();
    private final ModelPart modelPart;
    private final List<ModelBox> cubes = new ArrayList<ModelBox>();

    private static float[] getPooledVertex(int index) {
        return VERTEX_POOL.get()[index % 4];
    }

    public AnimatedModelRenderer(int width, int height, BBModelParts.Element element, String name, BlockbenchLoader.BlockbenchSetting settings) {
        this.textureWidth = width;
        this.textureHeight = height;
        this.element = element;
        this.name = name;
        this.settings = settings != null ? settings : AnimatedModelRenderer.createDefaultSettings();
        this.mirror = false;
        this.pitch = 0.0f;
        this.yaw = 0.0f;
        this.roll = 0.0f;
        this.pivotX = 0.0f;
        this.pivotY = 0.0f;
        this.pivotZ = 0.0f;
        this.modelPart = new ModelPart(Collections.emptyList(), Collections.emptyMap());
    }

    public AnimatedModelRenderer(int width, int height, BBModelParts.Element element, String name) {
        this(width, height, element, name, null);
    }

    private static BlockbenchLoader.BlockbenchSetting createDefaultSettings() {
        return new BlockbenchLoader.BlockbenchSetting(ResourceLocation.fromNamespaceAndPath((String)"default", (String)"default"), 1.0f, false, false, "default");
    }

    public ModelPart addCuboid(float x, float y, float z, float dimX, float dimY, float dimZ) {
        this.addCuboid(x, y, z, dimX, dimY, dimZ, 0.0f, 0.0f, 0.0f, this.mirror);
        return this.modelPart;
    }

    public void addCuboid(float x, float y, float z, float dimX, float dimY, float dimZ, float growX, float growY, float growZ, boolean mirror) {
        if (this.element != null) {
            this.cubes.add(new ModelBox(x, y, z, dimX, dimY, dimZ, growX, growY, growZ, mirror, this.textureWidth, this.textureHeight, this.element, this.settings));
        }
    }

    public void addChild(AnimatedModelRenderer child) {
        this.children.add(child);
    }

    public void setPivot(float x, float y, float z) {
        this.pivotX = x;
        this.pivotY = y;
        this.pivotZ = z;
        this.modelPart.setPos(x, y, z);
    }

    public void render(PoseStack matrices, VertexConsumer vertices, int light, int overlay, int color) {
        this.render(matrices, vertices, light, overlay);
    }

    public void render(PoseStack matrices, VertexConsumer vertices, int light, int overlay) {
        this.render(matrices, vertices, light, overlay, null);
    }

    public void render(PoseStack matrices, VertexConsumer vertices, int light, int overlay, TextureAtlasSprite sprite) {
        if (this.visible) {
            matrices.pushPose();
            this.translateAndRotate(matrices);
            for (ModelBox cube : this.cubes) {
                cube.render(matrices, vertices, light, overlay, 1.0f, 1.0f, 1.0f, 1.0f, sprite);
            }
            for (AnimatedModelRenderer child : this.children) {
                child.render(matrices, vertices, light, overlay, sprite);
            }
            matrices.popPose();
        }
    }

    private void renderCube(PoseStack matrices, VertexConsumer vertices, int light, int overlay, float red, float green, float blue, float alpha, TextureAtlasSprite sprite) {
        float v2;
        float u2;
        float v1;
        float u1;
        if (this.element == null) {
            return;
        }
        float x = (this.element.from.x - this.element.origin.x) / 16.0f;
        float y = (this.element.from.y - this.element.origin.y) / 16.0f;
        float z = (this.element.from.z - this.element.origin.z) / 16.0f;
        float xMax = (this.element.to.x - this.element.origin.x) / 16.0f;
        float yMax = (this.element.to.y - this.element.origin.y) / 16.0f;
        float zMax = (this.element.to.z - this.element.origin.z) / 16.0f;
        BBModelParts.Face uvDown = this.element.faces.get(Direction.DOWN);
        BBModelParts.Face uvUp = this.element.faces.get(Direction.UP);
        BBModelParts.Face uvNorth = this.element.faces.get(Direction.NORTH);
        BBModelParts.Face uvSouth = this.element.faces.get(Direction.SOUTH);
        BBModelParts.Face uvEast = this.element.faces.get(Direction.EAST);
        BBModelParts.Face uvWest = this.element.faces.get(Direction.WEST);
        float minU = sprite != null ? sprite.getU0() : 0.0f;
        float maxU = sprite != null ? sprite.getU1() : 1.0f;
        float minV = sprite != null ? sprite.getV0() : 0.0f;
        float maxV = sprite != null ? sprite.getV1() : 1.0f;
        float uRange = maxU - minU;
        float vRange = maxV - minV;
        if (uvDown != null && uvDown.uv != null) {
            u1 = minU + uvDown.uv.u0 / (float)this.textureWidth * uRange;
            v1 = minV + uvDown.uv.v0 / (float)this.textureHeight * vRange;
            u2 = minU + uvDown.uv.u1 / (float)this.textureWidth * uRange;
            v2 = minV + uvDown.uv.v1 / (float)this.textureHeight * vRange;
            float[] v1_arr = AnimatedModelRenderer.getPooledVertex(0);
            v1_arr[0] = xMax;
            v1_arr[1] = y;
            v1_arr[2] = zMax;
            float[] v2_arr = AnimatedModelRenderer.getPooledVertex(1);
            v2_arr[0] = x;
            v2_arr[1] = y;
            v2_arr[2] = zMax;
            float[] v3_arr = AnimatedModelRenderer.getPooledVertex(2);
            v3_arr[0] = x;
            v3_arr[1] = y;
            v3_arr[2] = z;
            float[] v4_arr = AnimatedModelRenderer.getPooledVertex(3);
            v4_arr[0] = xMax;
            v4_arr[1] = y;
            v4_arr[2] = z;
            this.renderForgeQuad(matrices, vertices, v1_arr, v2_arr, v3_arr, v4_arr, u1, v1, u2, v2, 0.0f, -1.0f, 0.0f, light, overlay, red, green, blue, alpha);
        }
        if (uvUp != null && uvUp.uv != null) {
            u1 = minU + uvUp.uv.u0 / (float)this.textureWidth * uRange;
            v1 = minV + uvUp.uv.v0 / (float)this.textureHeight * vRange;
            u2 = minU + uvUp.uv.u1 / (float)this.textureWidth * uRange;
            v2 = minV + uvUp.uv.v1 / (float)this.textureHeight * vRange;
            this.renderForgeQuad(matrices, vertices, new float[]{x, yMax, z}, new float[]{xMax, yMax, z}, new float[]{xMax, yMax, zMax}, new float[]{x, yMax, zMax}, u1, v1, u2, v2, 0.0f, 1.0f, 0.0f, light, overlay, red, green, blue, alpha);
        }
        if (uvWest != null && uvWest.uv != null) {
            u1 = minU + uvWest.uv.u0 / (float)this.textureWidth * uRange;
            v1 = minV + uvWest.uv.v0 / (float)this.textureHeight * vRange;
            u2 = minU + uvWest.uv.u1 / (float)this.textureWidth * uRange;
            v2 = minV + uvWest.uv.v1 / (float)this.textureHeight * vRange;
            this.renderForgeQuad(matrices, vertices, new float[]{x, yMax, zMax}, new float[]{x, yMax, z}, new float[]{x, y, z}, new float[]{x, y, zMax}, u1, v1, u2, v2, -1.0f, 0.0f, 0.0f, light, overlay, red, green, blue, alpha);
        }
        if (uvNorth != null && uvNorth.uv != null) {
            u1 = minU + uvNorth.uv.u0 / (float)this.textureWidth * uRange;
            v1 = minV + uvNorth.uv.v0 / (float)this.textureHeight * vRange;
            u2 = minU + uvNorth.uv.u1 / (float)this.textureWidth * uRange;
            v2 = minV + uvNorth.uv.v1 / (float)this.textureHeight * vRange;
            this.renderForgeQuad(matrices, vertices, new float[]{x, yMax, z}, new float[]{xMax, yMax, z}, new float[]{xMax, y, z}, new float[]{x, y, z}, u1, v1, u2, v2, 0.0f, 0.0f, -1.0f, light, overlay, red, green, blue, alpha);
        }
        if (uvEast != null && uvEast.uv != null) {
            u1 = minU + uvEast.uv.u0 / (float)this.textureWidth * uRange;
            v1 = minV + uvEast.uv.v0 / (float)this.textureHeight * vRange;
            u2 = minU + uvEast.uv.u1 / (float)this.textureWidth * uRange;
            v2 = minV + uvEast.uv.v1 / (float)this.textureHeight * vRange;
            this.renderForgeQuad(matrices, vertices, new float[]{xMax, yMax, z}, new float[]{xMax, yMax, zMax}, new float[]{xMax, y, zMax}, new float[]{xMax, y, z}, u1, v1, u2, v2, 1.0f, 0.0f, 0.0f, light, overlay, red, green, blue, alpha);
        }
        if (uvSouth != null && uvSouth.uv != null) {
            u1 = minU + uvSouth.uv.u0 / (float)this.textureWidth * uRange;
            v1 = minV + uvSouth.uv.v0 / (float)this.textureHeight * vRange;
            u2 = minU + uvSouth.uv.u1 / (float)this.textureWidth * uRange;
            v2 = minV + uvSouth.uv.v1 / (float)this.textureHeight * vRange;
            this.renderForgeQuad(matrices, vertices, new float[]{xMax, yMax, zMax}, new float[]{x, yMax, zMax}, new float[]{x, y, zMax}, new float[]{xMax, y, zMax}, u1, v1, u2, v2, 0.0f, 0.0f, 1.0f, light, overlay, red, green, blue, alpha);
        }
    }

    private void renderForgeQuad(PoseStack matrices, VertexConsumer vertices, float[] v1, float[] v2, float[] v3, float[] v4, float u1, float v1tex, float u2, float v2tex, float nx, float ny, float nz, int light, int overlay, float red, float green, float blue, float alpha) {
        PoseStack.Pose entry = matrices.last();
        Vector3f normal = new Vector3f(nx, ny, nz);
        normal.mul((Matrix3fc)entry.normal());
        normal.normalize();
        vertices.addVertex(entry.pose(), v1[0], v1[1], v1[2]).setColor(red, green, blue, alpha).setUv(u1, v1tex).setOverlay(overlay).setLight(light).setNormal(normal.x, normal.y, normal.z);
        vertices.addVertex(entry.pose(), v2[0], v2[1], v2[2]).setColor(red, green, blue, alpha).setUv(u2, v1tex).setOverlay(overlay).setLight(light).setNormal(normal.x, normal.y, normal.z);
        vertices.addVertex(entry.pose(), v3[0], v3[1], v3[2]).setColor(red, green, blue, alpha).setUv(u2, v2tex).setOverlay(overlay).setLight(light).setNormal(normal.x, normal.y, normal.z);
        vertices.addVertex(entry.pose(), v4[0], v4[1], v4[2]).setColor(red, green, blue, alpha).setUv(u1, v2tex).setOverlay(overlay).setLight(light).setNormal(normal.x, normal.y, normal.z);
    }

    private void renderQuad(PoseStack matrices, VertexConsumer vertices, float x1, float y1, float z1, float x2, float y2, float z2, float u1, float v1, float u2, float v2, float nx, float ny, float nz, int light, int overlay, float red, float green, float blue, float alpha) {
        PoseStack.Pose entry = matrices.last();
        Vector3f normal = new Vector3f(nx, ny, nz);
        normal.mul((Matrix3fc)entry.normal());
        normal.normalize();
        if (nz < 0.0f) {
            vertices.addVertex(entry.pose(), x2, y1, z1).setColor(red, green, blue, alpha).setUv(u2, v2).setOverlay(overlay).setLight(light).setNormal(normal.x, normal.y, normal.z);
            vertices.addVertex(entry.pose(), x1, y1, z1).setColor(red, green, blue, alpha).setUv(u1, v2).setOverlay(overlay).setLight(light).setNormal(normal.x, normal.y, normal.z);
            vertices.addVertex(entry.pose(), x1, y2, z1).setColor(red, green, blue, alpha).setUv(u1, v1).setOverlay(overlay).setLight(light).setNormal(normal.x, normal.y, normal.z);
            vertices.addVertex(entry.pose(), x2, y2, z1).setColor(red, green, blue, alpha).setUv(u2, v1).setOverlay(overlay).setLight(light).setNormal(normal.x, normal.y, normal.z);
        } else if (nz > 0.0f) {
            vertices.addVertex(entry.pose(), x1, y1, z2).setColor(red, green, blue, alpha).setUv(u2, v2).setOverlay(overlay).setLight(light).setNormal(normal.x, normal.y, normal.z);
            vertices.addVertex(entry.pose(), x2, y1, z2).setColor(red, green, blue, alpha).setUv(u1, v2).setOverlay(overlay).setLight(light).setNormal(normal.x, normal.y, normal.z);
            vertices.addVertex(entry.pose(), x2, y2, z2).setColor(red, green, blue, alpha).setUv(u1, v1).setOverlay(overlay).setLight(light).setNormal(normal.x, normal.y, normal.z);
            vertices.addVertex(entry.pose(), x1, y2, z2).setColor(red, green, blue, alpha).setUv(u2, v1).setOverlay(overlay).setLight(light).setNormal(normal.x, normal.y, normal.z);
        } else if (nx < 0.0f) {
            vertices.addVertex(entry.pose(), x1, y1, z1).setColor(red, green, blue, alpha).setUv(u1, v2).setOverlay(overlay).setLight(light).setNormal(normal.x, normal.y, normal.z);
            vertices.addVertex(entry.pose(), x1, y1, z2).setColor(red, green, blue, alpha).setUv(u2, v2).setOverlay(overlay).setLight(light).setNormal(normal.x, normal.y, normal.z);
            vertices.addVertex(entry.pose(), x1, y2, z2).setColor(red, green, blue, alpha).setUv(u2, v1).setOverlay(overlay).setLight(light).setNormal(normal.x, normal.y, normal.z);
            vertices.addVertex(entry.pose(), x1, y2, z1).setColor(red, green, blue, alpha).setUv(u1, v1).setOverlay(overlay).setLight(light).setNormal(normal.x, normal.y, normal.z);
        } else if (nx > 0.0f) {
            vertices.addVertex(entry.pose(), x2, y1, z2).setColor(red, green, blue, alpha).setUv(u1, v2).setOverlay(overlay).setLight(light).setNormal(normal.x, normal.y, normal.z);
            vertices.addVertex(entry.pose(), x2, y1, z1).setColor(red, green, blue, alpha).setUv(u2, v2).setOverlay(overlay).setLight(light).setNormal(normal.x, normal.y, normal.z);
            vertices.addVertex(entry.pose(), x2, y2, z1).setColor(red, green, blue, alpha).setUv(u2, v1).setOverlay(overlay).setLight(light).setNormal(normal.x, normal.y, normal.z);
            vertices.addVertex(entry.pose(), x2, y2, z2).setColor(red, green, blue, alpha).setUv(u1, v1).setOverlay(overlay).setLight(light).setNormal(normal.x, normal.y, normal.z);
        } else if (ny < 0.0f) {
            vertices.addVertex(entry.pose(), x1, y1, z2).setColor(red, green, blue, alpha).setUv(u1, v2).setOverlay(overlay).setLight(light).setNormal(normal.x, normal.y, normal.z);
            vertices.addVertex(entry.pose(), x1, y1, z1).setColor(red, green, blue, alpha).setUv(u1, v1).setOverlay(overlay).setLight(light).setNormal(normal.x, normal.y, normal.z);
            vertices.addVertex(entry.pose(), x2, y1, z1).setColor(red, green, blue, alpha).setUv(u2, v1).setOverlay(overlay).setLight(light).setNormal(normal.x, normal.y, normal.z);
            vertices.addVertex(entry.pose(), x2, y1, z2).setColor(red, green, blue, alpha).setUv(u2, v2).setOverlay(overlay).setLight(light).setNormal(normal.x, normal.y, normal.z);
        } else if (ny > 0.0f) {
            vertices.addVertex(entry.pose(), x1, y2, z1).setColor(red, green, blue, alpha).setUv(u1, v1).setOverlay(overlay).setLight(light).setNormal(normal.x, normal.y, normal.z);
            vertices.addVertex(entry.pose(), x1, y2, z2).setColor(red, green, blue, alpha).setUv(u1, v2).setOverlay(overlay).setLight(light).setNormal(normal.x, normal.y, normal.z);
            vertices.addVertex(entry.pose(), x2, y2, z2).setColor(red, green, blue, alpha).setUv(u2, v2).setOverlay(overlay).setLight(light).setNormal(normal.x, normal.y, normal.z);
            vertices.addVertex(entry.pose(), x2, y2, z1).setColor(red, green, blue, alpha).setUv(u2, v1).setOverlay(overlay).setLight(light).setNormal(normal.x, normal.y, normal.z);
        }
    }

    public void translateAndRotate(PoseStack matrixIn) {
        matrixIn.translate((double)(this.pivotX / 16.0f), (double)(this.pivotY / 16.0f), (double)(this.pivotZ / 16.0f));
        if (this.roll != 0.0f) {
            matrixIn.mulPose(Axis.ZP.rotationDegrees(this.roll));
        }
        if (this.yaw != 0.0f) {
            matrixIn.mulPose(Axis.YP.rotationDegrees(this.yaw));
        }
        if (this.pitch != 0.0f) {
            matrixIn.mulPose(Axis.XP.rotationDegrees(this.pitch));
        }
    }

    public static class ModelBox {
        private final BBModelParts.Element element;
        private final BlockbenchLoader.BlockbenchSetting settings;
        private final int textureWidth;
        private final int textureHeight;

        public ModelBox(float x, float y, float z, float dimX, float dimY, float dimZ, float growX, float growY, float growZ, boolean mirror, int textureWidth, int textureHeight, BBModelParts.Element element, BlockbenchLoader.BlockbenchSetting settings) {
            this.element = element;
            this.settings = settings;
            this.textureWidth = textureWidth;
            this.textureHeight = textureHeight;
        }

        public void render(PoseStack matrices, VertexConsumer vertices, int light, int overlay, float red, float green, float blue, float alpha, TextureAtlasSprite sprite) {
            float vHeight;
            float uWidth;
            float minUVArea;
            boolean isZPlane;
            if (this.element == null) {
                return;
            }
            float scale = this.settings != null && this.settings.scale > 0.0f ? this.settings.scale : 1.0f;
            float x = (this.element.from.x - this.element.origin.x) / 16.0f * scale;
            float y = (this.element.from.y - this.element.origin.y) / 16.0f * scale;
            float z = (this.element.from.z - this.element.origin.z) / 16.0f * scale;
            float xMax = (this.element.to.x - this.element.origin.x) / 16.0f * scale;
            float yMax = (this.element.to.y - this.element.origin.y) / 16.0f * scale;
            float zMax = (this.element.to.z - this.element.origin.z) / 16.0f * scale;
            float planeThreshold = 0.001f;
            float zFightOffset = 5.0E-4f;
            boolean isXPlane = Math.abs(xMax - x) < planeThreshold;
            boolean isYPlane = Math.abs(yMax - y) < planeThreshold;
            boolean bl = isZPlane = Math.abs(zMax - z) < planeThreshold;
            if (isXPlane) {
                x -= zFightOffset;
                xMax += zFightOffset;
            }
            if (isYPlane) {
                y -= zFightOffset;
                yMax += zFightOffset;
            }
            if (isZPlane) {
                z -= zFightOffset;
                zMax += zFightOffset;
            }
            BBModelParts.Face uvDown = this.element.faces.get(Direction.DOWN);
            BBModelParts.Face uvUp = this.element.faces.get(Direction.UP);
            BBModelParts.Face uvNorth = this.element.faces.get(Direction.NORTH);
            BBModelParts.Face uvSouth = this.element.faces.get(Direction.SOUTH);
            BBModelParts.Face uvEast = this.element.faces.get(Direction.EAST);
            BBModelParts.Face uvWest = this.element.faces.get(Direction.WEST);
            float minU = sprite != null ? sprite.getU0() : 0.0f;
            float maxU = sprite != null ? sprite.getU1() : 1.0f;
            float minV = sprite != null ? sprite.getV0() : 0.0f;
            float maxV = sprite != null ? sprite.getV1() : 1.0f;
            float uRange = maxU - minU;
            float vRange = maxV - minV;
            if (uvDown != null && uvDown.uv != null) {
                minUVArea = 0.1f;
                uWidth = Math.abs(uvDown.uv.u1 - uvDown.uv.u0);
                if (uWidth * (vHeight = Math.abs(uvDown.uv.v1 - uvDown.uv.v0)) >= minUVArea) {
                    float[] v1_arr = AnimatedModelRenderer.getPooledVertex(0);
                    v1_arr[0] = xMax;
                    v1_arr[1] = y;
                    v1_arr[2] = zMax;
                    float[] v2_arr = AnimatedModelRenderer.getPooledVertex(1);
                    v2_arr[0] = x;
                    v2_arr[1] = y;
                    v2_arr[2] = zMax;
                    float[] v3_arr = AnimatedModelRenderer.getPooledVertex(2);
                    v3_arr[0] = x;
                    v3_arr[1] = y;
                    v3_arr[2] = z;
                    float[] v4_arr = AnimatedModelRenderer.getPooledVertex(3);
                    v4_arr[0] = xMax;
                    v4_arr[1] = y;
                    v4_arr[2] = z;
                    this.renderForgeTexturedQuad(matrices, vertices, v1_arr, v2_arr, v3_arr, v4_arr, uvDown.uv.u0, uvDown.uv.v0, uvDown.uv.u1, uvDown.uv.v1, this.textureWidth, this.textureHeight, sprite, 0.0f, -1.0f, 0.0f, light, overlay, red, green, blue, alpha, false);
                }
            }
            if (uvUp != null && uvUp.uv != null) {
                minUVArea = 0.1f;
                uWidth = Math.abs(uvUp.uv.u1 - uvUp.uv.u0);
                if (uWidth * (vHeight = Math.abs(uvUp.uv.v1 - uvUp.uv.v0)) >= minUVArea) {
                    this.renderForgeTexturedQuad(matrices, vertices, new float[]{x, yMax, z}, new float[]{xMax, yMax, z}, new float[]{xMax, yMax, zMax}, new float[]{x, yMax, zMax}, uvUp.uv.u0, uvUp.uv.v0, uvUp.uv.u1, uvUp.uv.v1, this.textureWidth, this.textureHeight, sprite, 0.0f, 1.0f, 0.0f, light, overlay, red, green, blue, alpha, false);
                }
            }
            if (uvWest != null && uvWest.uv != null) {
                minUVArea = 0.1f;
                uWidth = Math.abs(uvWest.uv.u1 - uvWest.uv.u0);
                if (uWidth * (vHeight = Math.abs(uvWest.uv.v1 - uvWest.uv.v0)) >= minUVArea) {
                    this.renderForgeTexturedQuad(matrices, vertices, new float[]{x, yMax, zMax}, new float[]{x, yMax, z}, new float[]{x, y, z}, new float[]{x, y, zMax}, uvWest.uv.u0, uvWest.uv.v0, uvWest.uv.u1, uvWest.uv.v1, this.textureWidth, this.textureHeight, sprite, -1.0f, 0.0f, 0.0f, light, overlay, red, green, blue, alpha, false);
                }
            }
            if (uvNorth != null && uvNorth.uv != null) {
                minUVArea = 0.1f;
                uWidth = Math.abs(uvNorth.uv.u1 - uvNorth.uv.u0);
                if (uWidth * (vHeight = Math.abs(uvNorth.uv.v1 - uvNorth.uv.v0)) >= minUVArea) {
                    this.renderForgeTexturedQuad(matrices, vertices, new float[]{x, yMax, z}, new float[]{xMax, yMax, z}, new float[]{xMax, y, z}, new float[]{x, y, z}, uvNorth.uv.u0, uvNorth.uv.v0, uvNorth.uv.u1, uvNorth.uv.v1, this.textureWidth, this.textureHeight, sprite, 0.0f, 0.0f, -1.0f, light, overlay, red, green, blue, alpha, false);
                }
            }
            if (uvEast != null && uvEast.uv != null) {
                minUVArea = 0.1f;
                uWidth = Math.abs(uvEast.uv.u1 - uvEast.uv.u0);
                if (uWidth * (vHeight = Math.abs(uvEast.uv.v1 - uvEast.uv.v0)) >= minUVArea) {
                    this.renderForgeTexturedQuad(matrices, vertices, new float[]{xMax, yMax, z}, new float[]{xMax, yMax, zMax}, new float[]{xMax, y, zMax}, new float[]{xMax, y, z}, uvEast.uv.u0, uvEast.uv.v0, uvEast.uv.u1, uvEast.uv.v1, this.textureWidth, this.textureHeight, sprite, 1.0f, 0.0f, 0.0f, light, overlay, red, green, blue, alpha, false);
                }
            }
            if (uvSouth != null && uvSouth.uv != null) {
                minUVArea = 0.1f;
                uWidth = Math.abs(uvSouth.uv.u1 - uvSouth.uv.u0);
                if (uWidth * (vHeight = Math.abs(uvSouth.uv.v1 - uvSouth.uv.v0)) >= minUVArea) {
                    this.renderForgeTexturedQuad(matrices, vertices, new float[]{xMax, yMax, zMax}, new float[]{x, yMax, zMax}, new float[]{x, y, zMax}, new float[]{xMax, y, zMax}, uvSouth.uv.u0, uvSouth.uv.v0, uvSouth.uv.u1, uvSouth.uv.v1, this.textureWidth, this.textureHeight, sprite, 0.0f, 0.0f, 1.0f, light, overlay, red, green, blue, alpha, false);
                }
            }
        }

        private void renderBlockbenchQuad(PoseStack matrices, VertexConsumer vertices, float[] v1, float[] v2, float[] v3, float[] v4, float u1, float v1tex, float u2, float v2tex, float nx, float ny, float nz, int light, int overlay, float red, float green, float blue, float alpha, boolean flipU, boolean flipV) {
            PoseStack.Pose entry = matrices.last();
            Vector3f normal = new Vector3f(nx, ny, nz);
            normal.mul((Matrix3fc)entry.normal());
            normal.normalize();
            float finalU1 = flipU ? u2 : u1;
            float finalU2 = flipU ? u1 : u2;
            float finalV1 = flipV ? v2tex : v1tex;
            float finalV2 = flipV ? v1tex : v2tex;
            vertices.addVertex(entry.pose(), v1[0], v1[1], v1[2]).setColor(red, green, blue, alpha).setUv(finalU1, finalV1).setOverlay(overlay).setLight(light).setNormal(normal.x, normal.y, normal.z);
            vertices.addVertex(entry.pose(), v2[0], v2[1], v2[2]).setColor(red, green, blue, alpha).setUv(finalU1, finalV2).setOverlay(overlay).setLight(light).setNormal(normal.x, normal.y, normal.z);
            vertices.addVertex(entry.pose(), v3[0], v3[1], v3[2]).setColor(red, green, blue, alpha).setUv(finalU2, finalV2).setOverlay(overlay).setLight(light).setNormal(normal.x, normal.y, normal.z);
            vertices.addVertex(entry.pose(), v4[0], v4[1], v4[2]).setColor(red, green, blue, alpha).setUv(finalU2, finalV1).setOverlay(overlay).setLight(light).setNormal(normal.x, normal.y, normal.z);
        }

        private void renderForgeQuadWithUV(PoseStack matrices, VertexConsumer vertices, float[] v1, float[] v2, float[] v3, float[] v4, float u1, float v1tex, float u2, float v2tex, float nx, float ny, float nz, int light, int overlay, float red, float green, float blue, float alpha, boolean flipV) {
            PoseStack.Pose entry = matrices.last();
            Vector3f normal = new Vector3f(nx, ny, nz);
            normal.mul((Matrix3fc)entry.normal());
            normal.normalize();
            if (!flipV) {
                vertices.addVertex(entry.pose(), v1[0], v1[1], v1[2]).setColor(red, green, blue, alpha).setUv(u1, v1tex).setOverlay(overlay).setLight(light).setNormal(normal.x, normal.y, normal.z);
                vertices.addVertex(entry.pose(), v2[0], v2[1], v2[2]).setColor(red, green, blue, alpha).setUv(u1, v2tex).setOverlay(overlay).setLight(light).setNormal(normal.x, normal.y, normal.z);
                vertices.addVertex(entry.pose(), v3[0], v3[1], v3[2]).setColor(red, green, blue, alpha).setUv(u2, v2tex).setOverlay(overlay).setLight(light).setNormal(normal.x, normal.y, normal.z);
                vertices.addVertex(entry.pose(), v4[0], v4[1], v4[2]).setColor(red, green, blue, alpha).setUv(u2, v1tex).setOverlay(overlay).setLight(light).setNormal(normal.x, normal.y, normal.z);
            } else {
                vertices.addVertex(entry.pose(), v3[0], v3[1], v3[2]).setColor(red, green, blue, alpha).setUv(u2, v1tex).setOverlay(overlay).setLight(light).setNormal(normal.x, normal.y, normal.z);
                vertices.addVertex(entry.pose(), v4[0], v4[1], v4[2]).setColor(red, green, blue, alpha).setUv(u2, v2tex).setOverlay(overlay).setLight(light).setNormal(normal.x, normal.y, normal.z);
                vertices.addVertex(entry.pose(), v1[0], v1[1], v1[2]).setColor(red, green, blue, alpha).setUv(u1, v2tex).setOverlay(overlay).setLight(light).setNormal(normal.x, normal.y, normal.z);
                vertices.addVertex(entry.pose(), v2[0], v2[1], v2[2]).setColor(red, green, blue, alpha).setUv(u1, v1tex).setOverlay(overlay).setLight(light).setNormal(normal.x, normal.y, normal.z);
            }
        }

        private void renderForgeTexturedQuad(PoseStack matrices, VertexConsumer vertices, float[] v1, float[] v2, float[] v3, float[] v4, float u0, float v0, float u1, float v1_coord, int textureWidth, int textureHeight, TextureAtlasSprite sprite, float nx, float ny, float nz, int light, int overlay, float red, float green, float blue, float alpha, boolean mirror) {
            float finalV1;
            float finalV0;
            float finalU1;
            float finalU0;
            PoseStack.Pose entry = matrices.last();
            boolean flipU = false;
            boolean flipV = false;
            if (Math.abs(ny) > 0.5f) {
                if (ny > 0.0f) {
                    flipU = false;
                    flipV = mirror;
                } else {
                    flipU = !mirror;
                }
            } else {
                boolean bl = Math.abs(nx) > 0.5f || Math.abs(nz) > 0.5f ? !mirror : (flipU = mirror);
            }
            if (flipU) {
                finalU0 = u1;
                finalU1 = u0;
            } else {
                finalU0 = u0;
                finalU1 = u1;
            }
            if (flipV) {
                finalV0 = v1_coord;
                finalV1 = v0;
            } else {
                finalV0 = v0;
                finalV1 = v1_coord;
            }
            float normalizedU0 = finalU0 / (float)textureWidth;
            float normalizedV0 = finalV0 / (float)textureHeight;
            float normalizedU1 = finalU1 / (float)textureWidth;
            float normalizedV1 = finalV1 / (float)textureHeight;
            float spriteU0 = sprite.getU0() + (sprite.getU1() - sprite.getU0()) * normalizedU0;
            float spriteV0 = sprite.getV0() + (sprite.getV1() - sprite.getV0()) * normalizedV0;
            float spriteU1 = sprite.getU0() + (sprite.getU1() - sprite.getU0()) * normalizedU1;
            float spriteV1 = sprite.getV0() + (sprite.getV1() - sprite.getV0()) * normalizedV1;
            Vector3f normal = new Vector3f(nx, ny, nz);
            normal.mul((Matrix3fc)entry.normal());
            normal.normalize();
            vertices.addVertex(entry.pose(), v1[0], v1[1], v1[2]).setColor(red, green, blue, alpha).setUv(spriteU0, spriteV0).setOverlay(overlay).setLight(light).setNormal(normal.x, normal.y, normal.z);
            vertices.addVertex(entry.pose(), v2[0], v2[1], v2[2]).setColor(red, green, blue, alpha).setUv(spriteU1, spriteV0).setOverlay(overlay).setLight(light).setNormal(normal.x, normal.y, normal.z);
            vertices.addVertex(entry.pose(), v3[0], v3[1], v3[2]).setColor(red, green, blue, alpha).setUv(spriteU1, spriteV1).setOverlay(overlay).setLight(light).setNormal(normal.x, normal.y, normal.z);
            vertices.addVertex(entry.pose(), v4[0], v4[1], v4[2]).setColor(red, green, blue, alpha).setUv(spriteU0, spriteV1).setOverlay(overlay).setLight(light).setNormal(normal.x, normal.y, normal.z);
        }

        private void renderForgeQuad(PoseStack matrices, VertexConsumer vertices, float[] v1, float[] v2, float[] v3, float[] v4, float u1, float v1tex, float u2, float v2tex, float nx, float ny, float nz, int light, int overlay, float red, float green, float blue, float alpha) {
            this.renderForgeQuadWithUV(matrices, vertices, v1, v2, v3, v4, u1, v1tex, u2, v2tex, nx, ny, nz, light, overlay, red, green, blue, alpha, false);
        }
    }
}

