/*
 * Decompiled with CFR 0.152.
 */
package com.razznature.decocraft.client.render;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.razznature.decocraft.common.blocks.DecoAnimatedBlock;
import com.razznature.decocraft.common.blocks.DecoWaterBlock;
import com.razznature.decocraft.common.blocks.DecocraftBlock;
import com.razznature.decocraft.common.items.DecoBlockItem;
import com.razznature.decocraft.models.bbmodel.BBModel;
import com.razznature.decocraft.models.bbmodel.BBModelParts;
import com.razznature.decocraft.models.libgdx.Matrix4;
import com.razznature.decocraft.models.libgdx.Quaternion;
import com.razznature.decocraft.models.libgdx.Vector3;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector4f;

@OnlyIn(value=Dist.CLIENT)
public class DecoPlacementRenderer {
    private static BlockPos lastPos;
    private static Direction lastFacing;
    private static BBModel lastModel;
    private static float lastScale;
    private static Map<BBModelParts.Element, Vector3[]> cornerCache;
    private static final Matrix4[] ROT_MATS;

    public static void renderPlacementPreview(RenderLevelStageEvent event) {
        BlockPos pos;
        Item item;
        if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_PARTICLES) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        if (mc.player == null || mc.level == null) {
            return;
        }
        ItemStack stack = mc.player.getMainHandItem();
        if (stack.isEmpty()) {
            stack = mc.player.getOffhandItem();
        }
        if (!((item = stack.getItem()) instanceof DecoBlockItem)) {
            return;
        }
        DecoBlockItem item2 = (DecoBlockItem)item;
        HitResult hitResult = item2.getBlock() instanceof DecoWaterBlock ? mc.player.pick(20.0, 0.0f, true) : mc.hitResult;
        if (hitResult == null || hitResult.getType() != HitResult.Type.BLOCK) {
            return;
        }
        BlockHitResult hit = (BlockHitResult)hitResult;
        if (item2.getBlock() instanceof DecoWaterBlock) {
            BlockPos waterPos = hit.getBlockPos();
            if (mc.level.getBlockState(waterPos).is(Blocks.WATER) || mc.level.getFluidState(waterPos).is((Fluid)Fluids.WATER)) {
                BlockPos surfacePos = waterPos;
                while (mc.level.getBlockState(surfacePos.above()).is(Blocks.WATER)) {
                    surfacePos = surfacePos.above();
                }
                pos = surfacePos.above();
            } else {
                pos = hit.getBlockPos().relative(hit.getDirection());
            }
        } else {
            pos = hit.getBlockPos().relative(hit.getDirection());
        }
        DecoPlacementRenderer.renderOutline(event.getPoseStack(), item2, pos, mc.player.getDirection().getOpposite(), mc.level, event.getCamera());
    }

    private static void renderOutline(PoseStack pose, DecoBlockItem item, BlockPos pos, Direction facing, ClientLevel level, Camera cam) {
        Block block;
        BlockState state;
        if (!(item.getBlock() instanceof DecocraftBlock) && !(item.getBlock() instanceof DecoAnimatedBlock)) {
            return;
        }
        BBModel model = null;
        Block block2 = item.getBlock();
        if (block2 instanceof DecocraftBlock) {
            DecocraftBlock block3 = (DecocraftBlock)block2;
            state = (BlockState)block3.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)facing);
            if (block3 instanceof DecoWaterBlock) {
                boolean inWater = level.getFluidState(pos).is((Fluid)Fluids.WATER);
                state = (BlockState)state.setValue((Property)DecoWaterBlock.WATERLOGGED, (Comparable)Boolean.valueOf(inWater));
            }
            model = block3.model;
        } else {
            block = (DecoAnimatedBlock)item.getBlock();
            state = (BlockState)block.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)facing);
            model = block.model;
        }
        Vec3 camPos = cam.getPosition();
        pose.pushPose();
        pose.translate((double)pos.getX() - camPos.x, (double)pos.getY() - camPos.y, (double)pos.getZ() - camPos.z);
        if (model != null && model.elements != null && !model.elements.isEmpty()) {
            boolean recalc;
            BBModelParts.Element root = null;
            for (BBModelParts.Element e : model.elements) {
                if (e.name == null || !e.name.toLowerCase().equals("root_node") || !Objects.equals(e.type, "locator")) continue;
                root = e;
                break;
            }
            float scale = 1.0f;
            Block block4 = item.getBlock();
            if (block4 instanceof DecocraftBlock) {
                DecocraftBlock block5 = (DecocraftBlock)block4;
                scale = block5.meta != null && block5.meta.scale != 0.0f ? block5.meta.scale : 1.0f;
            } else {
                block4 = item.getBlock();
                if (block4 instanceof DecoAnimatedBlock) {
                    DecoAnimatedBlock block6 = (DecoAnimatedBlock)block4;
                    scale = block6.meta != null && block6.meta.scale != 0.0f ? block6.meta.scale : 1.0f;
                }
            }
            boolean bl = recalc = lastPos == null || !lastPos.equals((Object)pos) || lastFacing != facing || lastModel != model || lastScale != scale;
            if (recalc) {
                lastPos = pos;
                lastFacing = facing;
                lastModel = model;
                lastScale = scale;
                cornerCache = new HashMap<BBModelParts.Element, Vector3[]>();
            }
            DecoPlacementRenderer.renderModelWireframe(pose, model, facing, camPos, scale, root, state, recalc);
        } else {
            Block block7 = item.getBlock();
            if (block7 instanceof DecocraftBlock) {
                block = (DecocraftBlock)block7;
                DecoPlacementRenderer.renderSimpleOutline(pose, (DecocraftBlock)block, state, level, pos);
            }
        }
        pose.popPose();
    }

    private static void renderSimpleOutline(PoseStack pose, DecocraftBlock block, BlockState state, ClientLevel level, BlockPos pos) {
        VoxelShape shape = block.getShape(state, (BlockGetter)level, pos, CollisionContext.empty());
        RenderSystem.enableDepthTest();
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableCull();
        RenderSystem.lineWidth((float)1.0f);
        RenderSystem.depthFunc((int)515);
        Tesselator tess = Tesselator.getInstance();
        BufferBuilder buf = tess.begin(VertexFormat.Mode.DEBUG_LINES, DefaultVertexFormat.POSITION_COLOR);
        shape.forAllEdges((x1, y1, z1, x2, y2, z2) -> {
            buf.addVertex(pose.last().pose(), (float)x1, (float)y1, (float)z1).setColor(255, 255, 255, 255);
            buf.addVertex(pose.last().pose(), (float)x2, (float)y2, (float)z2).setColor(255, 255, 255, 255);
        });
        BufferUploader.drawWithShader((MeshData)buf.buildOrThrow());
        RenderSystem.enableCull();
        RenderSystem.disableBlend();
        RenderSystem.lineWidth((float)1.0f);
        RenderSystem.depthFunc((int)515);
    }

    private static void renderModelWireframe(PoseStack pose, BBModel model, Direction facing, Vec3 camPos, float scale, BBModelParts.Element root, BlockState state, boolean recalc) {
        if (model == null || model.elements == null) {
            return;
        }
        Vector3 center = null;
        if (root == null) {
            center = DecoPlacementRenderer.calcCenter(model);
        }
        RenderSystem.disableDepthTest();
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableCull();
        RenderSystem.lineWidth((float)1.0f);
        Tesselator tess = Tesselator.getInstance();
        BufferBuilder buf = tess.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
        Matrix4 rotMat = DecoPlacementRenderer.getRotMat(facing);
        for (BBModelParts.Element e : model.elements) {
            if (e.from == null || e.to == null) continue;
            DecoPlacementRenderer.renderElemWireframe(pose, buf, e, rotMat, root, center, scale, state, recalc);
        }
        BufferUploader.drawWithShader((MeshData)buf.buildOrThrow());
        RenderSystem.enableDepthTest();
        RenderSystem.enableCull();
        RenderSystem.disableBlend();
        RenderSystem.lineWidth((float)1.0f);
        RenderSystem.depthFunc((int)515);
    }

    private static Vector3 calcCenter(BBModel model) {
        float minX = Float.MAX_VALUE;
        float minY = Float.MAX_VALUE;
        float minZ = Float.MAX_VALUE;
        float maxX = -3.4028235E38f;
        float maxY = -3.4028235E38f;
        float maxZ = -3.4028235E38f;
        for (BBModelParts.Element e : model.elements) {
            if (e.from == null || e.to == null) continue;
            minX = Math.min(minX, Math.min(e.from.x, e.to.x));
            minY = Math.min(minY, Math.min(e.from.y, e.to.y));
            minZ = Math.min(minZ, Math.min(e.from.z, e.to.z));
            maxX = Math.max(maxX, Math.max(e.from.x, e.to.x));
            maxY = Math.max(maxY, Math.max(e.from.y, e.to.y));
            maxZ = Math.max(maxZ, Math.max(e.from.z, e.to.z));
        }
        return new Vector3((minX + maxX) / 32.0f, minY / 16.0f, (minZ + maxZ) / 32.0f);
    }

    private static void renderElemWireframe(PoseStack pose, BufferBuilder buf, BBModelParts.Element e, Matrix4 rotMat, BBModelParts.Element root, Vector3 center, float scale, BlockState state, boolean recalc) {
        Vector3[] corners;
        if (e.from == null || e.to == null) {
            return;
        }
        if (recalc || !cornerCache.containsKey(e)) {
            corners = DecoPlacementRenderer.getBakedCorners(e, root, scale, state);
            cornerCache.put(e, corners);
        } else {
            corners = cornerCache.get(e);
        }
        DecoPlacementRenderer.drawBox(pose, buf, corners);
    }

    private static Vector3[] getBakedCorners(BBModelParts.Element e, BBModelParts.Element root, float scale, BlockState state) {
        Vector3[] corners;
        Matrix4f mat = DecoPlacementRenderer.getTransformMat(state);
        for (Vector3 c : corners = DecoPlacementRenderer.createCorners(e)) {
            DecoPlacementRenderer.applyBakeryTransform(c, e, root, scale, mat);
        }
        return corners;
    }

    private static void applyBakeryTransform(Vector3 pos, BBModelParts.Element e, BBModelParts.Element root, float scale, Matrix4f mat) {
        DecoPlacementRenderer.applyElemRot(pos, e);
        Matrix4 m = new Matrix4();
        m.setToScaling(scale, scale, scale);
        DecoPlacementRenderer.applyTrans(pos, m);
        m.setToTranslation(0.5f, 0.0f, 0.5f);
        DecoPlacementRenderer.applyTrans(pos, m);
        if (root != null) {
            if (root.position != null) {
                m.setToTranslation(-root.position.x / 16.0f, -root.position.y / 16.0f, -root.position.z / 16.0f);
            } else if (root.from != null) {
                m.setToTranslation(-root.from.x / 16.0f, -root.from.y / 16.0f, -root.from.z / 16.0f);
            }
            DecoPlacementRenderer.applyTrans(pos, m);
        }
        DecoPlacementRenderer.rotByMat4f(pos, new Vector3(0.5f, 0.5f, 0.5f), mat);
    }

    private static Vector3[] createCorners(BBModelParts.Element e) {
        float x0 = e.from.x / 16.0f;
        float y0 = e.from.y / 16.0f;
        float z0 = e.from.z / 16.0f;
        float x1 = e.to.x / 16.0f;
        float y1 = e.to.y / 16.0f;
        float z1 = e.to.z / 16.0f;
        return new Vector3[]{new Vector3(x0, y0, z0), new Vector3(x1, y0, z0), new Vector3(x1, y1, z0), new Vector3(x0, y1, z0), new Vector3(x0, y0, z1), new Vector3(x1, y0, z1), new Vector3(x1, y1, z1), new Vector3(x0, y1, z1)};
    }

    private static Matrix4f getTransformMat(BlockState state) {
        Matrix4f mat = new Matrix4f();
        Direction facing = (Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        switch (facing) {
            case EAST: {
                mat.rotateY((float)Math.toRadians(-90.0));
                break;
            }
            case SOUTH: {
                mat.rotateY((float)Math.toRadians(180.0));
                break;
            }
            case WEST: {
                mat.rotateY((float)Math.toRadians(90.0));
            }
        }
        return mat;
    }

    private static void drawBox(PoseStack pose, BufferBuilder buf, Vector3[] c) {
        float t = 0.005f;
        DecoPlacementRenderer.addLine(pose, buf, c[0], c[1], t);
        DecoPlacementRenderer.addLine(pose, buf, c[1], c[2], t);
        DecoPlacementRenderer.addLine(pose, buf, c[2], c[3], t);
        DecoPlacementRenderer.addLine(pose, buf, c[3], c[0], t);
        DecoPlacementRenderer.addLine(pose, buf, c[4], c[5], t);
        DecoPlacementRenderer.addLine(pose, buf, c[5], c[6], t);
        DecoPlacementRenderer.addLine(pose, buf, c[6], c[7], t);
        DecoPlacementRenderer.addLine(pose, buf, c[7], c[4], t);
        DecoPlacementRenderer.addLine(pose, buf, c[0], c[4], t);
        DecoPlacementRenderer.addLine(pose, buf, c[1], c[5], t);
        DecoPlacementRenderer.addLine(pose, buf, c[2], c[6], t);
        DecoPlacementRenderer.addLine(pose, buf, c[3], c[7], t);
    }

    private static void addLine(PoseStack pose, BufferBuilder buf, Vector3 from, Vector3 to, float t) {
        Vector3 dir = new Vector3(to.x - from.x, to.y - from.y, to.z - from.z);
        float len = (float)Math.sqrt(dir.x * dir.x + dir.y * dir.y + dir.z * dir.z);
        if (len < 0.001f) {
            return;
        }
        dir.x /= len;
        dir.y /= len;
        dir.z /= len;
        Vector3 perp = Math.abs(dir.y) < 0.9f ? new Vector3(-dir.z, 0.0f, dir.x) : new Vector3(1.0f, -dir.x, 0.0f);
        float perpLen = (float)Math.sqrt(perp.x * perp.x + perp.y * perp.y + perp.z * perp.z);
        if (perpLen > 0.001f) {
            perp.x /= perpLen;
            perp.y /= perpLen;
            perp.z /= perpLen;
        }
        perp.x *= t * 0.5f;
        perp.y *= t * 0.5f;
        perp.z *= t * 0.5f;
        Vector3 p1 = new Vector3(from.x - perp.x, from.y - perp.y, from.z - perp.z);
        Vector3 p2 = new Vector3(from.x + perp.x, from.y + perp.y, from.z + perp.z);
        Vector3 p3 = new Vector3(to.x + perp.x, to.y + perp.y, to.z + perp.z);
        Vector3 p4 = new Vector3(to.x - perp.x, to.y - perp.y, to.z - perp.z);
        Matrix4f mat = pose.last().pose();
        buf.addVertex(mat, p1.x, p1.y, p1.z).setColor(255, 255, 255, 255);
        buf.addVertex(mat, p2.x, p2.y, p2.z).setColor(255, 255, 255, 255);
        buf.addVertex(mat, p3.x, p3.y, p3.z).setColor(255, 255, 255, 255);
        buf.addVertex(mat, p4.x, p4.y, p4.z).setColor(255, 255, 255, 255);
    }

    private static Matrix4 getRotMat(Direction facing) {
        switch (facing) {
            case NORTH: {
                return ROT_MATS[0];
            }
            case SOUTH: {
                return ROT_MATS[1];
            }
            case EAST: {
                return ROT_MATS[2];
            }
            case WEST: {
                return ROT_MATS[3];
            }
        }
        return ROT_MATS[0];
    }

    private static void applyTrans(Vector3 pos, Matrix4 mat) {
        float x = mat.val[0] * pos.x + mat.val[4] * pos.y + mat.val[8] * pos.z + mat.val[12];
        float y = mat.val[1] * pos.x + mat.val[5] * pos.y + mat.val[9] * pos.z + mat.val[13];
        float z = mat.val[2] * pos.x + mat.val[6] * pos.y + mat.val[10] * pos.z + mat.val[14];
        pos.set(x, y, z);
    }

    private static void rotBy(Vector3 pos, Vector3 origin, Matrix4 mat) {
        Vector3 d = new Vector3(pos.x - origin.x, pos.y - origin.y, pos.z - origin.z);
        DecoPlacementRenderer.applyTrans(d, mat);
        pos.set(d.x + origin.x, d.y + origin.y, d.z + origin.z);
    }

    private static void rotByMat4f(Vector3 pos, Vector3 origin, Matrix4f mat) {
        Vector4f d = new Vector4f(pos.x - origin.x, pos.y - origin.y, pos.z - origin.z, 1.0f);
        d.mul((Matrix4fc)mat);
        pos.set(d.x + origin.x, d.y + origin.y, d.z + origin.z);
    }

    private static void applyElemRot(Vector3 pos, BBModelParts.Element e) {
        Vector3 origin = new Vector3(e.origin.x, e.origin.y, e.origin.z);
        Vector3 rot = e.rotation;
        BBModelParts.OutlinerGroup parent = e.parent;
        Quaternion q = new Quaternion();
        while (true) {
            Vector3 o = new Vector3(origin.x / 16.0f, origin.y / 16.0f, origin.z / 16.0f);
            if (rot.x != 0.0f) {
                q.set(Vector3.X, rot.x);
                DecoPlacementRenderer.rotBy(pos, o, new Matrix4(q));
            }
            if (rot.y != 0.0f) {
                q.set(Vector3.Y, rot.y);
                DecoPlacementRenderer.rotBy(pos, o, new Matrix4(q));
            }
            if (rot.z != 0.0f) {
                q.set(Vector3.Z, rot.z);
                DecoPlacementRenderer.rotBy(pos, o, new Matrix4(q));
            }
            if (parent == null) break;
            origin = parent.origin;
            rot = parent.rotation;
            parent = parent.parent;
        }
    }

    static {
        ROT_MATS = new Matrix4[]{new Matrix4(new float[]{1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f}), new Matrix4(new float[]{-1.0f, 0.0f, 8.742278E-8f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, -8.742278E-8f, 0.0f, -1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f}), new Matrix4(new float[]{5.9604645E-8f, 0.0f, 0.99999994f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, -0.99999994f, 0.0f, 5.9604645E-8f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f}), new Matrix4(new float[]{5.9604645E-8f, 0.0f, -0.99999994f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.99999994f, 0.0f, 5.9604645E-8f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f})};
    }
}

