/*
 * Decompiled with CFR 0.152.
 */
package com.razznature.decocraft.common.blocks;

import com.razznature.decocraft.Decocraft;
import com.razznature.decocraft.common.JsonContainer;
import com.razznature.decocraft.common.ModuleBlocks;
import com.razznature.decocraft.common.ModuleSounds;
import com.razznature.decocraft.common.ModuleTileEntities;
import com.razznature.decocraft.common.tileentities.DecoStorageTileEntity;
import com.razznature.decocraft.common.tileentities.DecocraftTileEntity;
import com.razznature.decocraft.models.bbmodel.BBHitBox;
import com.razznature.decocraft.models.bbmodel.BBModel;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class DecocraftBlock
extends Block
implements EntityBlock {
    private static final Map<String, VoxelShape[]> CACHE_HIT_BOXES = Collections.synchronizedMap(new HashMap());
    public final JsonContainer.Entry meta;
    public final BBModel model;
    private VoxelShape[] shape;

    public DecocraftBlock(JsonContainer.Entry meta, BBModel model) {
        super(DecocraftBlock.getProperties(meta));
        this.meta = meta;
        this.model = model;
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH));
    }

    private static BlockBehaviour.Properties getProperties(JsonContainer.Entry meta) {
        BlockBehaviour.Properties settings = meta.passable ? BlockBehaviour.Properties.of().mapColor(MapColor.STONE).noCollission() : BlockBehaviour.Properties.of().mapColor(MapColor.STONE).noOcclusion();
        if (meta.lighting > 0) {
            settings = settings.lightLevel(state -> meta.lighting);
        }
        return settings;
    }

    public static void script(Level level, BlockPos blockPos, BlockState blockState, JsonContainer.Action action) {
        if (action != null) {
            if (action.link != null) {
                DecocraftBlock.scriptLink(level, blockPos, blockState, action.link);
            }
            if (action.sound != null) {
                DecocraftBlock.scriptSound(level, blockPos, blockState, action.sound);
            }
            if (action.animations != null) {
                DecocraftBlock.scriptAnimations(level, blockPos, blockState, action.animations);
            }
            if (action.storage != null && action.storage.length == 2) {
                DecocraftBlock.scriptStorage(level, blockPos, blockState, action.storage);
            }
        }
    }

    public static void scriptStorage(Level level, BlockPos blockPos, BlockState blockState, int[] storage) {
    }

    public static void scriptLink(Level level, BlockPos blockPos, BlockState blockState, String link) {
        if (link == null || link.isEmpty()) {
            return;
        }
        Block targetBlock = ModuleBlocks.DECOBLOCKS.get(link);
        if (targetBlock != null) {
            BlockEntity newBlockEntity;
            BlockEntity blockEntity;
            CompoundTag tileEntityData = null;
            if (!level.isClientSide && (blockEntity = level.getBlockEntity(blockPos)) != null) {
                if (blockEntity instanceof DecoStorageTileEntity) {
                    DecoStorageTileEntity storage = (DecoStorageTileEntity)blockEntity;
                    tileEntityData = new CompoundTag();
                    storage.saveAdditional(tileEntityData, (HolderLookup.Provider)level.registryAccess());
                } else {
                    tileEntityData = blockEntity.saveWithFullMetadata((HolderLookup.Provider)level.registryAccess());
                }
            }
            Direction facing = (Direction)blockState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
            BlockState state = (BlockState)targetBlock.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)facing);
            level.setBlock(blockPos, state, 3);
            if (!level.isClientSide && tileEntityData != null && (newBlockEntity = level.getBlockEntity(blockPos)) != null) {
                if (newBlockEntity instanceof DecoStorageTileEntity) {
                    DecoStorageTileEntity storage = (DecoStorageTileEntity)newBlockEntity;
                    storage.loadAdditional(tileEntityData, (HolderLookup.Provider)level.registryAccess());
                    storage.setChanged();
                } else {
                    newBlockEntity.loadWithComponents(tileEntityData, (HolderLookup.Provider)level.registryAccess());
                    newBlockEntity.setChanged();
                }
            }
        } else {
            System.err.println("Block not found for link: " + link);
        }
    }

    public static void scriptSound(Level level, BlockPos blockPos, BlockState blockState, String sound) {
        if (sound != null && !sound.isEmpty()) {
            SoundEvent soundEvent = ModuleSounds.SOUNDS.get(sound);
            if (soundEvent != null) {
                level.playSound(null, blockPos, soundEvent, SoundSource.BLOCKS, 1.0f, 1.0f);
            } else {
                System.err.println("Sound not found: " + sound + ". Available sounds: " + String.valueOf(ModuleSounds.SOUNDS.keySet()));
            }
        }
    }

    public static void scriptAnimations(Level level, BlockPos blockPos, BlockState blockState, List<JsonContainer.Animation> animations) {
        if (!level.isClientSide) {
            // empty if block
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getShadeBrightness(BlockState state, BlockGetter world, BlockPos pos) {
        return 1.0f;
    }

    public boolean useShapeForLightOcclusion(BlockState state) {
        return false;
    }

    public VoxelShape getOcclusionShape(BlockState state, BlockGetter world, BlockPos pos) {
        return Shapes.empty();
    }

    public VoxelShape getVisualShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return this.getShape(state, world, pos, context);
    }

    private VoxelShape[] parseHitBox(JsonContainer.Entry meta, BBModel model) {
        if (meta == null || meta.model == null) {
            return new VoxelShape[]{Shapes.block()};
        }
        String cacheKey = meta.model + "_" + (meta.scale != 0.0f ? meta.scale : 1.0f) + "_" + (meta.shape != null ? meta.shape : "default");
        if (!CACHE_HIT_BOXES.containsKey(cacheKey)) {
            BBModel hitboxModel = null;
            if (meta.shape != null) {
                hitboxModel = ModuleBlocks.MAT_TO_BB_MODEL.get(meta.shape);
            }
            if (hitboxModel == null) {
                VoxelShape[] defaultShape = new VoxelShape[]{Shapes.block()};
                CACHE_HIT_BOXES.put(cacheKey, defaultShape);
                return defaultShape;
            }
            CACHE_HIT_BOXES.put(cacheKey, BBHitBox.parse(meta.scale, hitboxModel));
        }
        return CACHE_HIT_BOXES.get(cacheKey);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{BlockStateProperties.HORIZONTAL_FACING});
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    public long getSeed(BlockState blockState, BlockPos blockPos) {
        return BlockPos.asLong((int)blockPos.getX(), (int)blockPos.getY(), (int)blockPos.getZ());
    }

    public VoxelShape getShape(BlockState blockState, BlockGetter world, BlockPos blockPos, CollisionContext context) {
        if (this.shape == null) {
            this.shape = this.parseHitBox(this.meta, this.model);
            if (this.shape == null) {
                return Shapes.block();
            }
        }
        Direction direction = (Direction)blockState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        switch (direction) {
            case NORTH: {
                return this.shape.length > 0 ? this.shape[0] : Shapes.block();
            }
            case SOUTH: {
                return this.shape.length > 1 ? this.shape[1] : Shapes.block();
            }
            case EAST: {
                return this.shape.length > 2 ? this.shape[2] : Shapes.block();
            }
            case WEST: {
                return this.shape.length > 3 ? this.shape[3] : Shapes.block();
            }
        }
        return this.shape.length > 0 ? this.shape[0] : Shapes.block();
    }

    protected InteractionResult useWithoutItem(BlockState blockState, Level level, BlockPos blockPos, Player player, BlockHitResult blockHitResult) {
        if (player.isCrouching() && this.meta.script != null && this.meta.script.shift_on_use != null) {
            DecocraftBlock.script(level, blockPos, blockState, this.meta.script.shift_on_use);
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        if (!player.isCrouching() && this.meta.script != null && this.meta.script.on_use != null) {
            BlockEntity blockEntity;
            if (this.meta.script.on_use.storage != null && this.meta.script.on_use.storage.length == 2 && !level.isClientSide && (blockEntity = level.getBlockEntity(blockPos)) instanceof Container) {
                player.openMenu((MenuProvider)blockEntity);
            }
            DecocraftBlock.script(level, blockPos, blockState, this.meta.script.on_use);
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return InteractionResult.PASS;
    }

    public void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean notify) {
        if (this.meta != null && this.meta.decoref != null && this.meta.decoref.contains("locker") && !level.isClientSide) {
            Decocraft.LOGGER.info("Block placed: decoref={}, model={}, hidden={}", new Object[]{this.meta.decoref, this.meta.model, this.meta.hidden});
        }
        DecocraftBlock.script(level, pos, state, this.meta.script.added);
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean moved) {
        super.onRemove(state, level, pos, newState, moved);
        DecocraftBlock.script(level, pos, state, this.meta.script.removed);
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        if (this.meta.script != null && (this.meta.script.trigger != null || this.meta.script.on_use != null)) {
            return new DecocraftTileEntity((BlockEntityType)ModuleTileEntities.DECOCRAFT.get(), pos, state);
        }
        return null;
    }

    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        if (this.meta.script != null && (this.meta.script.trigger != null || this.meta.script.on_use != null)) {
            return DecocraftBlock.checkType(type, (BlockEntityType)ModuleTileEntities.DECOCRAFT.get(), DecocraftTileEntity::tick);
        }
        return null;
    }

    private static <E extends BlockEntity, A extends BlockEntity> BlockEntityTicker<A> checkType(BlockEntityType<A> givenType, BlockEntityType<E> expectedType, BlockEntityTicker<E> ticker) {
        return expectedType == givenType ? ticker : null;
    }

    public boolean hasTileEntity(BlockState state) {
        return this.meta != null && this.meta.script != null && this.meta.script.trigger != null;
    }

    public VoxelShape[] getShape() {
        if (this.shape == null) {
            this.shape = this.parseHitBox(this.meta, this.model);
        }
        return this.shape;
    }

    public void onToolModelSwitch(BlockState state, Level level, BlockPos pos) {
        if (this.meta != null && this.meta.script != null && this.meta.script.tool_modelswitch != null) {
            DecocraftBlock.script(level, pos, state, this.meta.script.tool_modelswitch);
        }
    }
}

