/*
 * Decompiled with CFR 0.152.
 */
package com.razz.decocraft_nature.common.storage;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_1799;
import net.minecraft.class_18;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_3218;
import net.minecraft.class_7225;

public class SharedStorageManager
extends class_18 {
    private static final String DATA_NAME = "decocraft_shared_storage";
    private final Map<String, StorageData> storageMap = new ConcurrentHashMap<String, StorageData>();

    public static SharedStorageManager getInstance(class_1937 world) {
        if (world instanceof class_3218) {
            class_3218 serverWorld = (class_3218)world;
            return (SharedStorageManager)serverWorld.method_17983().method_17924(new class_18.class_8645(SharedStorageManager::new, SharedStorageManager::createFromNbt, null), DATA_NAME);
        }
        return null;
    }

    public static SharedStorageManager createFromNbt(class_2487 nbt, class_7225.class_7874 registryLookup) {
        SharedStorageManager manager = new SharedStorageManager();
        class_2487 storageMapTag = nbt.method_10562("StorageMap");
        for (String storageId : storageMapTag.method_10541()) {
            class_2487 storageTag = storageMapTag.method_10562(storageId);
            int width = storageTag.method_10550("Width");
            int height = storageTag.method_10550("Height");
            class_2371 inventory = class_2371.method_10213((int)(width * height), (Object)class_1799.field_8037);
            if (storageTag.method_10545("Items")) {
                class_2487 itemsTag = storageTag.method_10562("Items");
                for (String slotKey : itemsTag.method_10541()) {
                    try {
                        int slot = Integer.parseInt(slotKey);
                        if (slot < 0 || slot >= inventory.size()) continue;
                        class_1799 stack = class_1799.method_57360((class_7225.class_7874)registryLookup, (class_2520)itemsTag.method_10562(slotKey)).orElse(class_1799.field_8037);
                        inventory.set(slot, (Object)stack);
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
            }
            manager.storageMap.put(storageId, new StorageData((class_2371<class_1799>)inventory, width, height));
        }
        return manager;
    }

    public class_2487 method_75(class_2487 nbt, class_7225.class_7874 registryLookup) {
        class_2487 storageMapTag = new class_2487();
        for (Map.Entry<String, StorageData> entry : this.storageMap.entrySet()) {
            String storageId = entry.getKey();
            StorageData data = entry.getValue();
            class_2487 storageTag = new class_2487();
            storageTag.method_10569("Width", data.width);
            storageTag.method_10569("Height", data.height);
            class_2487 itemsTag = new class_2487();
            for (int i = 0; i < data.inventory.size(); ++i) {
                class_1799 stack = (class_1799)data.inventory.get(i);
                if (stack.method_7960()) continue;
                itemsTag.method_10566(String.valueOf(i), stack.method_57375(registryLookup));
            }
            storageTag.method_10566("Items", (class_2520)itemsTag);
            storageMapTag.method_10566(storageId, (class_2520)storageTag);
        }
        nbt.method_10566("StorageMap", (class_2520)storageMapTag);
        return nbt;
    }

    public StorageData getOrCreateStorage(String storageId, int width, int height) {
        StorageData existing = this.storageMap.get(storageId);
        if (existing != null) {
            return existing;
        }
        StorageData newData = new StorageData(width, height);
        this.storageMap.put(storageId, newData);
        this.method_80();
        return newData;
    }

    public StorageData getStorage(String storageId) {
        return this.storageMap.get(storageId);
    }

    public void updateStorage(String storageId, StorageData data) {
        this.storageMap.put(storageId, data);
        this.method_80();
    }

    public void removeStorage(String storageId) {
        if (this.storageMap.remove(storageId) != null) {
            this.method_80();
        }
    }

    public int getStorageCount() {
        return this.storageMap.size();
    }

    public static class StorageData {
        public class_2371<class_1799> inventory;
        public int width;
        public int height;

        public StorageData(int width, int height) {
            this.width = width;
            this.height = height;
            this.inventory = class_2371.method_10213((int)(width * height), (Object)class_1799.field_8037);
        }

        public StorageData(class_2371<class_1799> inventory, int width, int height) {
            this.inventory = inventory;
            this.width = width;
            this.height = height;
        }
    }
}

