/*
 * Decompiled with CFR 0.152.
 */
package com.razz.decocraft_nature.common.tileentities;

import com.razz.decocraft_nature.common.blocks.DecoStorageBlock;
import com.razz.decocraft_nature.common.containers.DecoStorageScreenHandler;
import com.razz.decocraft_nature.common.storage.SharedStorageManager;
import com.razz.decocraft_nature.common.tileentities.ImplementedInventory;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_3222;

public class DecoStorageTileEntity
extends class_2586
implements ExtendedScreenHandlerFactory,
ImplementedInventory {
    private class_2371<class_1799> inventory;
    private int width;
    private int height;

    public DecoStorageTileEntity(class_2591<?> type, class_2338 pos, class_2680 state, int width, int height) {
        super(type, pos, state);
        this.width = width;
        this.height = height;
        System.out.println("DecoStorage: Constructor with dimensions: " + width + "x" + height + " at " + String.valueOf(pos));
    }

    public DecoStorageTileEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
        this.width = 3;
        this.height = 6;
        System.out.println("DecoStorage: Default constructor: 3x6 at " + String.valueOf(pos));
    }

    private String getStorageId() {
        return this.method_11016().method_10263() + "_" + this.method_11016().method_10264() + "_" + this.method_11016().method_10260();
    }

    @Override
    public class_2371<class_1799> getItems() {
        if (this.inventory == null) {
            this.refreshInventoryFromSharedStorage();
        }
        return this.inventory;
    }

    private void refreshInventoryFromSharedStorage() {
        if (this.field_11863 != null && !this.field_11863.field_9236) {
            SharedStorageManager manager = SharedStorageManager.getInstance(this.field_11863);
            if (manager != null) {
                String storageId = this.getStorageId();
                SharedStorageManager.StorageData data = manager.getStorage(storageId);
                if (data != null) {
                    this.inventory = class_2371.method_10213((int)(this.width * this.height), (Object)class_1799.field_8037);
                    for (int i = 0; i < Math.min(data.inventory.size(), this.inventory.size()); ++i) {
                        this.inventory.set(i, (Object)((class_1799)data.inventory.get(i)).method_7972());
                    }
                    System.out.println("DecoStorage: Loaded " + this.countNonEmptyItems() + " items from SharedStorage");
                } else {
                    this.inventory = class_2371.method_10213((int)(this.width * this.height), (Object)class_1799.field_8037);
                    System.out.println("DecoStorage: Created new empty inventory for " + storageId);
                }
            }
        } else if (this.inventory == null) {
            this.inventory = class_2371.method_10213((int)(this.width * this.height), (Object)class_1799.field_8037);
        }
    }

    public class_2561 method_5476() {
        return class_2561.method_43470((String)"Storage");
    }

    public class_1703 createMenu(int syncId, class_1661 inv, class_1657 player) {
        return new DecoStorageScreenHandler(syncId, inv, this, this.width, this.height);
    }

    public void writeScreenOpeningData(class_3222 player, class_2540 buf) {
        buf.writeInt(this.width);
        buf.writeInt(this.height);
    }

    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        if (nbt.method_10545("Width")) {
            this.width = nbt.method_10550("Width");
        }
        if (nbt.method_10545("Height")) {
            this.height = nbt.method_10550("Height");
        }
        if (this.method_11010().method_26204() instanceof DecoStorageBlock) {
            DecoStorageBlock block = (DecoStorageBlock)this.method_11010().method_26204();
            if (block.meta != null && block.meta.script != null && block.meta.script.on_use != null && block.meta.script.on_use.storage != null && block.meta.script.on_use.storage.length == 2) {
                this.width = block.meta.script.on_use.storage[0];
                this.height = block.meta.script.on_use.storage[1];
            }
        }
        if (this.field_11863 != null && !this.field_11863.field_9236) {
            this.refreshInventoryFromSharedStorage();
        }
        System.out.println("DecoStorage: Loaded from NBT - dimensions: " + this.width + "x" + this.height);
    }

    public void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        nbt.method_10569("Width", this.width);
        nbt.method_10569("Height", this.height);
        System.out.println("DecoStorage: Saved to NBT - dimensions: " + this.width + "x" + this.height);
    }

    @Override
    public void method_5431() {
        SharedStorageManager manager;
        super.method_5431();
        if (this.field_11863 != null && !this.field_11863.field_9236 && this.inventory != null && (manager = SharedStorageManager.getInstance(this.field_11863)) != null) {
            String storageId = this.getStorageId();
            class_2371 inventoryCopy = class_2371.method_10213((int)this.inventory.size(), (Object)class_1799.field_8037);
            for (int i = 0; i < this.inventory.size(); ++i) {
                inventoryCopy.set(i, (Object)((class_1799)this.inventory.get(i)).method_7972());
            }
            SharedStorageManager.StorageData data = new SharedStorageManager.StorageData((class_2371<class_1799>)inventoryCopy, this.width, this.height);
            manager.updateStorage(storageId, data);
            System.out.println("DecoStorage: Updated SharedStorage with " + this.countNonEmptyItems() + " items for " + storageId);
        }
    }

    private int countNonEmptyItems() {
        if (this.inventory == null) {
            return 0;
        }
        int count = 0;
        for (class_1799 stack : this.inventory) {
            if (stack.method_7960()) continue;
            ++count;
        }
        return count;
    }

    public class_2487 method_16887() {
        SharedStorageManager manager;
        class_2487 nbt = super.method_16887();
        if (this.field_11863 != null && !this.field_11863.field_9236 && (manager = SharedStorageManager.getInstance(this.field_11863)) != null) {
            String storageId = this.getStorageId();
            SharedStorageManager.StorageData data = manager.getOrCreateStorage(storageId, this.width, this.height);
            nbt.method_10569("Width", this.width);
            nbt.method_10569("Height", this.height);
            for (int i = 0; i < data.inventory.size(); ++i) {
                class_1799 stack = (class_1799)data.inventory.get(i);
                if (stack.method_7960()) continue;
                class_2487 itemNbt = new class_2487();
                stack.method_7953(itemNbt);
                nbt.method_10566("item_" + i, (class_2520)itemNbt);
            }
        }
        return nbt;
    }

    public void readNbtFromClient(class_2487 nbt) {
        super.method_11014(nbt);
        if (this.field_11863 != null && this.field_11863.field_9236) {
            if (nbt.method_10545("Width")) {
                this.width = nbt.method_10550("Width");
            }
            if (nbt.method_10545("Height")) {
                this.height = nbt.method_10550("Height");
            }
            this.inventory = class_2371.method_10213((int)(this.width * this.height), (Object)class_1799.field_8037);
            for (String key : nbt.method_10541()) {
                if (!key.startsWith("item_")) continue;
                try {
                    int slot = Integer.parseInt(key.substring(5));
                    if (slot < 0 || slot >= this.inventory.size()) continue;
                    class_1799 stack = class_1799.method_7915((class_2487)nbt.method_10562(key));
                    this.inventory.set(slot, (Object)stack);
                }
                catch (NumberFormatException numberFormatException) {}
            }
            System.out.println("DecoStorage: Received client sync with " + this.countNonEmptyItems() + " items");
        }
    }

    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }
}

