/*
 * Decompiled with CFR 0.152.
 */
package com.razz.decocraft_nature.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.razz.decocraft_nature.models.bbmodel.BBModelParts;
import com.razz.decocraft_nature.utils.DecoMath;
import com.razz.decocraft_nature.utils.vector.Vector3f;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.core.Direction;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.AxisAngle4f;
import org.joml.Quaternionf;
import org.joml.Vector3fc;

@OnlyIn(value=Dist.CLIENT)
public class AnimatedModelRenderer
extends ModelPart {
    private static final Set<Direction> FACES = Set.of(Direction.NORTH, Direction.SOUTH, Direction.EAST, Direction.WEST, Direction.UP, Direction.DOWN);
    public final String name;
    private final BBModelParts.Element element;
    private final int xTexSize;
    private final int yTexSize;
    private long index = 0L;

    public AnimatedModelRenderer(int width, int height, BBModelParts.Element element, String name) {
        super(new ArrayList(), new HashMap());
        this.element = element;
        this.name = name;
        this.xTexSize = width;
        this.yTexSize = height;
    }

    public void addChild(String name, ModelPart part) {
        this.f_104213_.put(name + "_" + this.index++, part);
    }

    public ModelPart addBox(float x, float y, float z, float dimX, float dimY, float dimZ) {
        this.addBox(x, y, z, dimX, dimY, dimZ, 0.0f, 0.0f, 0.0f, false);
        return this;
    }

    public void addBox(float x, float y, float z, float dimX, float dimY, float dimZ, float growX, float growY, float growZ, boolean mirror) {
        this.f_104212_.add(new ModelBox(x, y, z, dimX, dimY, dimZ, growX, growY, growZ, mirror, this.xTexSize, this.yTexSize, this.element));
    }

    public void m_104299_(PoseStack matrixIn) {
        matrixIn.m_85837_((double)(this.f_104200_ / 16.0f), (double)(this.f_104201_ / 16.0f), (double)(this.f_104202_ / 16.0f));
        if (this.f_104205_ != 0.0f) {
            matrixIn.m_252781_(new Quaternionf(new AxisAngle4f(DecoMath.toRadians(this.f_104205_), (Vector3fc)Vector3f.ZP)));
        }
        if (this.f_104204_ != 0.0f) {
            matrixIn.m_252781_(new Quaternionf(new AxisAngle4f(DecoMath.toRadians(this.f_104204_), (Vector3fc)Vector3f.YP)));
        }
        if (this.f_104203_ != 0.0f) {
            matrixIn.m_252781_(new Quaternionf(new AxisAngle4f(DecoMath.toRadians(this.f_104203_), (Vector3fc)Vector3f.XP)));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class ModelBox
    extends ModelPart.Cube {
        public ModelBox(float x, float y, float z, float dimX, float dimY, float dimZ, float growX, float growY, float growZ, boolean mirror, float texWidthScaled, float texHeightScaled, BBModelParts.Element element) {
            super(0, 0, x, y, z, dimX, dimY, dimZ, growX, growY, growZ, mirror, texWidthScaled, texHeightScaled, FACES);
            this.f_104335_ = x;
            this.f_104336_ = y;
            this.f_104337_ = z;
            this.f_104338_ = x + dimX;
            this.f_104339_ = y + dimY;
            this.f_104340_ = z + dimZ;
            this.f_104341_ = new ModelPart.Polygon[6];
            float xMax = x + dimX;
            float yMax = y + dimY;
            float zMax = z + dimZ;
            ModelPart.Vertex posTex1 = new ModelPart.Vertex(x, y, z, 0.0f, 0.0f);
            ModelPart.Vertex posTex2 = new ModelPart.Vertex(xMax, y, z, 0.0f, 8.0f);
            ModelPart.Vertex posTex3 = new ModelPart.Vertex(xMax, yMax, z, 8.0f, 8.0f);
            ModelPart.Vertex posTex4 = new ModelPart.Vertex(x, yMax, z, 8.0f, 0.0f);
            ModelPart.Vertex posTex5 = new ModelPart.Vertex(x, y, zMax, 0.0f, 0.0f);
            ModelPart.Vertex posTex6 = new ModelPart.Vertex(xMax, y, zMax, 0.0f, 8.0f);
            ModelPart.Vertex posTex7 = new ModelPart.Vertex(xMax, yMax, zMax, 8.0f, 8.0f);
            ModelPart.Vertex posTex8 = new ModelPart.Vertex(x, yMax, zMax, 8.0f, 0.0f);
            BBModelParts.UVCoordinate uvDown = element.faces.get((Object)Direction.DOWN).uv;
            BBModelParts.UVCoordinate uvUp = element.faces.get((Object)Direction.UP).uv;
            BBModelParts.UVCoordinate uvNorth = element.faces.get((Object)Direction.NORTH).uv;
            BBModelParts.UVCoordinate uvSouth = element.faces.get((Object)Direction.SOUTH).uv;
            BBModelParts.UVCoordinate uvEast = element.faces.get((Object)Direction.EAST).uv;
            BBModelParts.UVCoordinate uvWest = element.faces.get((Object)Direction.WEST).uv;
            this.f_104341_[2] = new ModelPart.Polygon(new ModelPart.Vertex[]{posTex6, posTex5, posTex1, posTex2}, uvDown.u0, uvDown.v0, uvDown.u1, uvDown.v1, texWidthScaled, texHeightScaled, mirror, Direction.DOWN);
            this.f_104341_[3] = new ModelPart.Polygon(new ModelPart.Vertex[]{posTex3, posTex4, posTex8, posTex7}, uvUp.u0, uvUp.v0, uvUp.u1, uvUp.v1, texWidthScaled, texHeightScaled, mirror, Direction.UP);
            this.f_104341_[1] = new ModelPart.Polygon(new ModelPart.Vertex[]{posTex8, posTex4, posTex1, posTex5}, uvWest.u0, uvWest.v0, uvWest.u1, uvWest.v1, texWidthScaled, texHeightScaled, mirror, Direction.WEST);
            this.f_104341_[4] = new ModelPart.Polygon(new ModelPart.Vertex[]{posTex4, posTex3, posTex2, posTex1}, uvNorth.u0, uvNorth.v0, uvNorth.u1, uvNorth.v1, texWidthScaled, texHeightScaled, mirror, Direction.NORTH);
            this.f_104341_[0] = new ModelPart.Polygon(new ModelPart.Vertex[]{posTex3, posTex7, posTex6, posTex2}, uvEast.u0, uvEast.v0, uvEast.u1, uvEast.v1, texWidthScaled, texHeightScaled, mirror, Direction.EAST);
            this.f_104341_[5] = new ModelPart.Polygon(new ModelPart.Vertex[]{posTex7, posTex8, posTex5, posTex6}, uvSouth.u0, uvSouth.v0, uvSouth.u1, uvSouth.v1, texWidthScaled, texHeightScaled, mirror, Direction.SOUTH);
        }
    }
}

