/*
 * Decompiled with CFR 0.152.
 */
package com.razz.decocraft_nature.common.blocks;

import com.razz.decocraft_nature.common.JsonContainer;
import com.razz.decocraft_nature.common.ModuleBlocks;
import com.razz.decocraft_nature.common.ModuleSounds;
import com.razz.decocraft_nature.common.ModuleTileEntities;
import com.razz.decocraft_nature.common.properties.DecoProperty;
import com.razz.decocraft_nature.common.tileentities.AnimatedTileEntity;
import com.razz.decocraft_nature.common.tileentities.DecocraftTileEntity;
import com.razz.decocraft_nature.models.bbmodel.BBHitBox;
import com.razz.decocraft_nature.models.bbmodel.BBModel;
import com.razz.decocraft_nature.models.bbmodel.BBModelParts;
import com.razz.decocraft_nature.utils.Particle;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;

public class DecocraftBlock
extends Block
implements EntityBlock {
    private static final Map<String, VoxelShape[]> CACHE_HIT_BOXES = new HashMap<String, VoxelShape[]>();
    public final JsonContainer.Entry meta;
    public final BBModel model;
    private final VoxelShape[] shape;
    private final Map<String, Particle> particles;

    public DecocraftBlock(JsonContainer.Entry meta, BBModel model) {
        super(DecocraftBlock.getProperties(meta));
        this.meta = meta;
        this.model = model;
        this.shape = this.parseHitBox(meta, model);
        this.particles = this.parseParticles();
    }

    private static BlockBehaviour.Properties getProperties(JsonContainer.Entry meta) {
        if (meta.passable) {
            return BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60910_();
        }
        return BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60955_();
    }

    public static void script(Level world, BlockPos blockPos, BlockState blockState, JsonContainer.Action action) {
        if (action != null) {
            if (action.link != null) {
                DecocraftBlock.scriptLink(world, blockPos, blockState, action.link);
            }
            if (action.sound != null) {
                DecocraftBlock.scriptSound(world, blockPos, blockState, action.sound);
            }
            if (action.animations != null) {
                DecocraftBlock.scriptAnimations(world, blockPos, blockState, action.animations);
            }
        }
    }

    public static void scriptLink(Level world, BlockPos blockPos, BlockState blockState, String link) {
        BlockState state = (BlockState)ModuleBlocks.DECOBLOCKS.get(link).m_49966_().m_61124_((Property)DecoProperty.FACING, (Comparable)((Direction)blockState.m_61143_((Property)DecoProperty.FACING)));
        world.m_7731_(blockPos, state, 10);
    }

    public static void scriptSound(Level world, BlockPos blockPos, BlockState blockState, String sound) {
        world.m_6263_(null, (double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_(), ModuleSounds.SOUNDS.get(sound), SoundSource.BLOCKS, 0.5f, world.f_46441_.m_188501_() * 0.1f + 0.9f);
    }

    public static void scriptAnimations(Level world, BlockPos blockPos, BlockState blockState, List<JsonContainer.Animation> animations) {
        BlockEntity te;
        if (!world.m_5776_() && (te = world.m_7702_(blockPos)) instanceof AnimatedTileEntity) {
            AnimatedTileEntity tile = (AnimatedTileEntity)te;
            JsonContainer.Animation anim = animations.stream().filter(k -> Objects.equals(k.from, tile.getAnimationName()) || Objects.equals(k.from, "any")).findFirst().orElse(animations.get(0));
            tile.setAnimationName(anim.to);
        }
    }

    private Map<String, Particle> parseParticles() {
        if (this.meta.script.particles == null) {
            return null;
        }
        HashMap<String, Particle> particles = new HashMap<String, Particle>();
        for (Map.Entry<String, JsonContainer.Particle> entry : this.meta.script.particles.entrySet()) {
            JsonContainer.Particle particle = entry.getValue();
            this.model.outlinerFlatList.stream().filter(outliner -> outliner.name.equals("particle_" + (String)entry.getKey())).forEach(node -> {
                BBModelParts.Element element = (BBModelParts.Element)this.model.uuidMap.get(node.uuid);
                particles.put((String)entry.getKey(), new Particle(new ResourceLocation(particle.name), 0.5f + element.position.x / 16.0f, element.position.y / 16.0f, 0.5f + element.position.z / 16.0f, particle.vx, particle.vy, particle.vz, particle.delay));
            });
        }
        return particles;
    }

    @Deprecated
    @OnlyIn(value=Dist.CLIENT)
    public float m_7749_(BlockState p_220080_1_, BlockGetter p_220080_2_, BlockPos p_220080_3_) {
        return 1.0f;
    }

    private VoxelShape[] parseHitBox(JsonContainer.Entry meta, BBModel model) {
        if (!CACHE_HIT_BOXES.containsKey(meta.model + "_" + meta.scale)) {
            CACHE_HIT_BOXES.put(meta.model + "_" + meta.scale, BBHitBox.parse(meta.scale, ModuleBlocks.MAT_TO_BB_MODEL.get(meta.shape)));
        }
        return CACHE_HIT_BOXES.get(meta.model + "_" + meta.scale);
    }

    public VoxelShape[] getShape() {
        return this.shape;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{DecoProperty.FACING});
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)DecoProperty.FACING, (Comparable)context.m_8125_().m_122424_());
    }

    public long m_7799_(BlockState blockState, BlockPos blockPos) {
        return Mth.m_14057_((Vec3i)blockPos);
    }

    public VoxelShape m_5940_(BlockState blockState, BlockGetter reader, BlockPos blockPos, CollisionContext context) {
        Direction direction = (Direction)blockState.m_61143_((Property)DecoProperty.FACING);
        switch (direction) {
            case NORTH: {
                return this.shape[0];
            }
            case SOUTH: {
                return this.shape[1];
            }
            case EAST: {
                return this.shape[2];
            }
            case WEST: {
                return this.shape[3];
            }
        }
        return this.shape[0];
    }

    public InteractionResult m_6227_(BlockState blockState, Level world, BlockPos blockPos, Player playerEntity, InteractionHand hand, BlockHitResult blockRayTraceResult) {
        if (playerEntity.m_6144_() && this.meta.script.shift_on_use != null) {
            DecocraftBlock.script(world, blockPos, blockState, this.meta.script.shift_on_use);
            return InteractionResult.m_19078_((boolean)world.f_46443_);
        }
        if (!playerEntity.m_6144_() && this.meta.script.on_use != null) {
            DecocraftBlock.script(world, blockPos, blockState, this.meta.script.on_use);
            return InteractionResult.m_19078_((boolean)world.f_46443_);
        }
        return InteractionResult.PASS;
    }

    public void m_6807_(BlockState blockState, Level world, BlockPos blockPos, BlockState blockState2, boolean p_220082_5_) {
        DecocraftBlock.script(world, blockPos, blockState, this.meta.script.added);
    }

    public void m_6810_(BlockState blockState, Level world, BlockPos blockPos, BlockState replaced, boolean p_196243_5_) {
        super.m_6810_(blockState, world, blockPos, replaced, p_196243_5_);
        DecocraftBlock.script(world, blockPos, blockState, this.meta.script.removed);
    }

    public void onAnimationStart(BlockState blockState, Level world, BlockPos blockPos) {
        DecocraftBlock.script(world, blockPos, blockState, this.meta.script.animation_start);
    }

    public void onAnimationEnd(BlockState blockState, Level world, BlockPos blockPos) {
        DecocraftBlock.script(world, blockPos, blockState, this.meta.script.animation_end);
    }

    public void onToolModelSwitch(BlockState blockState, Level world, BlockPos blockPos) {
        DecocraftBlock.script(world, blockPos, blockState, this.meta.script.tool_modelswitch);
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return this.meta.script.trigger != null || this.meta.flipbook.images > 1 ? new DecocraftTileEntity(pos, state, this.meta) : null;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return type == ModuleTileEntities.DECOCRAFT ? DecocraftTileEntity::tick : null;
    }

    public int getLightEmission(BlockState state, BlockGetter world, BlockPos pos) {
        return this.meta.script.light;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_214162_(BlockState state, Level world, BlockPos pos, RandomSource random) {
        if (this.particles != null) {
            for (Map.Entry<String, Particle> entry : this.particles.entrySet()) {
                Particle particle = entry.getValue();
                SimpleParticleType particleType = (SimpleParticleType)ForgeRegistries.PARTICLE_TYPES.getValue(particle.particleType);
                world.m_7106_((ParticleOptions)particleType, (double)((float)pos.m_123341_() + particle.x), (double)((float)pos.m_123342_() + particle.y), (double)((float)pos.m_123343_() + particle.z), (double)particle.vx, (double)particle.vy, (double)particle.vz);
            }
        }
    }
}

