/*
 * Decompiled with CFR 0.152.
 */
package com.razz.decocraft_nature.common.groups;

import com.razz.decocraft_nature.common.ModuleBlocks;
import com.razz.decocraft_nature.common.ModuleItems;
import com.razz.decocraft_nature.common.blocks.DecocraftBlock;
import com.razz.decocraft_nature.common.groups.DecocraftGroup;
import com.razz.decocraft_nature.utils.MapUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.event.CreativeModeTabEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class GroupSelector {
    public static final Map<String, DecocraftGroup> SELECT = new HashMap<String, DecocraftGroup>();
    public static final Map<String, CreativeModeTab> TABS = new HashMap<String, CreativeModeTab>();

    @SubscribeEvent
    public static void onCreativeModeTabRegister(CreativeModeTabEvent.Register event) {
        for (Map.Entry<String, DecocraftGroup> entry : MapUtil.sortByKey(SELECT).entrySet()) {
            String key = entry.getKey();
            DecocraftGroup group = entry.getValue();
            TABS.put(key, event.registerCreativeModeTab(new ResourceLocation("decocraft_nature", key), builder -> builder.m_257737_(() -> {
                Block block = ModuleBlocks.DECOBLOCKS.get(group.icon());
                if (block == null) {
                    System.out.println("Missing group icon: " + group.icon());
                    return new ItemStack((ItemLike)Items.f_42200_);
                }
                return new ItemStack((ItemLike)ModuleBlocks.DECOBLOCKS.get(group.icon()));
            }).m_257501_((features, output) -> {
                ModuleBlocks.DECOBLOCKS_TABS.stream().filter(f -> Objects.equals(((DecocraftBlock)f).meta.tabs, key) && !((DecocraftBlock)f).meta.hidden).forEach(f -> output.m_246342_(new ItemStack((ItemLike)f)));
                if (key.equals("crafting")) {
                    output.m_246342_(new ItemStack((ItemLike)ModuleItems.RAW_MATERIAL));
                    output.m_246342_(new ItemStack((ItemLike)ModuleItems.TOOL_MODELSWITCH));
                }
            }).m_257941_((Component)Component.m_237115_((String)("itemGroup." + group.label()))).m_257652_()));
        }
    }

    static {
        if (Objects.equals("decocraft_nature", "decocraft")) {
            SELECT.put("toys", new DecocraftGroup("decocraft_nature.toys", "stuffed_creeper"));
            SELECT.put("crafting", new DecocraftGroup("decocraft_nature.crafting", "decobench"));
            SELECT.put("hobby", new DecocraftGroup("decocraft_nature.hobby", "spinning_wheel"));
            SELECT.put("clutter", new DecocraftGroup("decocraft_nature.clutter", "coin_pile_gold"));
            SELECT.put("comfort", new DecocraftGroup("decocraft_nature.comfort", "rocking_chair_oak"));
            SELECT.put("wall_decor", new DecocraftGroup("decocraft_nature.wall_decor", "empire_strikes_back"));
            SELECT.put("signs", new DecocraftGroup("decocraft_nature.signs", "hanging_apothecary"));
            SELECT.put("seasonal", new DecocraftGroup("decocraft_nature.seasonal", "papel_picado_white"));
            SELECT.put("flags", new DecocraftGroup("decocraft_nature.flags", "mexico"));
            SELECT.put("surface", new DecocraftGroup("decocraft_nature.surface", "wooden_table_oak"));
            SELECT.put("tech", new DecocraftGroup("decocraft_nature.tech", "atm"));
            SELECT.put("storage", new DecocraftGroup("decocraft_nature.storage", "barrel"));
            SELECT.put("lighting", new DecocraftGroup("decocraft_nature.lighting", "stained_glass_table_lamp_popsicle"));
            SELECT.put("bathroom", new DecocraftGroup("decocraft_nature.bathroom", "toilet_white"));
            SELECT.put("kitchen", new DecocraftGroup("decocraft_nature.kitchen", "toaster_silver"));
            SELECT.put("patreon", new DecocraftGroup("decocraft_nature.patreon", "000_dpop_razz"));
            SELECT.put("medieval", new DecocraftGroup("decocraft_nature.medieval", "medieval_high_canopy_bed_queen_red"));
            SELECT.put("shops", new DecocraftGroup("decocraft_nature.shops", "clothes_rack_4"));
            SELECT.put("food", new DecocraftGroup("decocraft_nature.food", "bowl_of_cereal_minecraft"));
            SELECT.put("pets", new DecocraftGroup("decocraft_nature.pets", "cat_tree"));
            SELECT.put("laundry", new DecocraftGroup("decocraft_nature.laundry", "washer"));
        } else if (Objects.equals("decocraft_nature", "decocraft_nature")) {
            SELECT.put("crafting", new DecocraftGroup("decocraft_nature.crafting", "decobench"));
            SELECT.put("ground_cover", new DecocraftGroup("decocraft_nature.ground_cover", "clovers_1"));
            SELECT.put("climbing_plants", new DecocraftGroup("decocraft_nature.climbing_plants", "ivy_wall_full"));
            SELECT.put("other_plants", new DecocraftGroup("decocraft_nature.other_plants", "venus_flytrap"));
            SELECT.put("flowers", new DecocraftGroup("decocraft_nature.flowers", "foxglove_group_pink"));
            SELECT.put("trees", new DecocraftGroup("decocraft_nature.trees", "log_broken_oak"));
            SELECT.put("potted_plants", new DecocraftGroup("decocraft_nature.potted_plants", "potted_calathea"));
            SELECT.put("cacti_succulents", new DecocraftGroup("decocraft_nature.cacti_succulents", "nopal_3"));
            SELECT.put("fungi", new DecocraftGroup("decocraft_nature.fungi", "fly_agaric_2"));
            SELECT.put("aquatic_plants", new DecocraftGroup("decocraft_nature.aquatic_plants", "lotus_flower"));
            SELECT.put("garden_decor", new DecocraftGroup("decocraft_nature.garden_decor", "bird_house_3"));
        }
    }
}

