/*
 * Decompiled with CFR 0.152.
 */
package com.razznature.decocraft_nature.common.blocks;

import com.mojang.serialization.MapCodec;
import com.razznature.decocraft_nature.common.JsonContainer;
import com.razznature.decocraft_nature.common.ModuleBlocks;
import com.razznature.decocraft_nature.common.ModuleTileEntities;
import com.razznature.decocraft_nature.common.blocks.DecocraftBlock;
import com.razznature.decocraft_nature.common.tileentities.AnimatedTileEntity;
import com.razznature.decocraft_nature.models.bbmodel.BBHitBox;
import com.razznature.decocraft_nature.models.bbmodel.BBModel;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2464;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3620;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import org.jetbrains.annotations.Nullable;

public class DecoAnimatedBlock
extends class_2237 {
    private static final Map<String, class_265[]> CACHE_HIT_BOXES = Collections.synchronizedMap(new HashMap());
    public static final MapCodec<DecoAnimatedBlock> CODEC = MapCodec.unit(() -> {
        throw new UnsupportedOperationException("DecoAnimatedBlock cannot be created from codec");
    });
    public final JsonContainer.Entry meta;
    public final BBModel model;
    private class_265[] shape;

    protected MapCodec<? extends class_2237> method_53969() {
        return CODEC;
    }

    public DecoAnimatedBlock(JsonContainer.Entry meta, BBModel model) {
        super(DecoAnimatedBlock.getProperties(meta));
        this.meta = meta;
        this.model = model;
        this.method_9590((class_2680)((class_2680)this.field_10647.method_11664()).method_11657((class_2769)class_2741.field_12481, (Comparable)class_2350.field_11043));
    }

    private static class_4970.class_2251 getProperties(JsonContainer.Entry meta) {
        class_4970.class_2251 settings = meta.passable ? class_4970.class_2251.method_9637().method_31710(class_3620.field_16023).method_9634() : class_4970.class_2251.method_9637().method_31710(class_3620.field_16023).method_22488();
        if (meta.lighting > 0) {
            settings = settings.method_9631(state -> meta.lighting);
        }
        return settings;
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{class_2741.field_12481});
    }

    @Nullable
    public class_2680 method_9605(class_1750 context) {
        return (class_2680)this.method_9564().method_11657((class_2769)class_2741.field_12481, (Comparable)context.method_8042().method_10153());
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new AnimatedTileEntity(ModuleTileEntities.ANIMATED_TE, pos, state);
    }

    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11456;
    }

    private class_265[] parseHitBox(JsonContainer.Entry meta, BBModel model) {
        if (meta == null || meta.model == null) {
            return new class_265[]{class_259.method_1077()};
        }
        String cacheKey = meta.model + "_" + (meta.scale != 0.0f ? meta.scale : 1.0f) + "_" + (meta.shape != null ? meta.shape : "default");
        if (!CACHE_HIT_BOXES.containsKey(cacheKey)) {
            BBModel customShape;
            BBModel hitboxModel = model;
            if (meta.shape != null && (customShape = ModuleBlocks.MAT_TO_BB_MODEL.get(meta.shape)) != null) {
                hitboxModel = customShape;
            }
            float scale = meta.scale != 0.0f ? meta.scale : 1.0f;
            CACHE_HIT_BOXES.put(cacheKey, BBHitBox.parse(scale, hitboxModel));
        }
        return CACHE_HIT_BOXES.get(cacheKey);
    }

    public class_265 method_9530(class_2680 blockState, class_1922 world, class_2338 blockPos, class_3726 context) {
        if (this.shape == null) {
            this.shape = this.parseHitBox(this.meta, this.model);
            if (this.shape == null) {
                return class_259.method_1077();
            }
        }
        class_2350 direction = (class_2350)blockState.method_11654((class_2769)class_2741.field_12481);
        switch (direction) {
            case field_11043: {
                return this.shape.length > 0 ? this.shape[0] : class_259.method_1077();
            }
            case field_11035: {
                return this.shape.length > 1 ? this.shape[1] : class_259.method_1077();
            }
            case field_11034: {
                return this.shape.length > 2 ? this.shape[2] : class_259.method_1077();
            }
            case field_11039: {
                return this.shape.length > 3 ? this.shape[3] : class_259.method_1077();
            }
        }
        return this.shape.length > 0 ? this.shape[0] : class_259.method_1077();
    }

    protected class_1269 method_55766(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_3965 hit) {
        System.out.println("DEBUG: DecoAnimatedBlock onUse called for block: " + (this.meta != null ? this.meta.decoref : "unknown"));
        if (player.method_5715() && this.meta.script != null && this.meta.script.shift_on_use != null) {
            System.out.println("DEBUG: DecoAnimatedBlock executing shift_on_use script");
            if (!world.field_9236) {
                DecocraftBlock.script(world, pos, state, this.meta.script.shift_on_use);
                return class_1269.field_5812;
            }
            return class_1269.field_21466;
        }
        if (!player.method_5715() && this.meta.script != null && this.meta.script.on_use != null && this.meta.script.on_use.link != null) {
            System.out.println("DEBUG: DecoAnimatedBlock executing on_use script with link: " + this.meta.script.on_use.link);
            if (!world.field_9236) {
                DecocraftBlock.script(world, pos, state, this.meta.script.on_use);
                return class_1269.field_5812;
            }
            return class_1269.field_21466;
        }
        if (this.meta.script != null && this.meta.script.on_use != null) {
            System.out.println("DEBUG: DecoAnimatedBlock cycling animation");
            if (!world.field_9236) {
                class_2586 blockEntity = world.method_8321(pos);
                if (blockEntity instanceof AnimatedTileEntity) {
                    AnimatedTileEntity animatedTileEntity = (AnimatedTileEntity)blockEntity;
                    animatedTileEntity.cycleAnimation();
                }
                return class_1269.field_5812;
            }
            return class_1269.field_21466;
        }
        System.out.println("DEBUG: DecoAnimatedBlock no script to execute");
        return class_1269.field_5811;
    }

    public void onToolModelSwitch(class_2680 state, class_1937 world, class_2338 pos) {
        if (this.meta != null && this.meta.script != null && this.meta.script.tool_modelswitch != null) {
            DecocraftBlock.script(world, pos, state, this.meta.script.tool_modelswitch);
        }
    }

    public float method_32913() {
        return 1.0f;
    }
}

