/*
 * Decompiled with CFR 0.152.
 */
package com.razznature.decocraft.common.blocks;

import com.mojang.serialization.MapCodec;
import com.razznature.decocraft.common.JsonContainer;
import com.razznature.decocraft.common.ModuleTileEntities;
import com.razznature.decocraft.common.blocks.DecocraftBlock;
import com.razznature.decocraft.common.tileentities.AnimatedTileEntity;
import com.razznature.decocraft.models.bbmodel.BBModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class DecoAnimatedBlock
extends Block
implements EntityBlock {
    public static final MapCodec<DecoAnimatedBlock> CODEC = MapCodec.unit(() -> {
        throw new UnsupportedOperationException("DecoAnimatedBlock cannot be created from codec");
    });
    public final JsonContainer.Entry meta;
    public final BBModel model;

    protected MapCodec<? extends Block> codec() {
        return CODEC;
    }

    public DecoAnimatedBlock(JsonContainer.Entry meta, BBModel model) {
        super(DecoAnimatedBlock.getProperties(meta));
        this.meta = meta;
        this.model = model;
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH));
    }

    private static BlockBehaviour.Properties getProperties(JsonContainer.Entry meta) {
        BlockBehaviour.Properties settings = meta.passable ? BlockBehaviour.Properties.of().mapColor(MapColor.STONE).noCollission() : BlockBehaviour.Properties.of().mapColor(MapColor.STONE).noOcclusion();
        if (meta.lighting > 0) {
            settings = settings.lightLevel(state -> meta.lighting);
        }
        return settings;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{BlockStateProperties.HORIZONTAL_FACING});
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new AnimatedTileEntity((BlockEntityType)ModuleTileEntities.ANIMATED_TE.get(), pos, state);
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hit) {
        if (player.isCrouching() && this.meta.script != null && this.meta.script.shift_on_use != null) {
            DecocraftBlock.script(level, pos, state, this.meta.script.shift_on_use);
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        if (!player.isCrouching() && this.meta.script != null && this.meta.script.on_use != null && this.meta.script.on_use.link != null) {
            DecocraftBlock.script(level, pos, state, this.meta.script.on_use);
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        if (this.meta.script != null && this.meta.script.on_use != null) {
            BlockEntity blockEntity;
            if (!level.isClientSide && (blockEntity = level.getBlockEntity(pos)) instanceof AnimatedTileEntity) {
                AnimatedTileEntity animatedTileEntity = (AnimatedTileEntity)blockEntity;
                animatedTileEntity.cycleAnimation();
            }
            return level.isClientSide ? InteractionResult.SUCCESS : InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }

    public void onToolModelSwitch(BlockState state, Level level, BlockPos pos) {
        if (this.meta != null && this.meta.script != null && this.meta.script.tool_modelswitch != null) {
            DecocraftBlock.script(level, pos, state, this.meta.script.tool_modelswitch);
        }
    }
}

