/*
 * Decompiled with CFR 0.152.
 */
package com.razznature.decocraft.common.tileentities;

import com.razznature.decocraft.common.ModuleItems;
import com.razznature.decocraft.common.ModuleTileEntities;
import com.razznature.decocraft.common.items.DecoBlockItem;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class DecobenchTileEntity
extends BlockEntity {
    public static final float COLORS_MAX = 256.0f;
    public static final float RAW_MATERIAL_MAX = 128.0f;
    public static final float CRAFTING_TIME = 40.0f;
    private final SimpleContainer result = new SimpleContainer(1){

        public void setChanged() {
            super.setChanged();
            DecobenchTileEntity.this.setChanged();
        }
    };
    private final SimpleContainer input = new SimpleContainer(1){

        public void setChanged() {
            super.setChanged();
            DecobenchTileEntity.this.setChanged();
        }
    };
    private ItemStack pendingCrafting = ItemStack.EMPTY;
    private ItemStack currentCrafting = ItemStack.EMPTY;
    private int colorRed = 0;
    private int colorGreen = 0;
    private int colorBlue = 0;
    private int rawMaterial = 0;
    private int timer = 0;
    private int craft = 0;
    private int craftingTimer = 0;
    private boolean isLoading = false;

    public DecobenchTileEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public DecobenchTileEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType)ModuleTileEntities.DECOBENCH.get(), pos, state);
    }

    public static void tick(Level world, BlockPos pos, BlockState state, DecobenchTileEntity be) {
        if (world.isClientSide()) {
            return;
        }
        ++be.timer;
        if (be.timer % 10 == 0) {
            be.timer = 0;
            ItemStack inputStack = be.input.getItem(0);
            if (inputStack.getItem() instanceof DyeItem) {
                Color color = Color.byName(((DyeItem)inputStack.getItem()).getDyeColor().getName(), Color.BLACK);
                if (color != Color.BLACK && (float)(be.colorRed + color.getRed()) <= 256.0f && (float)(be.colorGreen + color.getGreen()) <= 256.0f && (float)(be.colorBlue + color.getBlue()) <= 256.0f) {
                    inputStack.setCount(inputStack.getCount() - 1);
                    be.input.setItem(0, inputStack);
                    be.colorRed += color.getRed();
                    be.colorGreen += color.getGreen();
                    be.colorBlue += color.getBlue();
                }
            } else if (inputStack.getItem() == ModuleItems.RAW_MATERIAL.get() && (float)(be.rawMaterial + 1) <= 128.0f) {
                inputStack.setCount(inputStack.getCount() - 1);
                be.input.setItem(0, inputStack);
                ++be.rawMaterial;
            }
        }
        if (be.currentCrafting == ItemStack.EMPTY && be.pendingCrafting != ItemStack.EMPTY) {
            be.currentCrafting = be.pendingCrafting;
        }
        if (be.craft == 1 && be.currentCrafting != ItemStack.EMPTY && be.currentCrafting.getItem() instanceof DecoBlockItem && be.result.getItem(0).isEmpty()) {
            DecoBlockItem item = (DecoBlockItem)be.currentCrafting.getItem();
            if (item.getRed() <= be.colorRed && item.getRed() >= 0 && item.getGreen() <= be.colorGreen && item.getGreen() >= 0 && item.getBlue() <= be.colorBlue && item.getBlue() >= 0 && item.getMaterial() <= be.rawMaterial) {
                ++be.craftingTimer;
                if ((float)be.craftingTimer >= 40.0f) {
                    be.colorRed -= item.getRed();
                    be.colorGreen -= item.getGreen();
                    be.colorBlue -= item.getBlue();
                    be.rawMaterial -= item.getMaterial();
                    be.craftingTimer = 0;
                    be.craft = 0;
                    be.result.setItem(0, be.currentCrafting.copy());
                    be.currentCrafting = ItemStack.EMPTY;
                    be.setChanged();
                }
            } else {
                be.currentCrafting = ItemStack.EMPTY;
                be.craftingTimer = 0;
                be.craft = 0;
            }
        } else {
            be.currentCrafting = ItemStack.EMPTY;
            be.craftingTimer = 0;
            be.craft = 0;
        }
    }

    protected void loadAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.loadAdditional(nbt, registryLookup);
        this.isLoading = true;
        this.colorRed = nbt.getInt("color_red");
        this.colorGreen = nbt.getInt("color_green");
        this.colorBlue = nbt.getInt("color_blue");
        this.rawMaterial = nbt.getInt("raw_material");
        this.craft = nbt.getInt("craft");
        this.craftingTimer = nbt.getInt("crafting_timer");
        this.currentCrafting = ItemStack.parseOptional((HolderLookup.Provider)registryLookup, (CompoundTag)nbt.getCompound("current_crafting"));
        ItemStack resultStack = ItemStack.parseOptional((HolderLookup.Provider)registryLookup, (CompoundTag)nbt.getCompound("result"));
        ItemStack inputStack = ItemStack.parseOptional((HolderLookup.Provider)registryLookup, (CompoundTag)nbt.getCompound("input"));
        this.result.setItem(0, resultStack);
        this.input.setItem(0, inputStack);
        this.isLoading = false;
    }

    public void setChanged() {
        super.setChanged();
        if (!this.isLoading && this.level != null && !this.level.isClientSide) {
            this.level.blockEntityChanged(this.worldPosition);
            this.level.getChunkAt(this.worldPosition).setUnsaved(true);
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
        }
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    protected void saveAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.saveAdditional(nbt, registryLookup);
        this.saveNBTCustom(nbt, registryLookup);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registryLookup) {
        CompoundTag nbt = super.getUpdateTag(registryLookup);
        this.saveNBTCustom(nbt, registryLookup);
        return nbt;
    }

    private void saveNBTCustom(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        nbt.putInt("color_red", this.colorRed);
        nbt.putInt("color_green", this.colorGreen);
        nbt.putInt("color_blue", this.colorBlue);
        nbt.putInt("raw_material", this.rawMaterial);
        nbt.putInt("craft", this.craft);
        nbt.putInt("crafting_timer", this.craftingTimer);
        if (!this.currentCrafting.isEmpty()) {
            nbt.put("current_crafting", this.currentCrafting.save(registryLookup));
        }
        if (!this.result.getItem(0).isEmpty()) {
            nbt.put("result", this.result.getItem(0).save(registryLookup));
        }
        if (!this.input.getItem(0).isEmpty()) {
            nbt.put("input", this.input.getItem(0).save(registryLookup));
        }
    }

    public int getColorRed() {
        return this.colorRed;
    }

    public int getColorGreen() {
        return this.colorGreen;
    }

    public int getColorBlue() {
        return this.colorBlue;
    }

    public int getRawMaterial() {
        return this.rawMaterial;
    }

    public SimpleContainer getInput() {
        return this.input;
    }

    public SimpleContainer getResult() {
        return this.result;
    }

    public void setResult(ItemStack result) {
        this.result.setItem(0, result);
    }

    public int getCraft() {
        return this.craft;
    }

    public void setCraft(int craft) {
        this.craft = craft;
    }

    public int getCraftingTimer() {
        return this.craftingTimer;
    }

    public void setPendingCrafting(ItemStack pendingCrafting) {
        this.pendingCrafting = pendingCrafting == null ? ItemStack.EMPTY : pendingCrafting;
    }

    private static enum Color {
        WHITE(0, "white", 4, 4, 4),
        GRAY(7, "gray", 2, 2, 2),
        LIGHT_GRAY(8, "light_gray", 1, 1, 1),
        BLACK(15, "black", 0, 0, 0),
        ORANGE(1, "orange", 6, 3, 1),
        MAGENTA(2, "magenta", 6, 0, 6),
        LIGHT_BLUE(3, "light_blue", 1, 3, 6),
        YELLOW(4, "yellow", 6, 6, 0),
        LIME(5, "lime", 1, 6, 0),
        PINK(6, "pink", 6, 1, 3),
        CYAN(9, "cyan", 0, 6, 6),
        PURPLE(10, "purple", 3, 0, 3),
        BROWN(12, "brown", 1, 1, 0),
        BLUE(11, "blue", 0, 0, 12),
        GREEN(13, "green", 0, 12, 0),
        RED(14, "red", 12, 0, 0);

        private final int id;
        private final String name;
        private final int red;
        private final int green;
        private final int blue;

        private Color(int id, String name, int r, int g, int b) {
            this.id = id;
            this.name = name;
            this.red = r;
            this.green = g;
            this.blue = b;
        }

        public static Color byName(String name, Color fallback) {
            for (Color color : Color.values()) {
                if (!color.name.equals(name)) continue;
                return color;
            }
            return fallback;
        }

        public int getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public int getRed() {
            return this.red;
        }

        public int getGreen() {
            return this.green;
        }

        public int getBlue() {
            return this.blue;
        }
    }
}

