/*
 * Decompiled with CFR 0.152.
 */
package com.razznature.decocraft.common.tileentities;

import com.razznature.decocraft.common.JsonContainer;
import com.razznature.decocraft.common.ModuleTileEntities;
import com.razznature.decocraft.common.blocks.DecocraftBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class DecocraftTileEntity
extends BlockEntity {
    private static final String NBT_COUNTER = "counter";
    private static final String NBT_FRAMETIME = "frametime";
    private static final String NBT_CURRENT_FRAME = "currentFrame";
    private static final String NBT_FRAME_TIMER = "frameTimer";
    private static final String NBT_LIT = "lit";
    public final JsonContainer.Entry meta;
    private int counter;
    private int frametime;
    private boolean lit = true;
    private int currentFrame = 0;
    private int frameTimer = 0;

    public DecocraftTileEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type != null ? type : (BlockEntityType)ModuleTileEntities.DECOCRAFT.get(), pos, state);
        if (state.getBlock() instanceof DecocraftBlock) {
            this.meta = ((DecocraftBlock)state.getBlock()).meta;
            this.counter = this.meta != null && this.meta.script != null ? this.meta.script.counter : -1;
            this.frametime = this.meta != null && this.meta.flipbook != null ? this.meta.flipbook.frametime : -1;
        } else {
            this.meta = null;
            this.counter = -1;
            this.frametime = -1;
        }
    }

    public DecocraftTileEntity(BlockEntityType<?> type, BlockPos pos, BlockState state, JsonContainer.Entry meta) {
        super(type, pos, state);
        this.meta = meta;
        this.counter = -1;
        this.frametime = -1;
    }

    public DecocraftTileEntity(JsonContainer.Entry meta) {
        super((BlockEntityType)ModuleTileEntities.DECOCRAFT.get(), BlockPos.ZERO, null);
        if (meta != null) {
            this.meta = meta;
            this.counter = meta.script.counter;
            this.frametime = meta.flipbook.frametime;
        } else {
            this.meta = null;
            this.counter = -1;
            this.frametime = -1;
        }
    }

    public static void tick(Level world, BlockPos pos, BlockState state, DecocraftTileEntity blockEntity) {
        blockEntity.tick();
    }

    private void tick() {
        if (this.counter >= 0) {
            --this.counter;
            if (this.counter == 0) {
                this.counter = this.meta.script.counter;
                DecocraftBlock.script(this.getLevel(), this.getBlockPos(), this.getBlockState(), this.meta.script.trigger);
            }
        }
    }

    protected void loadAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.loadAdditional(nbt, registryLookup);
        if (nbt.contains(NBT_COUNTER)) {
            this.counter = nbt.getInt(NBT_COUNTER);
        }
        if (nbt.contains(NBT_FRAMETIME)) {
            this.frametime = nbt.getInt(NBT_FRAMETIME);
        }
        if (nbt.contains(NBT_CURRENT_FRAME)) {
            this.currentFrame = nbt.getInt(NBT_CURRENT_FRAME);
        }
        if (nbt.contains(NBT_FRAME_TIMER)) {
            this.frameTimer = nbt.getInt(NBT_FRAME_TIMER);
        }
        if (nbt.contains(NBT_LIT)) {
            this.lit = nbt.getBoolean(NBT_LIT);
        }
    }

    protected void saveAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.saveAdditional(nbt, registryLookup);
        nbt.putInt(NBT_COUNTER, this.counter);
        nbt.putInt(NBT_FRAMETIME, this.frametime);
        nbt.putInt(NBT_CURRENT_FRAME, this.currentFrame);
        nbt.putInt(NBT_FRAME_TIMER, this.frameTimer);
        nbt.putBoolean(NBT_LIT, this.lit);
    }

    public int getCurrentFrame() {
        return this.currentFrame;
    }

    public boolean isLit() {
        return this.lit;
    }

    public void setLit(boolean lit) {
        this.lit = lit;
    }

    private void syncToClients() {
        Level level = this.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)level;
            serverWorld.getChunkSource().blockChanged(this.getBlockPos());
        }
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registryLookup) {
        return this.saveWithoutMetadata(registryLookup);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }
}

