/*
 * Decompiled with CFR 0.152.
 */
package com.razz.decocraft_nature.utils.nbt;

import com.razz.decocraft_nature.models.bbmodel.BBModel;
import com.razz.decocraft_nature.models.bbmodel.BBModelParts;
import com.razz.decocraft_nature.utils.nbt.NBTAnimation;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;

public class NBTModel {
    private static final String NBT_ANIMATIONS_PER_NAME_SIZE = "animationsPerName.size";
    private static final String NBT_ANIMATIONS_PER_NAME_KEYS = "animationsPerName.keys[%d]";
    private static final String NBT_ANIMATIONS_PER_NAME_VALUES = "animationsPerName.values[%d]";
    private static final String NBT_NAME = "name";

    public static CompoundTag toNBT(BBModel model) {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128359_(NBT_NAME, model.name);
        int size = model.animationPerName.size();
        nbt.m_128405_(NBT_ANIMATIONS_PER_NAME_SIZE, size);
        int i = 0;
        for (Map.Entry<String, BBModelParts.Animation> entry : model.animationPerName.entrySet()) {
            nbt.m_128359_(String.format(NBT_ANIMATIONS_PER_NAME_KEYS, i), entry.getKey());
            nbt.m_128365_(String.format(NBT_ANIMATIONS_PER_NAME_VALUES, i), (Tag)NBTAnimation.toNBT(entry.getValue()));
            ++i;
        }
        return nbt;
    }

    public static BBModel fromNBT(CompoundTag nbt) {
        BBModel model = new BBModel();
        model.name = nbt.m_128461_(NBT_NAME);
        int size = nbt.m_128451_(NBT_ANIMATIONS_PER_NAME_SIZE);
        model.animationPerName = new HashMap<String, BBModelParts.Animation>();
        for (int i = 0; i < size; ++i) {
            model.animationPerName.put(nbt.m_128461_(String.format(NBT_ANIMATIONS_PER_NAME_KEYS, i)), NBTAnimation.fromNBT(nbt.m_128469_(String.format(NBT_ANIMATIONS_PER_NAME_VALUES, i))));
        }
        return model;
    }
}

