/*
 * Decompiled with CFR 0.152.
 */
package com.razz.decocraft_nature.models.bbmodel;

import com.google.common.base.Charsets;
import com.google.common.collect.Maps;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.razz.decocraft_nature.models.bbmodel.BBModel;
import com.razz.decocraft_nature.models.bbmodel.BBModelLoader;
import com.razz.decocraft_nature.models.bbmodel.BlockbenchModel;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.InputStreamReader;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.GsonHelper;
import net.minecraftforge.client.model.IModelLoader;

public class BlockbenchLoader
implements IModelLoader<BlockbenchModel> {
    public static BlockbenchLoader INSTANCE = new BlockbenchLoader();
    private final Map<BlockbenchSetting, BlockbenchModel> modelCache = Maps.newHashMap();
    private ResourceManager manager = Minecraft.m_91087_().m_91098_();

    public void m_6213_(ResourceManager resourceManager) {
        this.modelCache.clear();
        this.manager = resourceManager;
    }

    public BlockbenchModel read(JsonDeserializationContext deserializationContext, JsonObject modelContents) {
        BlockbenchModel blockbenchModel;
        block10: {
            if (!modelContents.has("model")) {
                throw new RuntimeException("Blockbench Loader requires a 'model' key that points to a valid .BBModel.");
            }
            String modelLocation = modelContents.get("model").getAsString();
            float scale = modelContents.has("scale") ? GsonHelper.m_13915_((JsonObject)modelContents, (String)"scale") : 1.0f;
            boolean flipV = GsonHelper.m_13855_((JsonObject)modelContents, (String)"flip-v", (boolean)false);
            String material = GsonHelper.m_13851_((JsonObject)modelContents, (String)"material", (String)"UNKNOWN");
            BlockbenchSetting settings = new BlockbenchSetting(new ResourceLocation(modelLocation), scale, flipV, material);
            Resource resource = this.manager.m_142591_(settings.modelLocation);
            try {
                InputStreamReader lineStream = new InputStreamReader(resource.m_6679_(), Charsets.UTF_8);
                BufferedReader lineReader = new BufferedReader(lineStream);
                BBModel model = new BBModelLoader().loadModel(lineReader);
                blockbenchModel = new BlockbenchModel(settings, model);
                if (resource == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (resource != null) {
                        try {
                            resource.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (FileNotFoundException e) {
                    throw new RuntimeException("Could not find BBModel", e);
                }
                catch (Exception e) {
                    throw new RuntimeException("Could not read BBModel", e);
                }
            }
            resource.close();
        }
        return blockbenchModel;
    }

    public static class BlockbenchSetting {
        public final ResourceLocation modelLocation;
        public final float scale;
        public final boolean flipV;
        public final String material;

        public BlockbenchSetting(ResourceLocation modelLocation, float scale, boolean flipV, String material) {
            this.modelLocation = modelLocation;
            this.scale = scale;
            this.flipV = flipV;
            this.material = material;
        }
    }
}

