/*
 * Decompiled with CFR 0.152.
 */
package com.razznature.decocraft_nature.client;

import com.razznature.decocraft_nature.client.render.AnimatedRenderer;
import com.razznature.decocraft_nature.common.JsonContainer;
import com.razznature.decocraft_nature.common.ModuleBlocks;
import com.razznature.decocraft_nature.common.ModuleEntities;
import com.razznature.decocraft_nature.common.ModuleTileEntities;
import com.razznature.decocraft_nature.common.blocks.DecoBedBlock;
import com.razznature.decocraft_nature.common.blocks.DecocraftBlock;
import com.razznature.decocraft_nature.models.bbmodel.BBModel;
import com.razznature.decocraft_nature.models.bbmodel.BBModelLoadingPlugin;
import java.util.Map;
import java.util.Objects;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.blockrenderlayer.v1.BlockRenderLayerMap;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientLifecycleEvents;
import net.fabricmc.fabric.api.client.model.loading.v1.ModelLoadingPlugin;
import net.fabricmc.fabric.api.client.rendering.v1.BlockEntityRendererRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.EntityRendererRegistry;
import net.minecraft.class_1921;
import net.minecraft.class_2248;
import net.minecraft.class_6344;

public class ClientEvents
implements ClientModInitializer {
    public void onInitializeClient() {
        System.out.println("=== ClientEvents.onInitializeClient() START ===");
        this.registerModelLoaders();
        this.registerBlockEntityRenderers();
        this.registerEntityRenderers();
        System.out.println("=== ClientEvents.onInitializeClient() END ===");
        ClientLifecycleEvents.CLIENT_STARTED.register(client -> {
            System.out.println("CLIENT_STARTED event - setting up render layers and BB models");
            this.setupRenderLayers();
            this.registerBBModels();
        });
    }

    private void setupRenderLayers() {
        for (Map.Entry<String, class_2248> entry : ModuleBlocks.DECOBLOCKS.entrySet()) {
            if (entry.getValue() instanceof DecocraftBlock) {
                DecocraftBlock block = (DecocraftBlock)entry.getValue();
                if (!Objects.equals(block.meta.type, "animated")) {
                    class_1921 renderer = !block.meta.transparency ? class_1921.method_23581() : class_1921.method_23583();
                    BlockRenderLayerMap.INSTANCE.putBlock((class_2248)block, renderer);
                    continue;
                }
                BlockRenderLayerMap.INSTANCE.putBlock((class_2248)block, class_1921.method_23583());
                continue;
            }
            if (!(entry.getValue() instanceof DecoBedBlock)) continue;
            DecoBedBlock bedBlock = (DecoBedBlock)entry.getValue();
            BlockRenderLayerMap.INSTANCE.putBlock((class_2248)bedBlock, class_1921.method_23581());
        }
    }

    private void registerModelLoaders() {
        ModelLoadingPlugin.register((ModelLoadingPlugin)new BBModelLoadingPlugin());
    }

    private void registerBBModels() {
        System.out.println("=== Starting BBModel registration ===");
        for (Map.Entry<String, class_2248> entry : ModuleBlocks.DECOBLOCKS.entrySet()) {
            String materialName = entry.getKey();
            class_2248 block = entry.getValue();
            if (block instanceof DecocraftBlock) {
                DecocraftBlock decoBlock = (DecocraftBlock)block;
                if (decoBlock.model == null) continue;
                this.registerBBModelForBlock(materialName, decoBlock.model, decoBlock.meta);
                continue;
            }
            if (!(block instanceof DecoBedBlock)) continue;
            DecoBedBlock bedBlock = (DecoBedBlock)block;
            if (bedBlock.model == null) continue;
            this.registerBBModelForBlock(materialName, bedBlock.model, bedBlock.meta);
        }
        System.out.println("=== BBModel registration complete ===");
    }

    private void registerBBModelForBlock(String materialName, BBModel model, JsonContainer.Entry meta) {
        float scale = meta.scale != 0.0f ? meta.scale : 1.0f;
    }

    private void registerBlockEntityRenderers() {
        if (ModuleTileEntities.ANIMATED_TE != null) {
            BlockEntityRendererRegistry.register(ModuleTileEntities.ANIMATED_TE, context -> new AnimatedRenderer(context));
        }
    }

    private void registerEntityRenderers() {
        EntityRendererRegistry.register(ModuleEntities.SEAT, class_6344::new);
    }
}

