/*
 * Decompiled with CFR 0.152.
 */
package com.razznature.decocraft_nature.client;

import com.razznature.decocraft_nature.client.render.AnimatedRenderer;
import com.razznature.decocraft_nature.client.render.DecoPlacementRenderer;
import com.razznature.decocraft_nature.client.screens.DecoStorageScreen;
import com.razznature.decocraft_nature.client.screens.DecobenchScreen;
import com.razznature.decocraft_nature.client.screens.DecomposerScreen;
import com.razznature.decocraft_nature.common.JsonContainer;
import com.razznature.decocraft_nature.common.ModuleBlocks;
import com.razznature.decocraft_nature.common.ModuleScreenHandlers;
import com.razznature.decocraft_nature.common.ModuleTileEntities;
import com.razznature.decocraft_nature.common.blocks.DecoAnimatedBlock;
import com.razznature.decocraft_nature.common.blocks.DecoBedBlock;
import com.razznature.decocraft_nature.common.blocks.DecocraftBlock;
import com.razznature.decocraft_nature.models.bbmodel.BBModel;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.minecraft.class_2248;
import net.minecraft.class_3929;
import net.minecraft.class_5616;

@Environment(value=EnvType.CLIENT)
public class ClientHandler {
    private static boolean bbModelsRegistered = false;

    public static void setup() {
        if (!bbModelsRegistered) {
            ClientHandler.registerBBModels();
            ClientHandler.registerRenderers();
            ClientHandler.registerScreens();
            ClientHandler.registerPlacementPreview();
            bbModelsRegistered = true;
        }
    }

    private static void registerPlacementPreview() {
        WorldRenderEvents.BEFORE_BLOCK_OUTLINE.register((context, hitResult) -> {
            DecoPlacementRenderer.renderPlacementPreview(context);
            return true;
        });
    }

    private static void registerRenderers() {
        class_5616.method_32144(ModuleTileEntities.ANIMATED_TE, AnimatedRenderer::new);
    }

    private static void registerScreens() {
        class_3929.method_17542(ModuleScreenHandlers.DECO_STORAGE, DecoStorageScreen::new);
        class_3929.method_17542(ModuleScreenHandlers.DECOBENCH, DecobenchScreen::new);
        class_3929.method_17542(ModuleScreenHandlers.DECOMPOSER, DecomposerScreen::new);
    }

    private static void registerBBModels() {
        for (Map.Entry<String, class_2248> entry : ModuleBlocks.DECOBLOCKS.entrySet()) {
            String materialName = entry.getKey();
            class_2248 block = entry.getValue();
            if (block instanceof DecocraftBlock) {
                DecocraftBlock decoBlock = (DecocraftBlock)block;
                if (decoBlock.model == null) continue;
                ClientHandler.registerBBModelForBlock(materialName, decoBlock.model, decoBlock.meta);
                continue;
            }
            if (block instanceof DecoAnimatedBlock) {
                DecoAnimatedBlock animatedBlock = (DecoAnimatedBlock)block;
                if (animatedBlock.model == null) continue;
                ClientHandler.registerBBModelForBlock(materialName, animatedBlock.model, animatedBlock.meta);
                continue;
            }
            if (!(block instanceof DecoBedBlock)) continue;
            DecoBedBlock bedBlock = (DecoBedBlock)block;
            if (bedBlock.model == null) continue;
            ClientHandler.registerBBModelForBlock(materialName, bedBlock.model, bedBlock.meta);
        }
    }

    private static void registerBBModelForBlock(String materialName, BBModel model, JsonContainer.Entry meta) {
        try {
            float f = meta.scale != 0.0f ? meta.scale : 1.0f;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

