/*
 * Decompiled with CFR 0.152.
 */
package com.razznature.decocraft_nature.common.tileentities;

import com.razznature.decocraft_nature.common.ModuleItems;
import com.razznature.decocraft_nature.common.ModuleTileEntities;
import com.razznature.decocraft_nature.common.items.DecoBlockItem;
import com.razznature.mods.Mods;
import java.util.Map;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.class_7924;

public class DecomposerTileEntity
extends class_2586 {
    public static final float CRAFTING_TIME = 40.0f;
    public static final class_1799 DIRT = new class_1799((class_1935)class_1802.field_8831);
    public static final class_1799 COBBLESTONE = new class_1799((class_1935)class_1802.field_20412);
    public static final class_1799 BIO_MATERIAL = new class_1799((class_1935)ModuleItems.BIO_MATERIAL);
    public static final float FUEL_MAX = 16000.0f;
    private final class_2371<class_1799> inventory = class_2371.method_10213((int)3, (Object)class_1799.field_8037);
    private static final int INPUT_SLOT = 0;
    private static final int RESULT_SLOT = 1;
    private static final int FUEL_SLOT = 2;
    private int currentFuel = 0;
    private long fuelTimer = 0L;
    private int craft = 0;
    private int craftingTimer = 0;

    public DecomposerTileEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    public DecomposerTileEntity(class_2338 pos, class_2680 state) {
        this(ModuleTileEntities.DECOMPOSER, pos, state);
    }

    public static void tick(class_1937 world, class_2338 pos, class_2680 state, DecomposerTileEntity blockEntity) {
        DecomposerTileEntity be = blockEntity;
        ++be.fuelTimer;
        if (!((class_1799)be.inventory.get(2)).method_7960() && be.fuelTimer > 10L) {
            class_1799 fuelStack = (class_1799)be.inventory.get(2);
            int burnTime = 0;
            if (fuelStack.method_7909() == class_1802.field_20412) {
                burnTime = 300;
            } else if (fuelStack.method_7909() == class_1802.field_8713 || fuelStack.method_7909() == class_1802.field_8665) {
                burnTime = 1600;
            } else if (fuelStack.method_31573(class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)class_2960.method_60655((String)"minecraft", (String)"logs"))) || fuelStack.method_31573(class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)class_2960.method_60655((String)"minecraft", (String)"planks")))) {
                burnTime = 300;
            } else if (fuelStack.method_31573(class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)class_2960.method_60655((String)"minecraft", (String)"villager_plantable_seeds"))) || fuelStack.method_31573(class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)class_2960.method_60655((String)"minecraft", (String)"chicken_food"))) || fuelStack.method_31573(class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)class_2960.method_60655((String)"minecraft", (String)"parrot_food"))) || fuelStack.method_31573(class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)class_2960.method_60655((String)"c", (String)"seeds")))) {
                burnTime = 300;
            }
            if (burnTime > 0 && ((float)(be.currentFuel + burnTime) <= 16000.0f || be.currentFuel == 0)) {
                class_1799 container = fuelStack.getRecipeRemainder();
                if (!container.method_7960()) {
                    be.inventory.set(2, (Object)container);
                } else {
                    fuelStack.method_7934(1);
                    be.inventory.set(2, (Object)fuelStack);
                }
                be.fuelTimer = 0L;
                be.currentFuel += burnTime;
            }
        }
        if (be.craft == 1 && DecomposerTileEntity.canAddItem(be.inventory, 1, BIO_MATERIAL) && be.inventory.get(0) != class_1799.field_8037) {
            boolean found = ((class_1799)be.inventory.get(0)).method_7909() instanceof DecoBlockItem;
            if (!found) {
                class_1799 inputStack = (class_1799)be.inventory.get(0);
                if (inputStack.method_7909().toString().toLowerCase().contains("seeds") || inputStack.method_7909() == class_1802.field_8317 || inputStack.method_7909() == class_1802.field_8309 || inputStack.method_7909() == class_1802.field_46250 || inputStack.method_7909() == class_1802.field_46249 || inputStack.method_7909() == class_1802.field_8567 || inputStack.method_7909() == class_1802.field_8179 || inputStack.method_7909() == class_1802.field_8116 || inputStack.method_7909() == class_1802.field_17532 || inputStack.method_7909() == class_1802.field_16998 || inputStack.method_7909() == class_1802.field_28659) {
                    found = true;
                } else {
                    for (Map.Entry<String, Integer> entry : Mods.DECOMPOSER_INGREDIENTS.entrySet()) {
                        if (entry.getKey().startsWith("#")) {
                            class_6862 tag = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)class_2960.method_60654((String)entry.getKey().substring(1)));
                            if (!inputStack.method_31573(tag) || inputStack.method_7947() < entry.getValue()) continue;
                            found = true;
                            break;
                        }
                        class_1792 targetItem = (class_1792)class_7923.field_41178.method_10223(class_2960.method_60654((String)entry.getKey()));
                        if (inputStack.method_7909() != targetItem || inputStack.method_7947() < entry.getValue()) continue;
                        found = true;
                        break;
                    }
                }
            }
            if (!found) {
                return;
            }
            if (((class_1799)be.inventory.get(0)).method_7909() instanceof DecoBlockItem && ((DecoBlockItem)((class_1799)be.inventory.get(0)).method_7909()).getMaterial() + ((class_1799)be.inventory.get(1)).method_7947() > BIO_MATERIAL.method_7914()) {
                return;
            }
            if (be.currentFuel > 0) {
                ++be.craftingTimer;
                if ((float)be.craftingTimer >= 40.0f) {
                    be.craftingTimer = 0;
                    if (((class_1799)be.inventory.get(0)).method_7909() instanceof DecoBlockItem) {
                        class_1799 stack = BIO_MATERIAL.method_7972();
                        stack.method_7939(((DecoBlockItem)((class_1799)be.inventory.get(0)).method_7909()).getMaterial());
                        ((class_1799)be.inventory.get(0)).method_7934(1);
                        DecomposerTileEntity.addItem(be.inventory, 1, stack);
                    } else {
                        class_1799 inputStack = (class_1799)be.inventory.get(0);
                        if (inputStack.method_7909().toString().toLowerCase().contains("seeds") || inputStack.method_7909() == class_1802.field_8317 || inputStack.method_7909() == class_1802.field_8309 || inputStack.method_7909() == class_1802.field_46250 || inputStack.method_7909() == class_1802.field_46249 || inputStack.method_7909() == class_1802.field_8567 || inputStack.method_7909() == class_1802.field_8179 || inputStack.method_7909() == class_1802.field_8116 || inputStack.method_7909() == class_1802.field_17532 || inputStack.method_7909() == class_1802.field_16998 || inputStack.method_7909() == class_1802.field_28659) {
                            inputStack.method_7934(1);
                            DecomposerTileEntity.addItem(be.inventory, 1, BIO_MATERIAL.method_7972());
                        } else {
                            for (Map.Entry<String, Integer> entry : Mods.DECOMPOSER_INGREDIENTS.entrySet()) {
                                boolean matches = false;
                                if (entry.getKey().startsWith("#")) {
                                    class_6862 tag = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)class_2960.method_60654((String)entry.getKey().substring(1)));
                                    matches = inputStack.method_31573(tag);
                                } else {
                                    class_1792 targetItem = (class_1792)class_7923.field_41178.method_10223(class_2960.method_60654((String)entry.getKey()));
                                    boolean bl = matches = inputStack.method_7909() == targetItem;
                                }
                                if (!matches || inputStack.method_7947() < entry.getValue()) continue;
                                inputStack.method_7934(entry.getValue().intValue());
                                DecomposerTileEntity.addItem(be.inventory, 1, BIO_MATERIAL.method_7972());
                                break;
                            }
                        }
                    }
                    be.method_5431();
                    world.method_8413(pos, state, state, 3);
                }
                be.currentFuel -= 10;
                be.currentFuel = class_3532.method_15340((int)be.currentFuel, (int)0, (int)Integer.MAX_VALUE);
                be.method_5431();
            }
        } else {
            be.craftingTimer = 0;
            be.craft = 0;
        }
    }

    protected void method_11014(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11014(nbt, registryLookup);
        this.craft = nbt.method_10550("craft");
        this.craftingTimer = nbt.method_10550("crafting_timer");
        this.currentFuel = nbt.method_10550("current_fuel");
        class_1262.method_5429((class_2487)nbt, this.inventory, (class_7225.class_7874)registryLookup);
    }

    protected void method_11007(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11007(nbt, registryLookup);
        this.saveNBTCustom(nbt, registryLookup);
    }

    public class_2487 method_16887(class_7225.class_7874 registryLookup) {
        class_2487 nbt = super.method_16887(registryLookup);
        this.saveNBTCustom(nbt, registryLookup);
        return nbt;
    }

    private void saveNBTCustom(class_2487 nbt, class_7225.class_7874 registryLookup) {
        nbt.method_10569("craft", this.craft);
        nbt.method_10569("crafting_timer", this.craftingTimer);
        nbt.method_10569("current_fuel", this.currentFuel);
        class_1262.method_5426((class_2487)nbt, this.inventory, (class_7225.class_7874)registryLookup);
    }

    public class_1799 getInputStack() {
        return (class_1799)this.inventory.get(0);
    }

    public class_1799 getResultStack() {
        return (class_1799)this.inventory.get(1);
    }

    public class_1799 getFuelStack() {
        return (class_1799)this.inventory.get(2);
    }

    public void setInputStack(class_1799 stack) {
        this.inventory.set(0, (Object)stack);
        this.method_5431();
    }

    public void setResultStack(class_1799 stack) {
        this.inventory.set(1, (Object)stack);
        this.method_5431();
    }

    public void setFuelStack(class_1799 stack) {
        this.inventory.set(2, (Object)stack);
        this.method_5431();
    }

    public class_1263 getInput() {
        return new SlotInventoryWrapper(this.inventory, 0, this);
    }

    public class_1263 getResult() {
        return new SlotInventoryWrapper(this.inventory, 1, this);
    }

    public class_1263 getFuel() {
        return new SlotInventoryWrapper(this.inventory, 2, this);
    }

    public int getCraft() {
        return this.craft;
    }

    public void setCraft(int craft) {
        this.craft = craft;
    }

    public int getCraftingTimer() {
        return this.craftingTimer;
    }

    public int getCurrentFuel() {
        return this.currentFuel;
    }

    private static boolean canAddItem(class_2371<class_1799> inventory, int slot, class_1799 stack) {
        class_1799 existing = (class_1799)inventory.get(slot);
        if (existing.method_7960()) {
            return true;
        }
        return class_1799.method_31577((class_1799)existing, (class_1799)stack) && existing.method_7947() + stack.method_7947() <= existing.method_7914();
    }

    private static void addItem(class_2371<class_1799> inventory, int slot, class_1799 stack) {
        class_1799 existing = (class_1799)inventory.get(slot);
        if (existing.method_7960()) {
            inventory.set(slot, (Object)stack);
        } else if (class_1799.method_31577((class_1799)existing, (class_1799)stack)) {
            existing.method_7933(stack.method_7947());
        }
    }

    private static class SlotInventoryWrapper
    implements class_1263 {
        private final class_2371<class_1799> inventory;
        private final int slot;
        private final DecomposerTileEntity tileEntity;

        public SlotInventoryWrapper(class_2371<class_1799> inventory, int slot, DecomposerTileEntity tileEntity) {
            this.inventory = inventory;
            this.slot = slot;
            this.tileEntity = tileEntity;
        }

        public int method_5439() {
            return 1;
        }

        public boolean method_5442() {
            return ((class_1799)this.inventory.get(this.slot)).method_7960();
        }

        public class_1799 method_5438(int index) {
            return index == 0 ? (class_1799)this.inventory.get(this.slot) : class_1799.field_8037;
        }

        public class_1799 method_5434(int index, int count) {
            if (index != 0) {
                return class_1799.field_8037;
            }
            class_1799 stack = (class_1799)this.inventory.get(this.slot);
            if (stack.method_7960()) {
                return class_1799.field_8037;
            }
            class_1799 result = stack.method_7971(count);
            if (stack.method_7960()) {
                this.inventory.set(this.slot, (Object)class_1799.field_8037);
            }
            this.tileEntity.method_5431();
            return result;
        }

        public class_1799 method_5441(int index) {
            if (index != 0) {
                return class_1799.field_8037;
            }
            class_1799 result = (class_1799)this.inventory.get(this.slot);
            this.inventory.set(this.slot, (Object)class_1799.field_8037);
            this.tileEntity.method_5431();
            return result;
        }

        public void method_5447(int index, class_1799 stack) {
            if (index == 0) {
                this.inventory.set(this.slot, (Object)stack);
                this.tileEntity.method_5431();
            }
        }

        public void method_5431() {
            this.tileEntity.method_5431();
        }

        public boolean method_5443(class_1657 player) {
            return true;
        }

        public void method_5448() {
            this.inventory.set(this.slot, (Object)class_1799.field_8037);
            this.tileEntity.method_5431();
        }
    }
}

