/*
 * Decompiled with CFR 0.152.
 */
package net.ayoubmrz.battletotemmod.block.custom;

import com.mojang.serialization.MapCodec;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.ayoubmrz.battletotemmod.block.ModBlocks;
import net.ayoubmrz.battletotemmod.block.entity.BattleTotemBlockEntity;
import net.ayoubmrz.battletotemmod.block.entity.ModBlockEntities;
import net.ayoubmrz.battletotemmod.event.SpawnMobs;
import net.minecraft.class_1269;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2383;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2746;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5558;
import org.jetbrains.annotations.Nullable;

public class BattleTotemBlock
extends class_2383
implements class_2343 {
    public static final class_2746 USED = class_2746.method_11825((String)"used");
    public static final class_2758 STAGE = class_2758.method_11867((String)"stage", (int)0, (int)3);
    public static final MapCodec<BattleTotemBlock> CODEC = BattleTotemBlock.method_54094(BattleTotemBlock::new);
    private static final class_265 SHAPE = class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);

    public BattleTotemBlock(class_4970.class_2251 settings) {
        super(settings);
        this.method_9590((class_2680)((class_2680)((class_2680)this.field_10647.method_11664()).method_11657((class_2769)USED, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)STAGE, (Comparable)Integer.valueOf(0)));
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{field_11177, USED, STAGE});
    }

    public class_1269 method_55766(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_3965 hit) {
        if (!((Boolean)state.method_11654((class_2769)USED)).booleanValue() && this.isTotem(world, pos)) {
            class_2338 otherPos;
            class_2586 otherBlockEntity;
            world.method_43128(null, (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), class_3417.field_23116, class_3419.field_15245, 1.0f, 1.6f);
            world.method_43128(null, (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), class_3417.field_23118, class_3419.field_15245, 1.0f, 1.6f);
            ArrayList<UUID> mobsList = new ArrayList<UUID>();
            SpawnMobs.spawnMobs(world, pos, mobsList);
            class_2586 blockEntity = world.method_8321(pos);
            if (blockEntity instanceof BattleTotemBlockEntity) {
                BattleTotemBlockEntity totemEntity = (BattleTotemBlockEntity)blockEntity;
                totemEntity.addSpawnedMobs(mobsList);
                totemEntity.setInitialMobCount(mobsList.size());
            }
            if ((otherBlockEntity = world.method_8321(otherPos = state.method_27852(ModBlocks.BATTLE_TOTEM_TOP) ? pos.method_10074() : pos.method_10084())) instanceof BattleTotemBlockEntity) {
                BattleTotemBlockEntity otherTotemEntity = (BattleTotemBlockEntity)otherBlockEntity;
                otherTotemEntity.addSpawnedMobs(mobsList);
                otherTotemEntity.setInitialMobCount(mobsList.size());
            }
            if (state.method_27852(ModBlocks.BATTLE_TOTEM_TOP)) {
                world.method_8501(pos, (class_2680)state.method_11657((class_2769)USED, (Comparable)Boolean.valueOf(true)));
                world.method_8501(pos.method_10074(), (class_2680)world.method_8320(pos.method_10074()).method_11657((class_2769)USED, (Comparable)Boolean.valueOf(true)));
            } else if (state.method_27852(ModBlocks.BATTLE_TOTEM_BOTTOM)) {
                world.method_8501(pos, (class_2680)state.method_11657((class_2769)USED, (Comparable)Boolean.valueOf(true)));
                world.method_8501(pos.method_10084(), (class_2680)world.method_8320(pos.method_10084()).method_11657((class_2769)USED, (Comparable)Boolean.valueOf(true)));
            }
            return class_1269.field_5812;
        }
        this.giveMobsGlowEffect(world, pos);
        return class_1269.field_5811;
    }

    private boolean isTotem(class_1937 world, class_2338 pos) {
        return world.method_8320(pos).method_27852(ModBlocks.BATTLE_TOTEM_TOP) ? world.method_8320(pos.method_10074()).method_27852(ModBlocks.BATTLE_TOTEM_BOTTOM) : world.method_8320(pos).method_27852(ModBlocks.BATTLE_TOTEM_BOTTOM) && world.method_8320(pos.method_10084()).method_27852(ModBlocks.BATTLE_TOTEM_TOP);
    }

    private void giveMobsGlowEffect(class_1937 world, class_2338 pos) {
        class_2586 blockEntity = world.method_8321(pos);
        if (blockEntity instanceof BattleTotemBlockEntity) {
            BattleTotemBlockEntity totemEntity = (BattleTotemBlockEntity)blockEntity;
            List<UUID> mobsList = totemEntity.getSpawnedMobs();
            if (world instanceof class_3218) {
                class_3218 serverWorld = (class_3218)world;
                for (UUID mobUUID : mobsList) {
                    class_1309 livingEntity;
                    class_1297 entity = serverWorld.method_66347(mobUUID);
                    if (!(entity instanceof class_1309) || !(livingEntity = (class_1309)entity).method_5805()) continue;
                    livingEntity.method_6092(new class_1293(class_1294.field_5912, 200, 0));
                }
            }
        }
    }

    public void updateStage(class_1937 world, class_2338 pos, int remainingMobs, int initialMobs) {
        if (initialMobs <= 0) {
            return;
        }
        class_2680 state = world.method_8320(pos);
        if (!state.method_27852((class_2248)this)) {
            return;
        }
        float ratio = (float)remainingMobs / (float)initialMobs;
        int newStage = remainingMobs == 3 ? 0 : (remainingMobs == 2 ? 1 : (remainingMobs == 1 ? 2 : 3));
        if ((Integer)state.method_11654((class_2769)STAGE) != newStage) {
            world.method_8652(pos, (class_2680)state.method_11657((class_2769)STAGE, (Comparable)Integer.valueOf(newStage)), 3);
            world.method_43128(null, (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), class_3417.field_43154, class_3419.field_15245, 3.0f, 0.6f + (float)newStage / 10.0f);
            class_2338 otherPos = state.method_27852(ModBlocks.BATTLE_TOTEM_TOP) ? pos.method_10074() : pos.method_10084();
            class_2680 otherState = world.method_8320(otherPos);
            if ((otherState.method_27852(ModBlocks.BATTLE_TOTEM_TOP) || otherState.method_27852(ModBlocks.BATTLE_TOTEM_BOTTOM)) && (Integer)otherState.method_11654((class_2769)STAGE) != newStage) {
                world.method_8652(otherPos, (class_2680)otherState.method_11657((class_2769)STAGE, (Comparable)Integer.valueOf(newStage)), 3);
            }
        }
    }

    public void method_9567(class_1937 world, class_2338 pos, class_2680 state, @Nullable class_1309 placer, class_1799 itemStack) {
        world.method_8501(pos.method_10084(), ModBlocks.BATTLE_TOTEM_TOP.method_9564());
        world.method_8501(pos, ModBlocks.BATTLE_TOTEM_BOTTOM.method_9564());
    }

    public class_2680 method_9576(class_1937 world, class_2338 pos, class_2680 state, class_1657 player) {
        if (state.method_27852(ModBlocks.BATTLE_TOTEM_TOP)) {
            world.method_8501(pos.method_10074(), class_2246.field_10124.method_9564());
        } else if (state.method_27852(ModBlocks.BATTLE_TOTEM_BOTTOM)) {
            world.method_8501(pos.method_10084(), class_2246.field_10124.method_9564());
        }
        return super.method_9576(world, pos, state, player);
    }

    protected boolean method_9558(class_2680 state, class_4538 world, class_2338 pos) {
        class_2680 aboveState = world.method_8320(pos.method_10084());
        if (!(aboveState.method_26215() || aboveState.method_27852(class_2246.field_10382) || aboveState.method_27852(class_2246.field_10164))) {
            return false;
        }
        return super.method_9558(state, world, pos);
    }

    protected class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return SHAPE;
    }

    protected MapCodec<? extends class_2383> method_53969() {
        return CODEC;
    }

    @Nullable
    public class_2680 method_9605(class_1750 ctx) {
        return (class_2680)this.method_9564().method_11657((class_2769)field_11177, (Comparable)ctx.method_8042().method_10153());
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new BattleTotemBlockEntity(pos, state);
    }

    @Nullable
    public <T extends class_2586> class_5558<T> method_31645(class_1937 world, class_2680 state, class_2591<T> type) {
        return BattleTotemBlock.validateTicker(type, ModBlockEntities.BATTLE_TOTEM, BattleTotemBlockEntity::tick);
    }

    @Nullable
    protected static <E extends class_2586, A extends class_2586> class_5558<A> validateTicker(class_2591<A> givenType, class_2591<E> expectedType, class_5558<? super E> ticker) {
        return expectedType == givenType ? ticker : null;
    }
}

