/*
 * Decompiled with CFR 0.152.
 */
package net.ayoubmrz.battletotemmod.event;

import java.util.List;
import java.util.Random;
import java.util.UUID;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1576;
import net.minecraft.class_1604;
import net.minecraft.class_1613;
import net.minecraft.class_1627;
import net.minecraft.class_1641;
import net.minecraft.class_1642;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1887;
import net.minecraft.class_1893;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_3218;
import net.minecraft.class_5455;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7924;

public class SpawnMobs {
    public static void spawnMobs(class_1937 world, class_2338 pos, List<UUID> mobsList) {
        String[] entityTypes = new String[]{"zombie", "skeleton", "zombie_villager", "husk", "stray", "pillager"};
        Random random = new Random();
        String chosenEntity = entityTypes[random.nextInt(entityTypes.length)];
        int[][] offsets = new int[][]{{2, 2}, {-2, -2}, {-2, 2}};
        for (int i = 0; i < 3; ++i) {
            class_1308 entity = SpawnMobs.createMobByType(chosenEntity, world);
            if (entity == null) continue;
            entity.method_6033(85.0f);
            int x = pos.method_10263() + offsets[i][0];
            int y = pos.method_10264();
            int z = pos.method_10260() + offsets[i][1];
            int yPlus = 1;
            while (!world.method_8320(new class_2338(x, y + yPlus, z)).method_27852(class_2246.field_10124) && ++yPlus <= 50) {
            }
            entity.method_5814((double)x, (double)(y + yPlus), (double)z);
            class_5455 registryLookup = world.method_30349();
            class_7225.class_7226 enchantmentRegistry = registryLookup.method_46762(class_7924.field_41265);
            SpawnMobs.equipMob(entity, (class_7225<class_1887>)enchantmentRegistry, chosenEntity);
            if (SpawnMobs.effectAmplifier(world, pos) == 1) {
                entity.method_6092(new class_1293(class_1294.field_5910, -1, 1));
            } else if (SpawnMobs.effectAmplifier(world, pos) == 2) {
                entity.method_6092(new class_1293(class_1294.field_5910, -1, 2));
            }
            world.method_8649((class_1297)entity);
            mobsList.add(entity.method_5667());
            for (int j = 0; j < 20; ++j) {
                if (world.field_9236) continue;
                ((class_3218)world).method_14199((class_2394)class_2398.field_38908, (double)(pos.method_10263() + offsets[i][0]), (double)(pos.method_10264() + 1), (double)(pos.method_10260() + offsets[i][1]), 10, 0.0, 0.0, 0.0, 0.1);
            }
        }
    }

    private static int effectAmplifier(class_1937 world, class_2338 pos) {
        class_1657 closestPlayer = world.method_18459((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), 50.0, false);
        if (closestPlayer == null) {
            return 0;
        }
        class_1799 helmet = closestPlayer.method_31548().method_7372(3);
        class_1799 chestplate = closestPlayer.method_31548().method_7372(2);
        class_1799 leggings = closestPlayer.method_31548().method_7372(1);
        class_1799 boots = closestPlayer.method_31548().method_7372(0);
        if (helmet.method_7909() == class_1802.field_8805 && chestplate.method_7909() == class_1802.field_8058 && leggings.method_7909() == class_1802.field_8348 && boots.method_7909() == class_1802.field_8285) {
            System.out.println(1);
            return 1;
        }
        if (helmet.method_7909() == class_1802.field_22027 && chestplate.method_7909() == class_1802.field_22028 && leggings.method_7909() == class_1802.field_22029 && boots.method_7909() == class_1802.field_22030) {
            System.out.println(2);
            return 2;
        }
        System.out.println(0);
        return 0;
    }

    private static class_1308 createMobByType(String entityType, class_1937 world) {
        switch (entityType.toLowerCase()) {
            case "zombie": {
                return new class_1642(class_1299.field_6051, world);
            }
            case "skeleton": {
                return new class_1613(class_1299.field_6137, world);
            }
            case "husk": {
                return new class_1576(class_1299.field_6071, world);
            }
            case "stray": {
                return new class_1627(class_1299.field_6098, world);
            }
            case "zombie_villager": {
                return new class_1641(class_1299.field_6054, world);
            }
            case "pillager": {
                return new class_1604(class_1299.field_6105, world);
            }
        }
        return new class_1642(class_1299.field_6051, world);
    }

    private static void equipMob(class_1308 entity, class_7225<class_1887> enchantmentRegistry, String mobType) {
        class_1799 helmet = new class_1799((class_1935)class_1802.field_22027);
        class_1799 chestplate = new class_1799((class_1935)class_1802.field_22028);
        class_1799 leggings = new class_1799((class_1935)class_1802.field_22029);
        class_1799 boots = new class_1799((class_1935)class_1802.field_22030);
        helmet.method_7978((class_6880)enchantmentRegistry.method_46747(class_1893.field_9111), 4);
        helmet.method_7978((class_6880)enchantmentRegistry.method_46747(class_1893.field_9119), 3);
        chestplate.method_7978((class_6880)enchantmentRegistry.method_46747(class_1893.field_9111), 4);
        chestplate.method_7978((class_6880)enchantmentRegistry.method_46747(class_1893.field_9097), 3);
        chestplate.method_7978((class_6880)enchantmentRegistry.method_46747(class_1893.field_9119), 3);
        leggings.method_7978((class_6880)enchantmentRegistry.method_46747(class_1893.field_9111), 4);
        leggings.method_7978((class_6880)enchantmentRegistry.method_46747(class_1893.field_9119), 3);
        boots.method_7978((class_6880)enchantmentRegistry.method_46747(class_1893.field_9111), 4);
        boots.method_7978((class_6880)enchantmentRegistry.method_46747(class_1893.field_9129), 4);
        boots.method_7978((class_6880)enchantmentRegistry.method_46747(class_1893.field_9119), 3);
        class_1799 weapon = SpawnMobs.getWeaponForMob(mobType, enchantmentRegistry);
        entity.method_5673(class_1304.field_6169, helmet);
        entity.method_5673(class_1304.field_6174, chestplate);
        entity.method_5673(class_1304.field_6172, leggings);
        entity.method_5673(class_1304.field_6166, boots);
        entity.method_5673(class_1304.field_6173, weapon);
        entity.method_5946(class_1304.field_6169, 0.0f);
        entity.method_5946(class_1304.field_6174, 0.0f);
        entity.method_5946(class_1304.field_6172, 0.0f);
        entity.method_5946(class_1304.field_6166, 0.0f);
        entity.method_5946(class_1304.field_6173, 0.0f);
    }

    private static class_1799 getWeaponForMob(String mobType, class_7225<class_1887> enchantmentRegistry) {
        class_1799 weapon;
        switch (mobType.toLowerCase()) {
            case "skeleton": 
            case "stray": {
                weapon = new class_1799((class_1935)class_1802.field_8102);
                weapon.method_7978((class_6880)enchantmentRegistry.method_46747(class_1893.field_9103), 5);
                weapon.method_7978((class_6880)enchantmentRegistry.method_46747(class_1893.field_9116), 2);
                weapon.method_7978((class_6880)enchantmentRegistry.method_46747(class_1893.field_9119), 3);
                weapon.method_7978((class_6880)enchantmentRegistry.method_46747(class_1893.field_9125), 1);
                break;
            }
            case "pillager": {
                weapon = new class_1799((class_1935)class_1802.field_8399);
                weapon.method_7978((class_6880)enchantmentRegistry.method_46747(class_1893.field_9132), 4);
                weapon.method_7978((class_6880)enchantmentRegistry.method_46747(class_1893.field_9098), 3);
                weapon.method_7978((class_6880)enchantmentRegistry.method_46747(class_1893.field_9119), 3);
                break;
            }
            default: {
                weapon = new class_1799((class_1935)class_1802.field_22022);
                weapon.method_7978((class_6880)enchantmentRegistry.method_46747(class_1893.field_9118), 5);
                weapon.method_7978((class_6880)enchantmentRegistry.method_46747(class_1893.field_9121), 2);
                weapon.method_7978((class_6880)enchantmentRegistry.method_46747(class_1893.field_9119), 3);
            }
        }
        return weapon;
    }
}

