/*
 * Decompiled with CFR 0.152.
 */
package io.github.InsiderAnh.xPlayerKits.commands;

import io.github.InsiderAnh.xPlayerKits.PlayerKits;
import io.github.InsiderAnh.xPlayerKits.commands.StellarArgument;
import io.github.InsiderAnh.xPlayerKits.commands.StellarCompleter;
import io.github.InsiderAnh.xPlayerKits.commands.arguments.ClaimArgument;
import io.github.InsiderAnh.xPlayerKits.commands.arguments.DeleteArgument;
import io.github.InsiderAnh.xPlayerKits.commands.arguments.EditorArgument;
import io.github.InsiderAnh.xPlayerKits.commands.arguments.GiveArgument;
import io.github.InsiderAnh.xPlayerKits.commands.arguments.KitsArgument;
import io.github.InsiderAnh.xPlayerKits.commands.arguments.KitsOpenArgument;
import io.github.InsiderAnh.xPlayerKits.commands.arguments.MigrateArgument;
import io.github.InsiderAnh.xPlayerKits.commands.arguments.MigrateKitsArgument;
import io.github.InsiderAnh.xPlayerKits.commands.arguments.PreviewArgument;
import io.github.InsiderAnh.xPlayerKits.commands.arguments.ReloadArgument;
import io.github.InsiderAnh.xPlayerKits.commands.arguments.ResetAllArgument;
import io.github.InsiderAnh.xPlayerKits.commands.arguments.ResetArgument;
import io.github.InsiderAnh.xPlayerKits.commands.completers.DeleteCompleter;
import io.github.InsiderAnh.xPlayerKits.commands.completers.GiveCompleter;
import io.github.InsiderAnh.xPlayerKits.commands.completers.KitsOpenCompleter;
import io.github.InsiderAnh.xPlayerKits.commands.completers.MigrateCompleter;
import io.github.InsiderAnh.xPlayerKits.commands.completers.MigrateKitsCompleter;
import io.github.InsiderAnh.xPlayerKits.commands.completers.PreviewCompleter;
import io.github.InsiderAnh.xPlayerKits.commands.completers.ResetAllCompleter;
import io.github.InsiderAnh.xPlayerKits.data.CountdownPlayer;
import io.github.InsiderAnh.xPlayerKits.data.PlayerKitData;
import io.github.InsiderAnh.xPlayerKits.kits.Kit;
import io.github.InsiderAnh.xPlayerKits.menus.KitsMenu;
import io.github.InsiderAnh.xPlayerKits.utils.XPKUtils;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabExecutor;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XKitsCommands
implements TabExecutor {
    private final PlayerKits playerKits = PlayerKits.getInstance();
    private final HashMap<String, StellarArgument> arguments = new HashMap();
    private final HashMap<String, StellarCompleter> completes = new HashMap();

    public XKitsCommands() {
        this.arguments.put("editor", new EditorArgument());
        this.arguments.put("give", new GiveArgument());
        this.arguments.put("delete", new DeleteArgument());
        this.arguments.put("reset", new ResetArgument());
        this.arguments.put("resetall", new ResetAllArgument());
        this.arguments.put("preview", new PreviewArgument());
        this.arguments.put("migrate", new MigrateArgument());
        this.arguments.put("migratekits", new MigrateKitsArgument());
        this.arguments.put("reload", new ReloadArgument());
        this.arguments.put("kits", new KitsArgument());
        this.arguments.put("claim", new ClaimArgument());
        this.arguments.put("open", new KitsOpenArgument());
        this.completes.put("preview", new PreviewCompleter());
        this.completes.put("give", new GiveCompleter());
        this.completes.put("delete", new DeleteCompleter());
        this.completes.put("resetall", new ResetAllCompleter());
        this.completes.put("migrate", new MigrateCompleter());
        this.completes.put("migratekits", new MigrateKitsCompleter());
        this.completes.put("open", new KitsOpenCompleter());
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        if (sender instanceof Player) {
            Player player = (Player)sender;
            CountdownPlayer countdownPlayer = CountdownPlayer.getCountdownPlayer(player);
            if (countdownPlayer.isCountdown("kitCommandCountdown")) {
                player.sendMessage(this.playerKits.getLang().getString("messages.pleaseWait"));
                return true;
            }
            countdownPlayer.setCountdown("kitCommandCountdown", 500, TimeUnit.MILLISECONDS);
            if (args.length < 1) {
                if (this.playerKits.getConfig().getBoolean("kitsCMD.enabled")) {
                    ((CompletableFuture)this.playerKits.getDatabase().getPlayerData(player.getUniqueId(), player.getName()).thenAccept(playerKitData -> this.playerKits.getStellarTaskHook(() -> {
                        new KitsMenu(player, (PlayerKitData)playerKitData, 1).open();
                        countdownPlayer.resetCountdown("kitCommandCountdown");
                    }).runTask(player.getLocation()))).exceptionally(throwable -> {
                        throwable.printStackTrace();
                        return null;
                    });
                } else {
                    this.sendHelp(sender);
                }
                return true;
            }
        }
        if (args.length < 1) {
            this.sendHelp(sender);
            return true;
        }
        switch (args[0].toLowerCase()) {
            case "editor": 
            case "migratekits": 
            case "open": 
            case "kits": {
                if (!(sender instanceof Player)) {
                    sender.sendMessage("\u00a7cThis command is only for players.");
                    return true;
                }
                String argument = args[0].toLowerCase();
                this.arguments.get(argument).onCommand(sender, Arrays.copyOfRange(args, 1, args.length));
                return false;
            }
            case "give": 
            case "claim": 
            case "delete": 
            case "reset": 
            case "resetall": 
            case "migrate": 
            case "preview": 
            case "reload": {
                String argument = args[0].toLowerCase();
                this.arguments.get(argument).onCommand(sender, Arrays.copyOfRange(args, 1, args.length));
                break;
            }
            case "help": {
                this.sendHelp(sender);
                break;
            }
            default: {
                Kit kit;
                if (this.playerKits.getConfigManager().isClaimAlias() && (kit = this.playerKits.getKitManager().getKit(args[0])) != null && sender instanceof Player) {
                    Player player = (Player)sender;
                    ((CompletableFuture)this.playerKits.getDatabase().getPlayerData(player.getUniqueId(), player.getName()).thenAccept(playerKitData -> this.playerKits.getStellarTaskHook(() -> XPKUtils.claimKit(player, kit, playerKitData)).runTask(player.getLocation()))).exceptionally(throwable -> {
                        throwable.printStackTrace();
                        return null;
                    });
                    return false;
                }
                this.sendHelp(sender);
            }
        }
        return false;
    }

    void sendHelp(CommandSender sender) {
        sender.sendMessage(ChatColor.GRAY + "" + ChatColor.STRIKETHROUGH + "+---------------------------------------+");
        sender.sendMessage(ChatColor.DARK_GRAY + "[!] " + ChatColor.RED + "XPlayerKits " + ChatColor.DARK_GRAY + "[!]");
        sender.sendMessage(ChatColor.GRAY + "" + ChatColor.STRIKETHROUGH + "+---------------------------------------+");
        sender.sendMessage("\u00a7e/xkits editor \u00a77- \u00a7fOpens the kit editor.");
        sender.sendMessage("\u00a7e/xkits kits \u00a77- \u00a7fOpens the kit menu.");
        sender.sendMessage("\u00a7e/xkits open [rotation/category] \u00a77- \u00a7fOpens the kit menu.");
        sender.sendMessage("\u00a7e/xkits give <kitName> <player> \u00a77- \u00a7fDirectly give kits to players without verifications..");
        sender.sendMessage("\u00a7e/xkits claim <kitName> <player> \u00a77- \u00a7fGive kits to players with verifications.");
        sender.sendMessage("\u00a7e/xkits delete <kitName> \u00a77- \u00a7fDelete a kit.");
        sender.sendMessage("\u00a7e/xkits preview <kitName> \u00a77- \u00a7fPreview a kit.");
        sender.sendMessage("\u00a7e/xkits reset <kitName> <player> \u00a77- \u00a7fReset a certain kit data.");
        sender.sendMessage("\u00a7e/xkits resetall <player> \u00a77- \u00a7fReset all kit data.");
        sender.sendMessage("\u00a7e/xkits migrate playerkits2_yml/playerkits2_mysql \u00a77- \u00a7fMigrate data from playerkits2 plugin.");
        sender.sendMessage("\u00a7e/xkits migratekits playerkits2 \u00a77- \u00a7fMigrate kit from playerkits2 plugin.");
        sender.sendMessage(ChatColor.GRAY + "" + ChatColor.STRIKETHROUGH + "+---------------------------------------+");
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command cmd, @NotNull String label, @NotNull String[] args) {
        if (args.length <= 1) {
            String argument = args.length == 0 ? "" : args[0].toLowerCase();
            return Stream.of("editor", "slots", "kits", "give", "claim", "delete", "reset", "resetall", "migrate", "migratekits", "reload", "open").filter(s -> s.contains(argument)).collect(Collectors.toList());
        }
        switch (args[0].toLowerCase()) {
            case "give": 
            case "claim": 
            case "reset": {
                return this.completes.get("give").onTabComplete(sender, Arrays.copyOfRange(args, 1, args.length));
            }
            case "delete": 
            case "preview": 
            case "resetall": 
            case "migrate": 
            case "migratekits": 
            case "open": {
                return this.completes.get(args[0].toLowerCase()).onTabComplete(sender, Arrays.copyOfRange(args, 1, args.length));
            }
        }
        return null;
    }
}

