/*
 * Decompiled with CFR 0.152.
 */
package io.github.InsiderAnh.xPlayerKits.executions.executions;

import io.github.InsiderAnh.xPlayerKits.PlayerKits;
import io.github.InsiderAnh.xPlayerKits.api.ColorUtils;
import io.github.InsiderAnh.xPlayerKits.api.PlayerKitsNMS;
import io.github.InsiderAnh.xPlayerKits.executions.Execution;
import io.github.InsiderAnh.xPlayerKits.executions.enums.MessageType;
import io.github.InsiderAnh.xPlayerKits.placeholders.Placeholder;
import io.github.InsiderAnh.xPlayerKits.utils.CenterMessage;
import io.github.InsiderAnh.xPlayerKits.utils.LanguageUtils;
import me.clip.placeholderapi.PlaceholderAPI;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class ExecuteMessage
extends Execution {
    private final MessageType messageType;
    private final String message;

    public ExecuteMessage(String action, MessageType messageType, String message) {
        super(action);
        this.messageType = messageType;
        this.message = message;
    }

    @Override
    public void execute(Player player, Placeholder ... placeholders) {
        ColorUtils colorUtils = PlayerKits.getInstance().getColorUtils();
        PlayerKitsNMS nms = PlayerKits.getInstance().getPlayerKitsNMS();
        String replacedMessage = colorUtils.color(PlaceholderAPI.setPlaceholders((Player)player, (String)LanguageUtils.replacePlaceholders(this.message, placeholders)));
        if (this.messageType.equals((Object)MessageType.NORMAL)) {
            player.sendMessage(replacedMessage);
        } else if (this.messageType.equals((Object)MessageType.CENTERED)) {
            player.sendMessage(CenterMessage.getCenteredMessage(replacedMessage));
        } else if (this.messageType.equals((Object)MessageType.MINI_MESSAGE)) {
            nms.sendMiniMessage(player, replacedMessage);
        } else if (this.messageType.equals((Object)MessageType.ACTION_BAR)) {
            nms.sendActionBar(player, replacedMessage);
        } else if (this.messageType.equals((Object)MessageType.BROADCAST)) {
            for (Player online : Bukkit.getOnlinePlayers()) {
                online.sendMessage(replacedMessage);
            }
        }
    }

    @Override
    public String getActionType() {
        return this.messageType.name().toLowerCase();
    }
}

