/*
 * Decompiled with CFR 0.152.
 */
package io.github.InsiderAnh.xPlayerKits.items;

import io.github.InsiderAnh.xPlayerKits.PlayerKits;
import io.github.InsiderAnh.xPlayerKits.enums.MinecraftVersion;
import io.github.InsiderAnh.xPlayerKits.items.versions.CrossVersionBannerPattern;
import io.github.InsiderAnh.xPlayerKits.items.versions.CrossVersionEnchantment;
import io.github.InsiderAnh.xPlayerKits.libs.nbtapi.NBT;
import io.github.InsiderAnh.xPlayerKits.libs.nbtapi.NBTItem;
import io.github.InsiderAnh.xPlayerKits.libs.nbtapi.iface.ReadWriteNBT;
import io.github.InsiderAnh.xPlayerKits.utils.XPKUtils;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.ChatColor;
import org.bukkit.Color;
import org.bukkit.DyeColor;
import org.bukkit.FireworkEffect;
import org.bukkit.Material;
import org.bukkit.block.banner.Pattern;
import org.bukkit.block.banner.PatternType;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BannerMeta;
import org.bukkit.inventory.meta.BookMeta;
import org.bukkit.inventory.meta.FireworkMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.inventory.meta.MapMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.inventory.meta.SkullMeta;

public class ItemSerializer {
    public static ItemStack deserialize(Map<String, Object> data) {
        ItemStack item = ItemSerializer.createBasicItemStack(data);
        if (item == null) {
            return null;
        }
        ItemSerializer.applyNBT(item, data);
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return item;
        }
        ItemSerializer.applyBasicMeta(meta, data);
        ItemSerializer.applyEnchantments(meta, data);
        ItemSerializer.applyItemFlags(meta, data);
        ItemSerializer.applyVersionSpecificMeta(meta, data);
        ItemSerializer.deserializeSpecificMeta(meta, data);
        item.setItemMeta(meta);
        return item;
    }

    private static ItemStack createBasicItemStack(Map<String, Object> data) {
        String materialName = (String)data.get("material");
        if (materialName == null) {
            return null;
        }
        Material material = ItemSerializer.parseMaterial(materialName);
        if (material == null) {
            return null;
        }
        int amount = data.containsKey("amount") ? (Integer)data.get("amount") : 1;
        short dat = data.containsKey("data") ? (short)((Integer)data.get("data")).intValue() : (short)0;
        ItemStack item = new ItemStack(material, amount, dat);
        if (data.containsKey("durability")) {
            item.setDurability(((Number)data.get("durability")).shortValue());
        }
        return item;
    }

    private static Material parseMaterial(String materialName) {
        try {
            return Material.valueOf((String)materialName.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    private static void applyBasicMeta(ItemMeta meta, Map<String, Object> data) {
        if (data.containsKey("displayname")) {
            String displayName = (String)data.get("displayname");
            meta.setDisplayName(ItemSerializer.codeToColor(displayName));
        }
        if (data.containsKey("lore")) {
            List<String> lore = ItemSerializer.convertLoreList((List)data.get("lore"));
            meta.setLore(lore);
        }
    }

    private static List<String> convertLoreList(List<?> loreList) {
        ArrayList<String> lore = new ArrayList<String>();
        for (Object line : loreList) {
            lore.add(ItemSerializer.codeToColor(line.toString()));
        }
        return lore;
    }

    private static void applyNBT(ItemStack item, Map<String, Object> data) {
        if (!data.containsKey("nbt_data")) {
            return;
        }
        String nbtString = (String)data.get("nbt_data");
        if (nbtString == null) {
            return;
        }
        ReadWriteNBT nbt = NBT.parseNBT(nbtString);
        NBTItem nbtItem = new NBTItem(item);
        nbtItem.mergeCompound(nbt);
        item.setItemMeta(nbtItem.getItem().getItemMeta());
    }

    private static void applyEnchantments(ItemMeta meta, Map<String, Object> data) {
        if (!data.containsKey("enchants")) {
            return;
        }
        List enchantList = (List)data.get("enchants");
        for (Object enchantObj : enchantList) {
            ItemSerializer.applyEnchantment(meta, enchantObj.toString());
        }
    }

    private static void applyEnchantment(ItemMeta meta, String enchantStr) {
        String[] parts = enchantStr.split(":");
        if (parts.length < 2) {
            return;
        }
        Enchantment enchant = CrossVersionEnchantment.getEnchant(parts[0]);
        if (enchant != null) {
            int level = Integer.parseInt(parts[1]);
            meta.addEnchant(enchant, level, true);
        }
    }

    private static void applyItemFlags(ItemMeta meta, Map<String, Object> data) {
        if (!data.containsKey("itemflags")) {
            return;
        }
        List flagList = (List)data.get("itemflags");
        for (Object flagObj : flagList) {
            ItemSerializer.applyItemFlag(meta, flagObj.toString());
        }
    }

    private static void applyItemFlag(ItemMeta meta, String flagName) {
        try {
            ItemFlag itemFlag = ItemFlag.valueOf((String)flagName);
            meta.addItemFlags(new ItemFlag[]{itemFlag});
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void applyVersionSpecificMeta(ItemMeta meta, Map<String, Object> data) {
        ItemSerializer.applyUnbreakable(meta, data);
        ItemSerializer.applyCustomModelData(meta, data);
    }

    private static void applyUnbreakable(ItemMeta meta, Map<String, Object> data) {
        if (!data.containsKey("unbreakable")) {
            return;
        }
        boolean unbreakable = (Boolean)data.get("unbreakable");
        PlayerKits.getInstance().getPlayerKitsNMS().setUnbreakable(meta, unbreakable);
    }

    private static void applyCustomModelData(ItemMeta meta, Map<String, Object> data) {
        if (!data.containsKey("custom_model_data")) {
            return;
        }
        if (!XPKUtils.SERVER_VERSION.greaterThanOrEqualTo(MinecraftVersion.v1_13)) {
            return;
        }
        int customModelData = (Integer)data.get("custom_model_data");
        if (customModelData == 0) {
            return;
        }
        PlayerKits.getInstance().getPlayerKitsNMS().setCustomModelData(meta, customModelData);
    }

    private static void deserializeSpecificMeta(ItemMeta meta, Map<String, Object> data) {
        if (meta instanceof BannerMeta) {
            ItemSerializer.deserializeBannerMeta((BannerMeta)meta, data);
        } else if (meta instanceof LeatherArmorMeta) {
            ItemSerializer.deserializeLeatherArmorMeta((LeatherArmorMeta)meta, data);
        } else if (meta instanceof SkullMeta) {
            ItemSerializer.deserializeSkullMeta((SkullMeta)meta, data);
        } else if (meta instanceof BookMeta) {
            ItemSerializer.deserializeBookMeta((BookMeta)meta, data);
        } else if (meta instanceof PotionMeta) {
            ItemSerializer.deserializePotionMeta((PotionMeta)meta, data);
        }
    }

    private static void deserializeBannerMeta(BannerMeta bannerMeta, Map<String, Object> data) {
        if (!data.containsKey("banner_patterns")) {
            return;
        }
        List patternList = (List)data.get("banner_patterns");
        ArrayList<Pattern> patterns = new ArrayList<Pattern>();
        for (Object patternObj : patternList) {
            Pattern pattern = ItemSerializer.parseBannerPattern(patternObj.toString());
            if (pattern == null) continue;
            patterns.add(pattern);
        }
        bannerMeta.setPatterns(patterns);
    }

    private static Pattern parseBannerPattern(String patternStr) {
        String[] parts = patternStr.split(":");
        if (parts.length < 2) {
            return null;
        }
        PatternType type = CrossVersionBannerPattern.getPattern(parts[0]);
        if (type == null) {
            return null;
        }
        try {
            DyeColor color = DyeColor.valueOf((String)parts[1].toUpperCase());
            return new Pattern(color, type);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    private static void deserializeLeatherArmorMeta(LeatherArmorMeta leatherMeta, Map<String, Object> data) {
        if (data.containsKey("leather_color")) {
            int colorInt = (Integer)data.get("leather_color");
            leatherMeta.setColor(Color.fromRGB((int)colorInt));
        }
    }

    private static void deserializeSkullMeta(SkullMeta skullMeta, Map<String, Object> data) {
        if (data.containsKey("skull_owner")) {
            skullMeta.setOwner((String)data.get("skull_owner"));
        }
    }

    private static void deserializeBookMeta(BookMeta bookMeta, Map<String, Object> data) {
        if (data.containsKey("book_title")) {
            bookMeta.setTitle(ItemSerializer.codeToColor((String)data.get("book_title")));
        }
        if (data.containsKey("book_author")) {
            bookMeta.setAuthor((String)data.get("book_author"));
        }
        if (data.containsKey("book_pages")) {
            List<String> pages = ItemSerializer.convertBookPages((List)data.get("book_pages"));
            bookMeta.setPages(pages);
        }
    }

    private static List<String> convertBookPages(List<?> pageList) {
        ArrayList<String> pages = new ArrayList<String>();
        for (Object page : pageList) {
            pages.add(ItemSerializer.codeToColor(page.toString()));
        }
        return pages;
    }

    public static void serialize(ItemStack item, YamlConfiguration config, String path) {
        if (item == null || item.getType() == Material.AIR) {
            config.set(path + ".material", (Object)"AIR");
            return;
        }
        config.set(path, null);
        ItemSerializer.serializeBasicProperties(item, config, path);
        ItemSerializer.serializeNBT(item, config, path);
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            ItemSerializer.serializeItemMeta(item, meta, config, path);
        }
    }

    private static void serializeBasicProperties(ItemStack item, YamlConfiguration config, String path) {
        config.set(path + ".material", (Object)item.getType().name());
        if (item.getData().getData() != 0) {
            config.set(path + ".data", (Object)item.getData().getData());
        }
        if (item.getAmount() != 1) {
            config.set(path + ".amount", (Object)item.getAmount());
        }
        if (item.getDurability() != 0) {
            config.set(path + ".durability", (Object)item.getDurability());
        }
    }

    private static void serializeItemMeta(ItemStack itemStack, ItemMeta meta, YamlConfiguration config, String path) {
        ItemSerializer.serializeDisplayProperties(meta, config, path);
        ItemSerializer.serializeEnchantments(meta, config, path);
        ItemSerializer.serializeItemFlags(meta, config, path);
        ItemSerializer.serializeVersionSpecificProperties(meta, config, path);
        ItemSerializer.serializeSpecificMeta(itemStack, meta, config, path);
    }

    private static void serializeDisplayProperties(ItemMeta meta, YamlConfiguration config, String path) {
        if (meta.hasDisplayName()) {
            config.set(path + ".displayname", (Object)ItemSerializer.colorToCode(meta.getDisplayName()));
        }
        if (meta.hasLore()) {
            ArrayList<String> lore = new ArrayList<String>();
            for (String line : meta.getLore()) {
                lore.add(ItemSerializer.colorToCode(line));
            }
            config.set(path + ".lore", lore);
        }
    }

    private static void serializeEnchantments(ItemMeta meta, YamlConfiguration config, String path) {
        if (!meta.hasEnchants()) {
            return;
        }
        ArrayList<String> enchants = new ArrayList<String>();
        for (Map.Entry entry : meta.getEnchants().entrySet()) {
            String enchantId = CrossVersionEnchantment.getEnchantId((Enchantment)entry.getKey());
            enchants.add(enchantId + ":" + entry.getValue());
        }
        config.set(path + ".enchants", enchants);
    }

    private static void serializeNBT(ItemStack itemStack, YamlConfiguration config, String path) {
        NBTItem nbtItem = new NBTItem(itemStack);
        if (!nbtItem.hasNBTData()) {
            return;
        }
        config.set(path + ".nbt_data", (Object)nbtItem.toString());
    }

    private static void serializeItemFlags(ItemMeta meta, YamlConfiguration config, String path) {
        if (meta.getItemFlags().isEmpty()) {
            return;
        }
        ArrayList<String> flags = new ArrayList<String>();
        for (Object flag : meta.getItemFlags()) {
            flags.add(flag.toString());
        }
        config.set(path + ".itemflags", flags);
    }

    private static void serializeVersionSpecificProperties(ItemMeta meta, YamlConfiguration config, String path) {
        ItemSerializer.serializeUnbreakable(meta, config, path);
        ItemSerializer.serializeCustomModelData(meta, config, path);
    }

    private static void serializeUnbreakable(ItemMeta meta, YamlConfiguration config, String path) {
        try {
            config.set(path + ".unbreakable", (Object)PlayerKits.getInstance().getPlayerKitsNMS().isUnbreakable(meta));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void serializeCustomModelData(ItemMeta meta, YamlConfiguration config, String path) {
        if (!XPKUtils.SERVER_VERSION.greaterThanOrEqualTo(MinecraftVersion.v1_13)) {
            return;
        }
        try {
            Method hasCustomModelData = meta.getClass().getMethod("hasCustomModelData", new Class[0]);
            if (((Boolean)hasCustomModelData.invoke((Object)meta, new Object[0])).booleanValue()) {
                Method getCustomModelData = meta.getClass().getMethod("getCustomModelData", new Class[0]);
                int modelData = (Integer)getCustomModelData.invoke((Object)meta, new Object[0]);
                config.set(path + ".custom_model_data", (Object)modelData);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void serializeSpecificMeta(ItemStack itemStack, ItemMeta meta, YamlConfiguration config, String path) {
        if (meta instanceof BannerMeta) {
            ItemSerializer.serializeBannerMeta((BannerMeta)meta, config, path);
        } else if (meta instanceof LeatherArmorMeta) {
            ItemSerializer.serializeLeatherArmorMeta((LeatherArmorMeta)meta, config, path);
        } else if (meta instanceof SkullMeta) {
            ItemSerializer.serializeSkullMeta((SkullMeta)meta, config, path);
        } else if (meta instanceof BookMeta) {
            ItemSerializer.serializeBookMeta((BookMeta)meta, config, path);
        } else if (meta instanceof PotionMeta) {
            ItemSerializer.serializePotionMeta(itemStack, config, path);
        } else if (meta instanceof FireworkMeta) {
            ItemSerializer.serializeFireworkMeta((FireworkMeta)meta, config, path);
        } else if (meta instanceof MapMeta) {
            ItemSerializer.serializeMapMeta((MapMeta)meta, config, path);
        }
    }

    private static void serializeBannerMeta(BannerMeta bannerMeta, YamlConfiguration config, String path) {
        if (bannerMeta.getPatterns().isEmpty()) {
            return;
        }
        ArrayList<String> patterns = new ArrayList<String>();
        for (Pattern pattern : bannerMeta.getPatterns()) {
            String patternId = CrossVersionBannerPattern.getPatternId(pattern.getPattern());
            String color = pattern.getColor().name().toLowerCase();
            patterns.add(patternId + ":" + color);
        }
        config.set(path + ".banner_patterns", patterns);
    }

    private static void serializeLeatherArmorMeta(LeatherArmorMeta leatherMeta, YamlConfiguration config, String path) {
        Color color = leatherMeta.getColor();
        if (!color.equals((Object)Color.fromRGB((int)160, (int)101, (int)64))) {
            config.set(path + ".leather_color", (Object)color.asRGB());
        }
    }

    private static void serializeSkullMeta(SkullMeta skullMeta, YamlConfiguration config, String path) {
        if (skullMeta.hasOwner()) {
            config.set(path + ".skull_owner", (Object)skullMeta.getOwner());
        }
    }

    private static void serializeBookMeta(BookMeta bookMeta, YamlConfiguration config, String path) {
        if (bookMeta.hasTitle()) {
            config.set(path + ".book_title", (Object)ItemSerializer.colorToCode(bookMeta.getTitle()));
        }
        if (bookMeta.hasAuthor()) {
            config.set(path + ".book_author", (Object)bookMeta.getAuthor());
        }
        if (bookMeta.hasPages()) {
            ArrayList<String> pages = new ArrayList<String>();
            for (String page : bookMeta.getPages()) {
                pages.add(ItemSerializer.colorToCode(page));
            }
            config.set(path + ".book_pages", pages);
        }
    }

    private static void serializePotionMeta(ItemStack itemStack, YamlConfiguration config, String path) {
        PlayerKits.getInstance().getPlayerKitsNMS().serializePotionMeta(itemStack, config, path);
    }

    private static void deserializePotionMeta(PotionMeta potionMeta, Map<String, Object> data) {
        PlayerKits.getInstance().getPlayerKitsNMS().deserializePotionMeta(potionMeta, data);
    }

    private static void serializeFireworkMeta(FireworkMeta fireworkMeta, YamlConfiguration config, String path) {
        config.set(path + ".firework_power", (Object)fireworkMeta.getPower());
        if (!fireworkMeta.getEffects().isEmpty()) {
            ArrayList<Map<String, Object>> effects = new ArrayList<Map<String, Object>>();
            for (FireworkEffect effect : fireworkMeta.getEffects()) {
                Map<String, Object> effectMap = ItemSerializer.createFireworkEffectMap(effect);
                effects.add(effectMap);
            }
            config.set(path + ".firework_effects", effects);
        }
    }

    private static Map<String, Object> createFireworkEffectMap(FireworkEffect effect) {
        HashMap<String, Object> effectMap = new HashMap<String, Object>();
        effectMap.put("type", effect.getType().name().toLowerCase());
        if (!effect.getColors().isEmpty()) {
            ArrayList<Integer> colors = new ArrayList<Integer>();
            for (Color color : effect.getColors()) {
                colors.add(color.asRGB());
            }
            effectMap.put("colors", colors);
        }
        return effectMap;
    }

    private static void serializeMapMeta(MapMeta mapMeta, YamlConfiguration config, String path) {
        if (mapMeta.hasMapId()) {
            config.set(path + ".map_id", (Object)mapMeta.getMapId());
        }
    }

    private static String colorToCode(String text) {
        return text.replace("\u00a7", "&");
    }

    private static String codeToColor(String text) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)text);
    }
}

