/*
 * Decompiled with CFR 0.152.
 */
package io.github.InsiderAnh.xPlayerKits.kits;

import io.github.InsiderAnh.xPlayerKits.PlayerKits;
import io.github.InsiderAnh.xPlayerKits.config.InsiderConfig;
import io.github.InsiderAnh.xPlayerKits.executions.Execution;
import io.github.InsiderAnh.xPlayerKits.items.ItemSerializer;
import io.github.InsiderAnh.xPlayerKits.kits.properties.PropertyInventory;
import io.github.InsiderAnh.xPlayerKits.kits.properties.PropertyTiming;
import io.github.InsiderAnh.xPlayerKits.managers.ExecutionManager;
import io.github.InsiderAnh.xPlayerKits.placeholders.Placeholder;
import io.github.InsiderAnh.xPlayerKits.utils.InventorySerializable;
import io.github.InsiderAnh.xPlayerKits.utils.ItemUtils;
import io.github.InsiderAnh.xPlayerKits.utils.XPKUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import lombok.Generated;
import me.clip.placeholderapi.PlaceholderAPI;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;

public class Kit {
    private final ArrayList<String> requirements = new ArrayList();
    private final HashMap<String, ItemStack> icons = new HashMap();
    private final ArrayList<Execution> actionsOnClaim = new ArrayList();
    private final ArrayList<Execution> actionsOnDeny = new ArrayList();
    private String name;
    private PropertyTiming propertyTiming;
    private PropertyInventory propertyInventory;
    private boolean preview;
    private double price;
    private boolean parsePlaceholdersOnClaim = true;
    private String permission;
    private ItemStack[] armor = new ItemStack[10];
    private ItemStack[] inventory = new ItemStack[50];
    private ItemStack offhand;

    public Kit(String name, int slot) {
        this.name = name;
        this.propertyTiming = new PropertyTiming();
        this.propertyInventory = new PropertyInventory();
        this.propertyInventory.setSlot(slot);
        this.preview = false;
        this.price = 0.0;
        this.permission = "none";
        this.armor = new ItemStack[10];
        this.inventory = new ItemStack[50];
        this.offhand = null;
        this.requirements.add("none");
        ExecutionManager executionManager = PlayerKits.getInstance().getExecutionManager();
        this.actionsOnClaim.add(executionManager.getExecution("console:say Test allow commands."));
        this.actionsOnClaim.add(executionManager.getExecution("command:/test command"));
        this.actionsOnClaim.add(executionManager.getExecution("sound:ENTITY_PLAYER_LEVELUP;1.0f;1.0f"));
        this.actionsOnDeny.add(executionManager.getExecution("console:say Test allow commands."));
        this.actionsOnDeny.add(executionManager.getExecution("command:/test command"));
        this.actionsOnDeny.add(executionManager.getExecution("sound:ENTITY_ENDERMAN_TELEPORT;1.0f;1.0f"));
        this.icons.put("CAN_CLAIM", new ItemUtils(Material.STONE).displayName("\u00a7aKit test").lore("\u00a77You can claim this kit.\n\n\u00a7eClick to claim!").build());
        this.icons.put("CANT_CLAIM", new ItemUtils(Material.STONE).displayName("\u00a7cKit test").lore("\u00a77You can\u00b4t claim this kit.\n\n\u00a7cYou can\u00b4t claim this kit!").build());
        this.icons.put("NO_PERMISSION", new ItemUtils(Material.STONE).displayName("\u00a7cKit test").lore("\u00a77You can\u00b4t claim this kit.\n\n\u00a7cYou don\u00b4t have permission!").build());
        this.icons.put("COUNTDOWN", new ItemUtils(Material.STONE).displayName("\u00a7cKit test").lore("\u00a77You can\u00b4t claim this kit.\n\n\u00a7cIn countdown!").build());
        this.icons.put("ONE_TIME_CLAIMED", new ItemUtils(Material.STONE).displayName("\u00a7cKit test").lore("\u00a77You can\u00b4t claim this kit.\n\n\u00a7cAlready claimed!").build());
        this.icons.put("ONE_TIME_REQUIREMENT", new ItemUtils(Material.STONE).displayName("\u00a7aKit test").lore("\u00a77You can claim this kit.\n\n\u00a7eClick to claim one time!").build());
    }

    public Kit(@NotNull InsiderConfig config) {
        HashMap<String, Object> data;
        this.name = config.getString("name");
        this.propertyTiming = new PropertyTiming(config);
        this.propertyInventory = new PropertyInventory(config);
        this.preview = config.getBooleanOrDefault("preview", true);
        this.parsePlaceholdersOnClaim = config.getBooleanOrDefault("parsePlaceholdersOnClaim", true);
        this.price = config.getDouble("price");
        this.permission = config.getString("permission");
        this.requirements.addAll(config.getList("requirements"));
        for (String action : config.getList("actionsOnClaim")) {
            this.actionsOnClaim.add(PlayerKits.getInstance().getExecutionManager().getExecution(action));
        }
        for (String action : config.getList("actionsOnDeny")) {
            this.actionsOnDeny.add(PlayerKits.getInstance().getExecutionManager().getExecution(action));
        }
        if (config.isSet("armor")) {
            this.armor = InventorySerializable.itemStackArrayFromBase64(config.getString("armor"));
            this.inventory = InventorySerializable.itemStackArrayFromBase64(config.getString("inventory"));
            if (config.isSet("icons")) {
                for (String key : config.getConfig().getConfigurationSection("icons").getKeys(false)) {
                    this.icons.put(key, InventorySerializable.itemStackFromBase64(config.getConfig().getString("icons." + key)));
                }
            }
            this.save();
        }
        if (config.isSet("armorSet")) {
            for (String key : config.getConfig().getConfigurationSection("armorSet").getKeys(false)) {
                this.armor[Integer.parseInt((String)key)] = config.getConfig().getItemStack("armorSet." + key);
            }
            if (config.isSet("inventorySet")) {
                for (String key : config.getConfig().getConfigurationSection("inventorySet").getKeys(false)) {
                    this.inventory[Integer.parseInt((String)key)] = config.getConfig().getItemStack("inventorySet." + key);
                }
            }
            if (config.isSet("iconSet")) {
                for (String key : config.getConfig().getConfigurationSection("iconSet").getKeys(false)) {
                    this.icons.put(key, config.getConfig().getItemStack("iconSet." + key));
                }
            }
            if (config.isSet("offhand")) {
                this.offhand = config.getConfig().getItemStack("offhand");
            }
            this.save();
            PlayerKits.getInstance().sendDebugMessage("Kit " + this.name + " migrated correctly.");
        }
        if (config.isSet("playerArmor")) {
            for (String key : config.getConfig().getConfigurationSection("playerArmor").getKeys(false)) {
                data = new HashMap<String, Object>(config.getConfig().getConfigurationSection("playerArmor." + key).getValues(false));
                this.armor[Integer.parseInt((String)key)] = ItemSerializer.deserialize(data);
            }
        }
        if (config.isSet("playerInventory")) {
            for (String key : config.getConfig().getConfigurationSection("playerInventory").getKeys(false)) {
                data = new HashMap(config.getConfig().getConfigurationSection("playerInventory." + key).getValues(false));
                this.inventory[Integer.parseInt((String)key)] = ItemSerializer.deserialize(data);
            }
        }
        if (config.isSet("kitIcons")) {
            for (String key : config.getConfig().getConfigurationSection("kitIcons").getKeys(false)) {
                data = new HashMap(config.getConfig().getConfigurationSection("kitIcons." + key).getValues(false));
                this.icons.put(key, ItemSerializer.deserialize(data));
            }
        }
        if (config.isSet("playerOffhand")) {
            HashMap<String, Object> data2 = new HashMap<String, Object>(config.getConfig().getConfigurationSection("playerOffhand").getValues(false));
            this.offhand = ItemSerializer.deserialize(data2);
        }
        this.icons.put("CAN_CLAIM", new ItemUtils(Material.STONE).displayName("\u00a7aKit test").lore("\u00a77You can claim this kit.\n\n\u00a7eClick to claim!").build());
        this.icons.put("CANT_CLAIM", new ItemUtils(Material.STONE).displayName("\u00a7cKit test").lore("\u00a77You can\u00b4t claim this kit.\n\n\u00a7cYou can\u00b4t claim this kit!").build());
        this.icons.put("NO_PERMISSION", new ItemUtils(Material.STONE).displayName("\u00a7cKit test").lore("\u00a77You can\u00b4t claim this kit.\n\n\u00a7cYou don\u00b4t have permission!").build());
        this.icons.put("COUNTDOWN", new ItemUtils(Material.STONE).displayName("\u00a7cKit test").lore("\u00a77You can\u00b4t claim this kit.\n\n\u00a7cIn countdown!").build());
        this.icons.put("ONE_TIME_CLAIMED", new ItemUtils(Material.STONE).displayName("\u00a7cKit test").lore("\u00a77You can\u00b4t claim this kit.\n\n\u00a7cAlready claimed!").build());
        this.icons.put("ONE_TIME_REQUIREMENT", new ItemUtils(Material.STONE).displayName("\u00a7aKit test").lore("\u00a77You can claim this kit.\n\n\u00a7eClick to claim one time!").build());
    }

    public void setIcon(String icon, ItemStack itemStack) {
        ItemStack item = itemStack.clone();
        ItemMeta itemMeta = item.getItemMeta();
        if (itemMeta == null) {
            return;
        }
        if (!itemMeta.hasDisplayName()) {
            itemMeta.setDisplayName("\u00a7aKit test");
        }
        if (!itemMeta.hasLore()) {
            itemMeta.setLore(Arrays.asList("\u00a77You can claim this kit.\n\n\u00a7cThis is a example lore".split("\n")));
        }
        item.setItemMeta(itemMeta);
        this.icons.put(icon, item);
    }

    public void save() {
        ItemStack itemStack;
        int i;
        InsiderConfig config = new InsiderConfig(PlayerKits.getInstance(), "kits/" + this.name, false, false);
        this.propertyTiming.save(config);
        this.propertyInventory.save(config);
        config.set("playerArmor", null);
        config.set("playerInventory", null);
        config.set("kitIcons", null);
        config.set("playerOffhand", null);
        config.set("name", this.name);
        config.set("preview", this.preview);
        config.set("price", this.price);
        config.set("permission", this.permission);
        config.set("requirements", this.requirements);
        config.set("actionsOnClaim", this.actionsOnClaim.stream().map(Execution::getAction).collect(Collectors.toList()));
        config.set("actionsOnDeny", this.actionsOnDeny.stream().map(Execution::getAction).collect(Collectors.toList()));
        if (this.offhand != null) {
            ItemSerializer.serialize(this.offhand, config.getConfig(), "playerOffhand");
        }
        for (i = 0; i < this.armor.length; ++i) {
            itemStack = this.armor[i];
            if (itemStack == null || itemStack.getType().equals((Object)Material.AIR)) continue;
            ItemSerializer.serialize(itemStack, config.getConfig(), "playerArmor." + i);
        }
        for (i = 0; i < this.inventory.length; ++i) {
            itemStack = this.inventory[i];
            if (itemStack == null || itemStack.getType().equals((Object)Material.AIR)) continue;
            ItemSerializer.serialize(itemStack, config.getConfig(), "playerInventory." + i);
        }
        for (Map.Entry<String, ItemStack> entry : this.icons.entrySet()) {
            String key = entry.getKey();
            ItemStack itemStack2 = entry.getValue();
            ItemSerializer.serialize(itemStack2, config.getConfig(), "kitIcons." + key);
        }
        config.set("armor", null);
        config.set("inventory", null);
        config.set("icons", null);
        config.set("offhand", null);
        config.set("iconSet", null);
        config.set("iconsSet", null);
        config.set("armorSet", null);
        config.set("inventorySet", null);
        config.save();
    }

    public boolean isNoInventorySpace(Player player) {
        ItemStack toItem;
        ItemStack itemStack;
        int i;
        AtomicBoolean occupied = new AtomicBoolean(false);
        AtomicInteger needAmount = new AtomicInteger(0);
        AtomicInteger haveAmount = new AtomicInteger(0);
        PlayerInventory playerInv = player.getInventory();
        for (i = 0; i < this.inventory.length; ++i) {
            itemStack = this.inventory[i];
            if (itemStack == null || itemStack.getType().equals((Object)Material.AIR)) continue;
            needAmount.addAndGet(1);
            toItem = playerInv.getItem(i);
            if (toItem != null) {
                if (toItem.getType().name().equals("AIR") || toItem.getType().name().equals("VOID_AIR") || toItem.getType().name().equals("CAVE_AIR")) {
                    haveAmount.addAndGet(1);
                    continue;
                }
                occupied.set(true);
                continue;
            }
            haveAmount.addAndGet(1);
        }
        for (i = 0; i < this.armor.length; ++i) {
            itemStack = this.armor[i];
            if (itemStack == null || itemStack.getType().equals((Object)Material.AIR)) continue;
            needAmount.addAndGet(1);
            toItem = player.getInventory().getArmorContents()[i];
            if (toItem != null) {
                if (toItem.getType().name().equals("AIR") || toItem.getType().name().equals("VOID_AIR") || toItem.getType().name().equals("CAVE_AIR")) {
                    haveAmount.addAndGet(1);
                    continue;
                }
                occupied.set(true);
                continue;
            }
            haveAmount.addAndGet(1);
        }
        return occupied.get();
    }

    public void giveKit(Player player) {
        ItemStack toGive;
        for (ItemStack itemStack : this.inventory) {
            if (itemStack == null || itemStack.getType().equals((Object)Material.AIR)) continue;
            toGive = this.parsePlaceholders(player, itemStack);
            player.getInventory().addItem(new ItemStack[]{toGive});
        }
        for (ItemStack itemStack : this.armor) {
            if (itemStack == null || itemStack.getType().equals((Object)Material.AIR)) continue;
            toGive = this.parsePlaceholders(player, itemStack);
            String itemType = toGive.getType().name();
            ItemStack currentArmor = null;
            if (this.getPropertyInventory().isAutoArmor()) {
                if (XPKUtils.isHelmet(itemType)) {
                    currentArmor = player.getInventory().getHelmet();
                    player.getInventory().setHelmet(toGive);
                } else if (XPKUtils.isChestplate(itemType)) {
                    currentArmor = player.getInventory().getChestplate();
                    player.getInventory().setChestplate(toGive);
                } else if (XPKUtils.isLeggings(itemType)) {
                    currentArmor = player.getInventory().getLeggings();
                    player.getInventory().setLeggings(toGive);
                } else if (XPKUtils.isBoots(itemType)) {
                    currentArmor = player.getInventory().getBoots();
                    player.getInventory().setBoots(toGive);
                }
                if (currentArmor == null || currentArmor.getType().equals((Object)Material.AIR)) continue;
                player.getInventory().addItem(new ItemStack[]{currentArmor});
                continue;
            }
            player.getInventory().addItem(new ItemStack[]{toGive});
        }
        PlayerKits.getInstance().getExecutionManager().execute(player, this.actionsOnClaim, new Placeholder("<player>", player.getName()));
    }

    public ItemStack parsePlaceholders(Player player, ItemStack itemStack) {
        if (this.parsePlaceholdersOnClaim) {
            ItemStack clonedItemStack = itemStack.clone();
            ItemMeta itemMeta = clonedItemStack.getItemMeta();
            if (itemMeta != null) {
                if (itemMeta.hasDisplayName()) {
                    itemMeta.setDisplayName(PlaceholderAPI.setPlaceholders((Player)player, (String)itemMeta.getDisplayName()));
                }
                if (itemMeta.hasLore()) {
                    itemMeta.setLore(PlaceholderAPI.setPlaceholders((Player)player, (List)Objects.requireNonNull(itemMeta.getLore())));
                }
                clonedItemStack.setItemMeta(itemMeta);
            }
            return clonedItemStack;
        }
        return itemStack;
    }

    public boolean isNoHasRequirements(Player player) {
        for (String requirement : this.requirements) {
            if (requirement.equalsIgnoreCase("none") || XPKUtils.passCondition(player, requirement)) continue;
            return true;
        }
        return false;
    }

    public String getRequirementsString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (String requirement : this.requirements) {
            stringBuilder.append(requirement).append("\n");
        }
        return stringBuilder.toString();
    }

    public String getActionsOnClaimString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (Execution execution : this.actionsOnClaim) {
            stringBuilder.append(execution.getAction()).append("\n");
        }
        return stringBuilder.toString();
    }

    public String getActionsOnDenyString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (Execution execution : this.actionsOnDeny) {
            stringBuilder.append(execution.getAction()).append("\n");
        }
        return stringBuilder.toString();
    }

    @Generated
    public ArrayList<String> getRequirements() {
        return this.requirements;
    }

    @Generated
    public HashMap<String, ItemStack> getIcons() {
        return this.icons;
    }

    @Generated
    public ArrayList<Execution> getActionsOnClaim() {
        return this.actionsOnClaim;
    }

    @Generated
    public ArrayList<Execution> getActionsOnDeny() {
        return this.actionsOnDeny;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public PropertyTiming getPropertyTiming() {
        return this.propertyTiming;
    }

    @Generated
    public PropertyInventory getPropertyInventory() {
        return this.propertyInventory;
    }

    @Generated
    public boolean isPreview() {
        return this.preview;
    }

    @Generated
    public double getPrice() {
        return this.price;
    }

    @Generated
    public boolean isParsePlaceholdersOnClaim() {
        return this.parsePlaceholdersOnClaim;
    }

    @Generated
    public String getPermission() {
        return this.permission;
    }

    @Generated
    public ItemStack[] getArmor() {
        return this.armor;
    }

    @Generated
    public ItemStack[] getInventory() {
        return this.inventory;
    }

    @Generated
    public ItemStack getOffhand() {
        return this.offhand;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setPropertyTiming(PropertyTiming propertyTiming) {
        this.propertyTiming = propertyTiming;
    }

    @Generated
    public void setPropertyInventory(PropertyInventory propertyInventory) {
        this.propertyInventory = propertyInventory;
    }

    @Generated
    public void setPreview(boolean preview) {
        this.preview = preview;
    }

    @Generated
    public void setPrice(double price) {
        this.price = price;
    }

    @Generated
    public void setParsePlaceholdersOnClaim(boolean parsePlaceholdersOnClaim) {
        this.parsePlaceholdersOnClaim = parsePlaceholdersOnClaim;
    }

    @Generated
    public void setPermission(String permission) {
        this.permission = permission;
    }

    @Generated
    public void setArmor(ItemStack[] armor) {
        this.armor = armor;
    }

    @Generated
    public void setInventory(ItemStack[] inventory) {
        this.inventory = inventory;
    }

    @Generated
    public void setOffhand(ItemStack offhand) {
        this.offhand = offhand;
    }
}

