/*
 * Decompiled with CFR 0.152.
 */
package io.github.InsiderAnh.xPlayerKits.managers;

import io.github.InsiderAnh.xPlayerKits.PlayerKits;
import io.github.InsiderAnh.xPlayerKits.config.InsiderConfig;
import io.github.InsiderAnh.xPlayerKits.customize.Menu;
import io.github.InsiderAnh.xPlayerKits.customize.MenuSlots;
import io.github.InsiderAnh.xPlayerKits.customize.MenuVarItem;
import io.github.InsiderAnh.xPlayerKits.kits.Kit;
import io.github.InsiderAnh.xPlayerKits.kits.properties.PropertyInventory;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import lombok.Generated;

public class KitManager {
    private final PlayerKits playerKits = PlayerKits.getInstance();
    private final LinkedHashMap<String, Kit> kits = new LinkedHashMap();
    private final LinkedList<Integer> kitSlots = new LinkedList();
    private int lastPage = 1;

    public void load() {
        MenuVarItem menuVarItem;
        this.kits.clear();
        File kitsFolder = new File(this.playerKits.getDataFolder(), "kits");
        if (!kitsFolder.exists()) {
            kitsFolder.mkdirs();
            this.playerKits.saveResource("kits/example_kit.yml", false);
        }
        int perPage = 21;
        Menu menu = this.playerKits.getMenuManager().getMenu("kits");
        if (menu != null && (menuVarItem = menu.getVarItems().get("kitSlots")) != null) {
            MenuSlots menuSlots = menuVarItem.getSlots();
            perPage = menuSlots.getPerPage();
            this.kitSlots.addAll(menuSlots.getSlots());
        }
        ArrayList<Kit> loadedKits = new ArrayList<Kit>();
        HashMap<String, Kit> forcedPositionKits = new HashMap<String, Kit>();
        ArrayList<Kit> flexibleKits = new ArrayList<Kit>();
        for (File file : kitsFolder.listFiles()) {
            Kit kit;
            if (!file.getName().endsWith(".yml")) continue;
            try {
                InsiderConfig config = new InsiderConfig(this.playerKits, "kits/" + file.getName().replace(".yml", ""), false, false);
                kit = new Kit(config);
            }
            catch (Exception e) {
                this.playerKits.getLogger().info("Error loading kit " + file.getName() + ": " + e.getMessage());
                continue;
            }
            if (kit.getPropertyInventory() == null || kit.getPropertyTiming() == null) {
                this.playerKits.getLogger().info("Error loading kit " + file.getName() + ": null");
                continue;
            }
            loadedKits.add(kit);
            this.playerKits.getLogger().info("Correctly loaded kit " + kit.getName() + ".");
        }
        for (Kit kit : loadedKits) {
            PropertyInventory property = kit.getPropertyInventory();
            if (property.getPage() != -1 && property.getSlot() != -1) {
                String key = property.getPage() + "-" + property.getSlot();
                forcedPositionKits.put(key, kit);
                if (property.getPage() <= this.lastPage) continue;
                this.lastPage = property.getPage();
                continue;
            }
            flexibleKits.add(kit);
        }
        this.organizeKits(forcedPositionKits, flexibleKits, perPage);
    }

    public Kit removeKit(String name) {
        return (Kit)this.kits.remove(name.toLowerCase());
    }

    public Kit getKit(String name) {
        return this.kits.get(name.toLowerCase());
    }

    public void addKit(Kit kit) {
        this.kits.put(kit.getName().toLowerCase(), kit);
        if (kit.getPropertyInventory().getPage() > this.lastPage) {
            this.lastPage = kit.getPropertyInventory().getPage();
        }
        this.reorganizeKitsAfterAdd();
    }

    private void reorganizeKitsAfterAdd() {
        MenuVarItem menuVarItem;
        HashMap<String, Kit> forcedPositionKits = new HashMap<String, Kit>();
        ArrayList<Kit> flexibleKits = new ArrayList<Kit>();
        int perPage = 21;
        Menu menu = this.playerKits.getMenuManager().getMenu("kits");
        if (menu != null && (menuVarItem = menu.getVarItems().get("kitSlots")) != null) {
            MenuSlots menuSlots = menuVarItem.getSlots();
            perPage = menuSlots.getPerPage();
        }
        for (Kit kit : new ArrayList<Kit>(this.kits.values())) {
            if (kit == null || kit.getPropertyInventory() == null || kit.getPropertyTiming() == null) continue;
            PropertyInventory property = kit.getPropertyInventory();
            if (property.getPage() != -1 && property.getSlot() != -1) {
                String key = property.getPage() + "-" + property.getSlot();
                forcedPositionKits.put(key, kit);
                continue;
            }
            flexibleKits.add(kit);
        }
        this.kits.clear();
        this.organizeKits(forcedPositionKits, flexibleKits, perPage);
    }

    private void organizeKits(Map<String, Kit> forcedPositionKits, List<Kit> flexibleKits, int perPage) {
        int totalKits = forcedPositionKits.size() + flexibleKits.size();
        int maxPagesNeeded = (int)Math.ceil((double)totalKits / (double)perPage);
        for (Kit kit : forcedPositionKits.values()) {
            if (kit == null || kit.getPropertyInventory() == null || kit.getPropertyTiming() == null || kit.getPropertyInventory().getPage() <= maxPagesNeeded) continue;
            maxPagesNeeded = kit.getPropertyInventory().getPage();
        }
        this.lastPage = Math.max(this.lastPage, maxPagesNeeded);
        LinkedHashMap<String, Kit> finalStructure = new LinkedHashMap<String, Kit>();
        Iterator<Kit> flexibleIterator = flexibleKits.iterator();
        for (int page = 1; page <= this.lastPage; ++page) {
            for (int slot = 0; slot < perPage; ++slot) {
                String positionKey = page + "-" + slot;
                if (forcedPositionKits.containsKey(positionKey)) {
                    Kit forcedKit = forcedPositionKits.get(positionKey);
                    finalStructure.put(forcedKit.getName().toLowerCase(), forcedKit);
                    continue;
                }
                if (flexibleIterator.hasNext()) {
                    Kit flexibleKit = flexibleIterator.next();
                    int kitSlot = this.kitSlots.size() <= slot ? 0 : this.kitSlots.get(slot);
                    flexibleKit.getPropertyInventory().setPage(page);
                    flexibleKit.getPropertyInventory().setSlot(kitSlot);
                    finalStructure.put(flexibleKit.getName().toLowerCase(), flexibleKit);
                    continue;
                }
                finalStructure.put(UUID.randomUUID().toString(), null);
            }
        }
        this.kits.putAll(finalStructure);
    }

    public Map<String, Kit> getSubMap(int skip, int limit) {
        if (skip < 0) {
            skip = 0;
        }
        if (limit < skip) {
            limit = skip;
        }
        if (skip >= this.kits.size()) {
            return new LinkedHashMap<String, Kit>();
        }
        int actualLimit = Math.min(limit, this.kits.size());
        LinkedHashMap<String, Kit> result = new LinkedHashMap<String, Kit>();
        this.kits.entrySet().stream().skip(skip).limit((long)actualLimit - (long)skip).forEach(entry -> result.put((String)entry.getKey(), (Kit)entry.getValue()));
        return result;
    }

    @Generated
    public PlayerKits getPlayerKits() {
        return this.playerKits;
    }

    @Generated
    public LinkedHashMap<String, Kit> getKits() {
        return this.kits;
    }

    @Generated
    public LinkedList<Integer> getKitSlots() {
        return this.kitSlots;
    }

    @Generated
    public int getLastPage() {
        return this.lastPage;
    }
}

