/*
 * Decompiled with CFR 0.152.
 */
package io.github.InsiderAnh.xPlayerKits.managers;

import io.github.InsiderAnh.xPlayerKits.PlayerKits;
import io.github.InsiderAnh.xPlayerKits.customize.Menu;
import java.io.File;
import java.util.HashMap;
import org.bukkit.configuration.file.YamlConfiguration;
import org.jetbrains.annotations.Nullable;

public class MenuManager {
    private final PlayerKits playerKits = PlayerKits.getInstance();
    private final HashMap<String, Menu> menus = new HashMap();

    public void load() {
        this.menus.clear();
        File menuFolder = new File(this.playerKits.getDataFolder(), "menus");
        if (!menuFolder.exists()) {
            menuFolder.mkdirs();
        }
        this.checkFile(menuFolder, "preview");
        this.checkFile(menuFolder, "kits");
        this.playerKits.sendDebugMessage("Loading menus...");
        for (File file : menuFolder.listFiles()) {
            if (!file.getName().endsWith(".yml")) continue;
            String menuId = file.getName().replace(".yml", "");
            YamlConfiguration configuration = YamlConfiguration.loadConfiguration((File)file);
            this.menus.put(menuId, new Menu(configuration, menuId));
            this.playerKits.sendDebugMessage("Loaded menu " + menuId);
        }
    }

    void checkFile(File menuFolder, String menuId) {
        File file = new File(menuFolder, menuId + ".yml");
        if (!file.exists()) {
            this.playerKits.saveResource("menus/" + menuId + ".yml", false);
        }
    }

    public String getTitle(String menuId, String defaultTitle) {
        Menu menu = this.menus.get(menuId);
        if (menu == null) {
            return defaultTitle;
        }
        return menu.getTitle();
    }

    @Nullable
    public Menu getMenu(String menuId) {
        return this.menus.get(menuId);
    }
}

