/*
 * Decompiled with CFR 0.152.
 */
package io.github.InsiderAnh.xPlayerKits.menus;

import io.github.InsiderAnh.xPlayerKits.PlayerKits;
import io.github.InsiderAnh.xPlayerKits.customize.Menu;
import io.github.InsiderAnh.xPlayerKits.customize.MenuItem;
import io.github.InsiderAnh.xPlayerKits.customize.MenuSlots;
import io.github.InsiderAnh.xPlayerKits.customize.MenuVarItem;
import io.github.InsiderAnh.xPlayerKits.inventory.AInventory;
import io.github.InsiderAnh.xPlayerKits.inventory.InventorySizes;
import io.github.InsiderAnh.xPlayerKits.kits.Kit;
import io.github.InsiderAnh.xPlayerKits.libs.nbtapi.NBTItem;
import io.github.InsiderAnh.xPlayerKits.placeholders.Placeholder;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class KitPreviewMenu
extends AInventory {
    private final Menu menu = PlayerKits.getInstance().getMenuManager().getMenu("preview");
    private final Kit kit;

    public KitPreviewMenu(Player player, Kit kit) {
        super(player, InventorySizes.GENERIC_9X6, PlayerKits.getInstance().getMenuManager().getTitle("preview", "Kit Preview"));
        this.kit = kit;
    }

    @Override
    protected void onClick(InventoryClickEvent event, ItemStack currentItem, ClickType click, Consumer<Boolean> canceled) {
        canceled.accept(true);
        Player player = this.getPlayer();
        NBTItem nbtItem = new NBTItem(currentItem);
        if (nbtItem.hasTag("xpk-menu:item")) {
            String itemId = nbtItem.getString("xpk-menu:item");
            MenuItem menuItem = this.menu.getItems().get(itemId);
            if (menuItem != null) {
                menuItem.getActions().forEach(action -> action.execute(player));
            }
        }
    }

    @Override
    protected void onDrag(InventoryClickEvent event, ItemStack currentItem, ClickType click, Consumer<Boolean> canceled) {
        canceled.accept(true);
    }

    @Override
    protected void onAllClick(InventoryClickEvent event, ItemStack currentItem, ClickType click, Consumer<Boolean> canceled) {
        canceled.accept(true);
    }

    @Override
    protected void onBottom(InventoryClickEvent event, ItemStack currentItem, ClickType click, Consumer<Boolean> canceled) {
        canceled.accept(true);
    }

    @Override
    protected void onUpdate(Inventory inventory) {
        MenuVarItem menuVarOffhandItem;
        MenuVarItem menuVarArmorItem;
        MenuSlots menuSlots;
        Player player = this.getPlayer();
        for (MenuItem menuItem : this.menu.getItems().values()) {
            menuSlots = menuItem.getSlots();
            ItemStack itemStack = menuItem.buildItem(player, new Placeholder[0]);
            Iterator iterator = menuSlots.getSlots().iterator();
            while (iterator.hasNext()) {
                int slot = (Integer)iterator.next();
                inventory.setItem(slot, itemStack);
            }
        }
        MenuVarItem menuVarItem = this.menu.getVarItems().get("inventoryItem");
        if (menuVarItem != null) {
            MenuSlots menuSlots2 = menuVarItem.getSlots();
            AtomicInteger index = new AtomicInteger();
            for (int i = 0; i < this.kit.getInventory().length; ++i) {
                ItemStack itemStack = this.kit.getInventory()[i];
                if (itemStack == null || itemStack.getType().equals((Object)Material.AIR)) continue;
                inventory.setItem(menuSlots2.getSlot(index.getAndIncrement()), this.kit.parsePlaceholders(player, itemStack));
            }
        }
        if ((menuVarArmorItem = this.menu.getVarItems().get("armorItem")) != null) {
            menuSlots = menuVarArmorItem.getSlots();
            AtomicInteger index = new AtomicInteger();
            for (int i = 0; i < this.kit.getArmor().length; ++i) {
                ItemStack itemStack = this.kit.getArmor()[i];
                if (itemStack == null || itemStack.getType().equals((Object)Material.AIR)) continue;
                inventory.setItem(menuSlots.getSlot(index.getAndIncrement()), this.kit.parsePlaceholders(player, itemStack));
            }
        }
        if ((menuVarOffhandItem = this.menu.getVarItems().get("offhandItem")) != null) {
            ItemStack itemStack = this.kit.getOffhand();
            if (itemStack == null || itemStack.getType().equals((Object)Material.AIR)) {
                return;
            }
            inventory.setItem(menuVarOffhandItem.getSlots().getSlot(0), this.kit.parsePlaceholders(player, itemStack));
        }
    }
}

