/*
 * Decompiled with CFR 0.152.
 */
package io.github.InsiderAnh.xPlayerKits.menus;

import io.github.InsiderAnh.xPlayerKits.PlayerKits;
import io.github.InsiderAnh.xPlayerKits.customize.Menu;
import io.github.InsiderAnh.xPlayerKits.customize.MenuItem;
import io.github.InsiderAnh.xPlayerKits.customize.MenuSlots;
import io.github.InsiderAnh.xPlayerKits.customize.MenuVarItem;
import io.github.InsiderAnh.xPlayerKits.customize.actions.MenuAction;
import io.github.InsiderAnh.xPlayerKits.data.KitData;
import io.github.InsiderAnh.xPlayerKits.data.PlayerKitData;
import io.github.InsiderAnh.xPlayerKits.inventory.AInventory;
import io.github.InsiderAnh.xPlayerKits.inventory.InventorySizes;
import io.github.InsiderAnh.xPlayerKits.kits.Kit;
import io.github.InsiderAnh.xPlayerKits.libs.nbtapi.NBTItem;
import io.github.InsiderAnh.xPlayerKits.menus.KitPreviewMenu;
import io.github.InsiderAnh.xPlayerKits.placeholders.Placeholder;
import io.github.InsiderAnh.xPlayerKits.utils.ItemUtils;
import io.github.InsiderAnh.xPlayerKits.utils.XPKUtils;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Consumer;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class KitsMenu
extends AInventory {
    private final PlayerKits playerKits = PlayerKits.getInstance();
    private final Menu menu = this.playerKits.getMenuManager().getMenu("kits");
    private final PlayerKitData playerKitData;
    private int page;

    public KitsMenu(Player player, PlayerKitData playerKitData, int page) {
        super(player, InventorySizes.GENERIC_9X6, PlayerKits.getInstance().getMenuManager().getTitle("kits", "Kits"));
        this.playerKitData = playerKitData;
        this.page = page;
        this.onUpdate(this.getInventory());
    }

    @Override
    protected void onClick(InventoryClickEvent event, ItemStack currentItem, ClickType click, Consumer<Boolean> canceled) {
        canceled.accept(true);
        Player player = this.getPlayer();
        NBTItem nbtItem = new NBTItem(currentItem);
        if (nbtItem.hasTag("xpk-menu:item")) {
            String menuItemId = nbtItem.getString("xpk-menu:item");
            MenuItem menuItem = this.menu.getItems().get(menuItemId);
            if (menuItem == null) {
                return;
            }
            for (MenuAction action : menuItem.getActions()) {
                if (action.getAction().equals("close_menu")) {
                    this.close();
                }
                if (action.getAction().equals("last_page")) {
                    ++this.page;
                    this.onUpdate(this.getInventory());
                }
                if (!action.getAction().equals("next_page")) continue;
                --this.page;
                this.onUpdate(this.getInventory());
            }
            this.playerKits.getExecutionManager().execute(player, menuItem.getExecutions(), new Placeholder("<player>", player.getName()));
        }
        if (nbtItem.hasTag("kit")) {
            Kit kit = this.playerKits.getKitManager().getKit(nbtItem.getString("kit"));
            if (kit == null) {
                return;
            }
            if (click.isRightClick() && kit.isPreview()) {
                new KitPreviewMenu(player, kit).open();
                return;
            }
            this.close();
            XPKUtils.claimKit(player, kit, this.playerKitData);
        }
    }

    @Override
    protected void onDrag(InventoryClickEvent event, ItemStack currentItem, ClickType click, Consumer<Boolean> canceled) {
        canceled.accept(true);
    }

    @Override
    protected void onAllClick(InventoryClickEvent event, ItemStack currentItem, ClickType click, Consumer<Boolean> canceled) {
        canceled.accept(true);
    }

    @Override
    protected void onBottom(InventoryClickEvent event, ItemStack currentItem, ClickType click, Consumer<Boolean> canceled) {
        canceled.accept(true);
    }

    @Override
    protected void onUpdate(Inventory inventory) {
        inventory.clear();
        Player player = this.getPlayer();
        for (MenuItem menuItem : this.menu.getItems().values()) {
            if (this.menu.getLastPageItems().contains(menuItem.getItemId()) && this.page <= 1 || this.menu.getNextPageItems().contains(menuItem.getItemId()) && this.page >= this.playerKits.getKitManager().getLastPage()) continue;
            MenuSlots menuSlots = menuItem.getSlots();
            ItemStack itemStack = menuItem.buildItem(player, new Placeholder[0]);
            Iterator<Object> iterator = menuSlots.getSlots().iterator();
            while (iterator.hasNext()) {
                int n = (Integer)iterator.next();
                inventory.setItem(n, itemStack);
            }
        }
        MenuVarItem menuVarItem = this.menu.getVarItems().get("kitSlots");
        if (menuVarItem != null) {
            MenuSlots menuSlots = menuVarItem.getSlots();
            int skipSlot = menuSlots.getPerPage() * (this.page - 1);
            Map<String, Kit> kits = this.playerKits.getKitManager().getSubMap(skipSlot, menuSlots.getPerPage());
            for (Map.Entry entry : kits.entrySet()) {
                Kit kitSlot = (Kit)entry.getValue();
                if (kitSlot == null) continue;
                this.buildAndSet(player, kitSlot.getPropertyInventory().getSlot(), kitSlot);
            }
        }
    }

    public void buildAndSet(Player player, int slot, Kit kit) {
        String state = this.getState(player, kit, this.playerKitData);
        ItemStack icon = new ItemUtils(kit.getIcons().get(state)).build();
        this.getInventory().setItem(slot, XPKUtils.applySimpleTag(icon, "kit", kit.getName()));
    }

    private String getState(Player player, Kit kit, PlayerKitData playerKitData) {
        if (kit.isNoHasRequirements(player)) {
            return "CANT_CLAIM";
        }
        if (!kit.getPermission().equals("none") && !player.hasPermission(kit.getPermission())) {
            return "NO_PERMISSION";
        }
        KitData kitData = playerKitData.getKitsData().get(kit.getName());
        if (kit.getPropertyTiming().isOneTime()) {
            if (kitData != null && kitData.isOneTime() && !player.hasPermission("xkits.onetime.bypass")) {
                return "ONE_TIME_CLAIMED";
            }
            return "ONE_TIME_REQUIREMENT";
        }
        if (kitData != null && kitData.getCountdown() > System.currentTimeMillis() && !player.hasPermission("xkits.countdown.bypass")) {
            return "COUNTDOWN";
        }
        return "CAN_CLAIM";
    }
}

