/*
 * Decompiled with CFR 0.152.
 */
package io.github.InsiderAnh.xPlayerKits.nms.v1_21_R2;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.InsiderAnh.xPlayerKits.api.PlayerKitsNMS;
import io.github.InsiderAnh.xPlayerKits.items.versions.CrossVersionPotionEffect;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import me.clip.placeholderapi.PlaceholderAPI;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.potion.PotionData;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.potion.PotionType;
import org.bukkit.profile.PlayerProfile;
import org.bukkit.profile.PlayerTextures;

public class PlayerKitsNMS_v1_21_R2
extends PlayerKitsNMS {
    private final Gson GSON = new Gson();
    private final Map<String, String> replacements = new HashMap<String, String>();
    private final MiniMessage miniMessage = MiniMessage.miniMessage();

    public PlayerKitsNMS_v1_21_R2() {
        this.replacements.put("0", "<black>");
        this.replacements.put("1", "<dark_blue>");
        this.replacements.put("2", "<dark_green>");
        this.replacements.put("3", "<dark_aqua>");
        this.replacements.put("4", "<dark_red>");
        this.replacements.put("5", "<dark_purple>");
        this.replacements.put("6", "<gold>");
        this.replacements.put("7", "<gray>");
        this.replacements.put("8", "<dark_gray>");
        this.replacements.put("9", "<blue>");
        this.replacements.put("a", "<green>");
        this.replacements.put("b", "<aqua>");
        this.replacements.put("c", "<red>");
        this.replacements.put("d", "<light_purple>");
        this.replacements.put("e", "<yellow>");
        this.replacements.put("f", "<white>");
        this.replacements.put("k", "<obfuscated>");
        this.replacements.put("l", "<bold>");
        this.replacements.put("m", "<strikethrough>");
        this.replacements.put("n", "<underlined>");
        this.replacements.put("o", "<italic>");
        this.replacements.put("r", "<reset>");
    }

    @Override
    public void deserializePotionMeta(PotionMeta potionMeta, Map<String, Object> data) {
        String potionDataStr;
        String[] parts;
        if (data.containsKey("potion_data") && (parts = (potionDataStr = (String)data.get("potion_data")).split(":")).length >= 3) {
            PotionType type = PotionType.valueOf((String)parts[0]);
            boolean extended = Boolean.parseBoolean(parts[1]);
            boolean upgraded = Boolean.parseBoolean(parts[2]);
            potionMeta.setBasePotionData(new PotionData(type, extended, upgraded));
        }
        if (!data.containsKey("potion_effects")) {
            return;
        }
        List effectList = (List)data.get("potion_effects");
        for (Object effectObj : effectList) {
            PotionEffect effect = this.parsePotionEffect(effectObj.toString());
            if (effect == null) continue;
            potionMeta.addCustomEffect(effect, true);
        }
    }

    private PotionEffect parsePotionEffect(String effectStr) {
        String[] parts = effectStr.split(":");
        if (parts.length < 3) {
            return null;
        }
        PotionEffectType type = CrossVersionPotionEffect.getEffect(parts[0]);
        if (type == null) {
            return null;
        }
        try {
            int amplifier = Integer.parseInt(parts[1]) - 1;
            int duration = Integer.parseInt(parts[2]);
            return new PotionEffect(type, duration, amplifier);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @Override
    public void serializePotionMeta(ItemStack itemStack, YamlConfiguration config, String path) {
        PotionMeta potionMeta = (PotionMeta)itemStack.getItemMeta();
        if (potionMeta == null) {
            return;
        }
        PotionData potionData = potionMeta.getBasePotionData();
        if (potionData != null) {
            PotionType type = potionData.getType();
            config.set(path + ".potion_data", (Object)(type.name() + ":" + potionData.isExtended() + ":" + potionData.isUpgraded()));
        }
        if (!potionMeta.hasCustomEffects()) {
            return;
        }
        ArrayList<String> effects = new ArrayList<String>();
        for (PotionEffect effect : potionMeta.getCustomEffects()) {
            String effectId = CrossVersionPotionEffect.getEffectId(effect.getType());
            effects.add(effectId + ":" + (effect.getAmplifier() + 1) + ":" + effect.getDuration());
        }
        config.set(path + ".potion_effects", effects);
    }

    @Override
    public void sendTitle(Player player, String title, String subtitle, int fadeIn, int stay, int fadeOut) {
        player.sendTitle(title, subtitle, fadeIn, stay, fadeOut);
    }

    @Override
    public void playSound(Location location, String sound, float volume, float pitch) {
        if (location == null || location.getWorld() == null) {
            return;
        }
        location.getWorld().playSound(location, sound, volume, pitch);
    }

    @Override
    public void sendActionBar(Player player, String message) {
        player.sendActionBar((Component)Component.text(message));
    }

    @Override
    public void sendMiniMessage(Player player, String message) {
        player.sendMessage(this.miniMessage.deserialize((Object)this.replaceColors(PlaceholderAPI.setPlaceholders((Player)player, (String)message))));
    }

    @Override
    public void setUnbreakable(ItemMeta itemMeta, boolean unbreakable) {
        if (itemMeta == null) {
            return;
        }
        itemMeta.setUnbreakable(unbreakable);
    }

    @Override
    public boolean isUnbreakable(ItemMeta itemMeta) {
        return itemMeta.isUnbreakable();
    }

    @Override
    public int getCustomModelData(ItemMeta itemMeta) {
        return itemMeta.getCustomModelData();
    }

    @Override
    public void setCustomModelData(ItemMeta itemMeta, int customModelData) {
        if (itemMeta == null) {
            return;
        }
        itemMeta.setCustomModelData(Integer.valueOf(customModelData));
    }

    @Override
    public void setGlowing(ItemMeta itemMeta, boolean glowing) {
        if (itemMeta == null) {
            return;
        }
        if (glowing) {
            itemMeta.setEnchantmentGlintOverride(Boolean.valueOf(true));
        } else if (itemMeta.hasEnchantmentGlintOverride()) {
            itemMeta.setEnchantmentGlintOverride(Boolean.valueOf(false));
        }
    }

    @Override
    public ItemStack value(ItemStack itemStack, String value) {
        if (value.isEmpty()) {
            return itemStack;
        }
        if (value.startsWith("https://textures.minecraft.net/texture/")) {
            return this.texture(itemStack, value);
        }
        SkullMeta headMeta = (SkullMeta)itemStack.getItemMeta();
        PlayerProfile profile = this.getPlayerProfile(value);
        headMeta.setOwnerProfile(profile);
        itemStack.setItemMeta((ItemMeta)headMeta);
        return itemStack;
    }

    @Override
    public ItemStack texture(ItemStack itemStack, String texture) {
        if (texture.isEmpty()) {
            return itemStack;
        }
        if (!texture.startsWith("https://textures.minecraft.net/texture/")) {
            texture = "https://textures.minecraft.net/texture/" + texture;
        }
        SkullMeta headMeta = (SkullMeta)itemStack.getItemMeta();
        PlayerProfile playerProfile = Bukkit.createPlayerProfile((UUID)UUID.randomUUID());
        PlayerTextures profileTextures = playerProfile.getTextures();
        try {
            profileTextures.setSkin(new URL(texture));
        }
        catch (MalformedURLException exception) {
            exception.printStackTrace();
        }
        playerProfile.setTextures(profileTextures);
        headMeta.setOwnerProfile(playerProfile);
        itemStack.setItemMeta((ItemMeta)headMeta);
        return itemStack;
    }

    private PlayerProfile getPlayerProfile(String base64Url) {
        PlayerProfile profile = Bukkit.createPlayerProfile((UUID)UUID.randomUUID());
        String decodedBase64 = this.decodeSkinUrl(base64Url);
        if (decodedBase64 == null) {
            return profile;
        }
        PlayerTextures textures = profile.getTextures();
        try {
            textures.setSkin(new URL(decodedBase64));
        }
        catch (MalformedURLException exception) {
            exception.printStackTrace();
        }
        profile.setTextures(textures);
        return profile;
    }

    public String decodeSkinUrl(String base64Texture) {
        String cleanBase64Texture = this.fixBase64Padding(base64Texture);
        try {
            String decoded = new String(Base64.getDecoder().decode(cleanBase64Texture));
            JsonElement root = (JsonElement)this.GSON.fromJson(decoded, JsonElement.class);
            if (!root.isJsonObject()) {
                System.out.println("decodeSkinUrl: decoded value is not a JSON object: " + decoded);
                return null;
            }
            JsonObject object = root.getAsJsonObject();
            JsonObject textures = object.getAsJsonObject("textures");
            if (textures == null) {
                return null;
            }
            JsonObject skin = textures.getAsJsonObject("SKIN");
            if (skin == null) {
                return null;
            }
            JsonElement url = skin.get("url");
            return url != null ? url.getAsString() : null;
        }
        catch (Exception e) {
            Bukkit.getLogger().info("Error: " + cleanBase64Texture + " track " + e.getMessage());
            return null;
        }
    }

    private String fixBase64Padding(String base64) {
        int mod = (base64 = base64.trim().replace("\n", "").replace("\r", "")).length() % 4;
        if (mod != 0) {
            base64 = base64 + this.repeat("=", 4 - mod);
        }
        return base64;
    }

    private String repeat(String str, int times) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < times; ++i) {
            sb.append(str);
        }
        return sb.toString();
    }

    private String replaceColors(String message) {
        StringBuilder result = new StringBuilder(message.length());
        for (int i = 0; i < message.length(); ++i) {
            char ch = message.charAt(i);
            if (ch == '&' || ch == '\u00a7') {
                if (i + 1 < message.length()) {
                    char code = Character.toLowerCase(message.charAt(i + 1));
                    String replacement = this.replacements.get(String.valueOf(code));
                    if (replacement != null) {
                        result.append(replacement);
                        ++i;
                        continue;
                    }
                    result.append(ch);
                    continue;
                }
                result.append(ch);
                continue;
            }
            result.append(ch);
        }
        return result.toString();
    }
}

