/*
 * Decompiled with CFR 0.152.
 */
package io.github.InsiderAnh.xPlayerKits.utils;

import io.github.InsiderAnh.xPlayerKits.placeholders.Placeholder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public final class LanguageUtils {
    public static String replacePlaceholders(String message, Placeholder ... placeholders) {
        StringBuilder messageBuilder = new StringBuilder(message);
        for (Placeholder placeholder : placeholders) {
            int index;
            String placeholderStr = placeholder.getPlaceholder();
            String value = placeholder.getValue();
            while ((index = messageBuilder.indexOf(placeholderStr)) != -1) {
                messageBuilder.replace(index, index + placeholderStr.length(), value);
            }
        }
        return messageBuilder.toString();
    }

    public static List<String> replacePlaceholders(List<String> messages, Placeholder ... placeholders) {
        if (messages == null || messages.isEmpty() || placeholders.length == 0) {
            return new ArrayList<String>(messages != null ? messages : Collections.emptyList());
        }
        HashMap<String, String> placeholderMap = new HashMap<String, String>();
        for (Placeholder placeholder : placeholders) {
            String key = placeholder.getPlaceholder();
            String value = placeholder.getValue();
            if (key == null || value == null) continue;
            placeholderMap.put(key, value);
        }
        ArrayList<String> result = new ArrayList<String>(messages.size());
        for (String message : messages) {
            result.add(LanguageUtils.replacePlaceholdersWithMap(message, placeholderMap));
        }
        return result;
    }

    private static String replacePlaceholdersWithMap(String message, Map<String, String> placeholderMap) {
        if (message == null || message.isEmpty() || placeholderMap.isEmpty()) {
            return message;
        }
        StringBuilder messageBuilder = new StringBuilder(message);
        for (Map.Entry<String, String> entry : placeholderMap.entrySet()) {
            String placeholderStr = entry.getKey();
            String value = entry.getValue();
            int index = 0;
            while ((index = messageBuilder.indexOf(placeholderStr, index)) != -1) {
                messageBuilder.replace(index, index + placeholderStr.length(), value);
                index += value.length();
            }
        }
        return messageBuilder.toString();
    }

    @Generated
    private LanguageUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

