/*
 * Decompiled with CFR 0.152.
 */
package com.cjcrafter.foliascheduler.bukkit;

import com.cjcrafter.foliascheduler.AsyncSchedulerImplementation;
import com.cjcrafter.foliascheduler.TaskImplementation;
import com.cjcrafter.foliascheduler.bukkit.BukkitTask;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public class BukkitAsyncScheduler
implements AsyncSchedulerImplementation {
    @NotNull
    private final Plugin plugin;

    public BukkitAsyncScheduler(@NotNull Plugin plugin) {
        this.plugin = plugin;
    }

    @NotNull
    private <T> BukkitRunnable buildBukkitRunnable(final @NotNull Function<TaskImplementation<T>, T> function, final @NotNull BukkitTask<T> taskImplementation) {
        return new BukkitRunnable(){

            public void run() {
                taskImplementation.setCallback(function.apply(taskImplementation));
                taskImplementation.asFuture().complete(taskImplementation);
            }
        };
    }

    @Override
    @NotNull
    public <T> TaskImplementation<T> runNow(@NotNull Function<TaskImplementation<T>, T> function) {
        BukkitTask taskImplementation = new BukkitTask(this.plugin, false);
        BukkitRunnable runnable = this.buildBukkitRunnable(function, taskImplementation);
        taskImplementation.setScheduledTask(runnable.runTaskAsynchronously(this.plugin));
        return taskImplementation;
    }

    @Override
    @NotNull
    public <T> TaskImplementation<T> runDelayed(@NotNull Function<TaskImplementation<T>, T> function, long delay, @NotNull TimeUnit unit) {
        BukkitTask taskImplementation = new BukkitTask(this.plugin, false);
        BukkitRunnable runnable = this.buildBukkitRunnable(function, taskImplementation);
        taskImplementation.setScheduledTask(runnable.runTaskLaterAsynchronously(this.plugin, unit.toSeconds(delay) * 20L));
        return taskImplementation;
    }

    @Override
    @NotNull
    public <T> TaskImplementation<T> runAtFixedRate(@NotNull Function<TaskImplementation<T>, T> function, long delay, long period, @NotNull TimeUnit unit) {
        BukkitTask taskImplementation = new BukkitTask(this.plugin, true);
        BukkitRunnable runnable = this.buildBukkitRunnable(function, taskImplementation);
        taskImplementation.setScheduledTask(runnable.runTaskTimerAsynchronously(this.plugin, unit.toSeconds(delay) * 20L, unit.toSeconds(period) * 20L));
        return taskImplementation;
    }

    @Override
    public void cancelTasks() {
        this.plugin.getServer().getScheduler().cancelTasks(this.plugin);
    }
}

