/*
 * Decompiled with CFR 0.152.
 */
package com.cjcrafter.foliascheduler.folia;

import com.cjcrafter.foliascheduler.TaskImplementation;
import io.papermc.paper.threadedregions.scheduler.ScheduledTask;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class FoliaTask<T>
implements TaskImplementation<T> {
    private final ReentrantLock lock = new ReentrantLock();
    private final AtomicReference<ScheduledTask> scheduledTaskRef = new AtomicReference();
    private final CompletableFuture<TaskImplementation<T>> future = new CompletableFuture();
    private T callback;

    @ApiStatus.Internal
    public FoliaTask() {
    }

    @ApiStatus.Internal
    public void setScheduledTask(@NotNull ScheduledTask task) {
        this.scheduledTaskRef.set(task);
    }

    @Override
    @NotNull
    public Plugin getOwningPlugin() {
        return this.scheduledTaskRef.get().getOwningPlugin();
    }

    @Override
    public void cancel() {
        this.scheduledTaskRef.get().cancel();
    }

    @Override
    public boolean isCancelled() {
        return this.scheduledTaskRef.get().isCancelled();
    }

    @Override
    public boolean isRunning() {
        ScheduledTask.ExecutionState state = this.scheduledTaskRef.get().getExecutionState();
        return state == ScheduledTask.ExecutionState.RUNNING || state == ScheduledTask.ExecutionState.CANCELLED_RUNNING;
    }

    @Override
    public boolean isRepeatingTask() {
        return this.scheduledTaskRef.get().isRepeatingTask();
    }

    @Override
    @Nullable
    public T getCallback() {
        this.lock.lock();
        try {
            T t = this.callback;
            return t;
        }
        finally {
            this.lock.unlock();
        }
    }

    @ApiStatus.Internal
    public void setCallback(T callback) {
        this.lock.lock();
        try {
            this.callback = callback;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    @NotNull
    public CompletableFuture<TaskImplementation<T>> asFuture() {
        return this.future;
    }
}

