/*
 * Decompiled with CFR 0.152.
 */
package io.github.InsiderAnh.xPlayerKits;

import com.cjcrafter.foliascheduler.util.MinecraftVersions;
import com.cjcrafter.foliascheduler.util.ServerVersions;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import io.github.InsiderAnh.xPlayerKits.api.ColorUtils;
import io.github.InsiderAnh.xPlayerKits.api.PlayerKitsNMS;
import io.github.InsiderAnh.xPlayerKits.bstats.MetricsLite;
import io.github.InsiderAnh.xPlayerKits.commands.XKitsCommands;
import io.github.InsiderAnh.xPlayerKits.config.InsiderConfig;
import io.github.InsiderAnh.xPlayerKits.database.Database;
import io.github.InsiderAnh.xPlayerKits.database.MySQLDatabase;
import io.github.InsiderAnh.xPlayerKits.database.SQLiteDatabase;
import io.github.InsiderAnh.xPlayerKits.enums.MinecraftVersion;
import io.github.InsiderAnh.xPlayerKits.hooks.StellarTaskHook;
import io.github.InsiderAnh.xPlayerKits.hooks.tasks.BukkitTaskHook;
import io.github.InsiderAnh.xPlayerKits.hooks.tasks.FoliaTaskHook;
import io.github.InsiderAnh.xPlayerKits.listeners.PlayerListener;
import io.github.InsiderAnh.xPlayerKits.managers.ConfigManager;
import io.github.InsiderAnh.xPlayerKits.managers.ExecutionManager;
import io.github.InsiderAnh.xPlayerKits.managers.KitManager;
import io.github.InsiderAnh.xPlayerKits.managers.MenuManager;
import io.github.InsiderAnh.xPlayerKits.placeholders.PlayerKitsPlaceholders;
import io.github.InsiderAnh.xPlayerKits.utils.UpdateChecker;
import io.github.InsiderAnh.xPlayerKits.utils.XPKUtils;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class PlayerKits
extends JavaPlugin {
    private static PlayerKits instance;
    private final ListeningExecutorService executor;
    private final KitManager kitManager;
    private final ConfigManager configManager;
    private final MenuManager menuManager;
    private final ExecutionManager executionManager;
    private InsiderConfig lang;
    private Database database;
    private PlayerKitsNMS playerKitsNMS;
    private ColorUtils colorUtils;
    private MetricsLite bstats;
    private String version;
    private MinecraftVersion localVersion;
    private String completer;
    private UpdateChecker updateChecker;

    public PlayerKits() {
        instance = this;
        this.executor = MoreExecutors.listeningDecorator((ExecutorService)new ThreadPoolExecutor(2, 2, 0L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(1024)));
        this.executionManager = new ExecutionManager();
        this.kitManager = new KitManager();
        this.configManager = new ConfigManager();
        this.menuManager = new MenuManager();
    }

    public void onEnable() {
        this.getConfig().options().copyDefaults(true);
        this.saveConfig();
        this.lang = new InsiderConfig(this, "lang", true, false);
        String databaseType = this.getConfig().getString("databases.databaseType", "h2");
        this.database = databaseType.equalsIgnoreCase("mysql") ? new MySQLDatabase() : new SQLiteDatabase();
        this.database.connect();
        this.configManager.load();
        this.menuManager.load();
        this.kitManager.load();
        XKitsCommands xkitsCommands = new XKitsCommands();
        this.getCommand("xkits").setExecutor((CommandExecutor)xkitsCommands);
        if (this.configManager.isKitsCMDEnabled()) {
            XPKUtils.registerCommandDynamic("kits", xkitsCommands);
        }
        if (this.configManager.isShortKit()) {
            XPKUtils.registerCommandDynamic("kit", xkitsCommands);
        }
        if (this.getServer().getPluginManager().isPluginEnabled("PlaceholderAPI")) {
            new PlayerKitsPlaceholders().register();
        }
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerListener(), (Plugin)this);
        this.bstats = new MetricsLite((Plugin)this, 26821);
        this.updateChecker = new UpdateChecker();
    }

    public void onDisable() {
        this.database.close();
        this.bstats.shutdown();
    }

    public void reload() {
        boolean lastEnabled = this.getConfigManager().isKitsCMDEnabled();
        boolean lastShortKit = this.getConfigManager().isShortKit();
        this.reloadConfig();
        this.lang.reload();
        this.configManager.load();
        this.menuManager.load();
        this.kitManager.load();
        if (!lastEnabled && this.configManager.isKitsCMDEnabled()) {
            XPKUtils.registerCommandDynamic("kits", new XKitsCommands());
        }
        if (!lastShortKit && this.configManager.isShortKit()) {
            XPKUtils.registerCommandDynamic("kit", new XKitsCommands());
        }
    }

    public void sendDebugMessage(String ... messages) {
        for (String message : messages) {
            this.getLogger().info("\u00a76[xPlayerKits] \u00a7f" + message);
        }
    }

    public StellarTaskHook getStellarTaskHook(Runnable runnable) {
        if (MinecraftVersions.WILD_UPDATE.isAtLeast() && ServerVersions.isFolia()) {
            return new FoliaTaskHook(runnable);
        }
        return new BukkitTaskHook(runnable);
    }

    public PlayerKitsNMS getPlayerKitsNMS() {
        if (this.playerKitsNMS == null) {
            this.loadNMS();
        }
        return this.playerKitsNMS;
    }

    public ColorUtils getColorUtils() {
        if (this.colorUtils == null) {
            this.loadNMS();
        }
        return this.colorUtils;
    }

    public void loadNMS() {
        String cbPackage = Bukkit.getServer().getClass().getPackage().getName();
        String detectedVersion = cbPackage.substring(cbPackage.lastIndexOf(46) + 1);
        if (!detectedVersion.startsWith("v")) {
            detectedVersion = Bukkit.getServer().getBukkitVersion();
        }
        this.version = detectedVersion;
        this.getLogger().info("Detected Minecraft version: " + this.version);
        this.localVersion = MinecraftVersion.get(this.version);
        if (this.localVersion == null) {
            Bukkit.getLogger().warning("[XPlayerKits] No found Minecraft version " + this.version + ". If you want to support this version, contact InsiderAnh.");
            Bukkit.getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        this.completer = this.localVersion.equals((Object)MinecraftVersion.v1_8) ? "v1_8_R3" : (this.localVersion.equals((Object)MinecraftVersion.v1_9) ? "v1_9_R4" : (this.localVersion.equals((Object)MinecraftVersion.v1_12) ? "v1_12_R2" : (this.localVersion.equals((Object)MinecraftVersion.v1_13) ? "v1_13_R2" : (this.localVersion.equals((Object)MinecraftVersion.v1_16) ? "v1_16_R5" : (this.localVersion.equals((Object)MinecraftVersion.v1_17) ? "v1_17_R1" : this.localVersion.name())))));
        this.getLogger().info("Loaded " + this.completer + " version.");
        this.playerKitsNMS = Class.forName("io.github.InsiderAnh.xPlayerKits.nms." + this.completer + ".PlayerKitsNMS_" + this.completer).asSubclass(PlayerKitsNMS.class).getConstructor(new Class[0]).newInstance(new Object[0]);
        this.colorUtils = Class.forName("io.github.InsiderAnh.xPlayerKits.nms." + this.completer + ".ColorUtils_" + this.completer).asSubclass(ColorUtils.class).getConstructor(new Class[0]).newInstance(new Object[0]);
    }

    @Generated
    public ListeningExecutorService getExecutor() {
        return this.executor;
    }

    @Generated
    public KitManager getKitManager() {
        return this.kitManager;
    }

    @Generated
    public ConfigManager getConfigManager() {
        return this.configManager;
    }

    @Generated
    public MenuManager getMenuManager() {
        return this.menuManager;
    }

    @Generated
    public ExecutionManager getExecutionManager() {
        return this.executionManager;
    }

    @Generated
    public InsiderConfig getLang() {
        return this.lang;
    }

    @Generated
    public Database getDatabase() {
        return this.database;
    }

    @Generated
    public MetricsLite getBstats() {
        return this.bstats;
    }

    @Generated
    public String getVersion() {
        return this.version;
    }

    @Generated
    public MinecraftVersion getLocalVersion() {
        return this.localVersion;
    }

    @Generated
    public String getCompleter() {
        return this.completer;
    }

    @Generated
    public UpdateChecker getUpdateChecker() {
        return this.updateChecker;
    }

    @Generated
    public static PlayerKits getInstance() {
        return instance;
    }
}

