/*
 * Decompiled with CFR 0.152.
 */
package io.github.InsiderAnh.xPlayerKits.customize;

import io.github.InsiderAnh.xPlayerKits.customize.MenuItem;
import io.github.InsiderAnh.xPlayerKits.customize.MenuVarItem;
import io.github.InsiderAnh.xPlayerKits.customize.actions.MenuAction;
import io.github.InsiderAnh.xPlayerKits.inventory.InventorySizes;
import java.util.HashMap;
import java.util.HashSet;
import lombok.Generated;
import org.bukkit.configuration.file.YamlConfiguration;

public class Menu {
    private final String menuId;
    private final InventorySizes rows;
    private final String title;
    private final HashMap<String, MenuItem> items = new HashMap();
    private final HashMap<String, MenuVarItem> varItems = new HashMap();
    private final HashSet<String> lastPageItems = new HashSet();
    private final HashSet<String> nextPageItems = new HashSet();

    public Menu(YamlConfiguration configuration, String menuId) {
        this.menuId = menuId;
        this.rows = InventorySizes.fromInv(configuration.getInt("rows"));
        this.title = configuration.getString("title");
        if (configuration.isSet("items")) {
            for (String itemId : configuration.getConfigurationSection("items").getKeys(false)) {
                MenuItem menuItem = new MenuItem(configuration, itemId, "items." + itemId);
                this.items.put(itemId, menuItem);
                for (MenuAction action : menuItem.getActions()) {
                    if (action == null || action.getAction() == null) continue;
                    if (action.getAction().equals("last_page")) {
                        this.lastPageItems.add(itemId);
                    }
                    if (!action.getAction().equals("next_page")) continue;
                    this.nextPageItems.add(itemId);
                }
            }
        }
        if (configuration.isSet("varItems")) {
            for (String itemId : configuration.getConfigurationSection("varItems").getKeys(false)) {
                MenuVarItem menuVarItem = new MenuVarItem(configuration, "varItems." + itemId);
                this.varItems.put(itemId, menuVarItem);
            }
        }
    }

    @Generated
    public String getMenuId() {
        return this.menuId;
    }

    @Generated
    public InventorySizes getRows() {
        return this.rows;
    }

    @Generated
    public String getTitle() {
        return this.title;
    }

    @Generated
    public HashMap<String, MenuItem> getItems() {
        return this.items;
    }

    @Generated
    public HashMap<String, MenuVarItem> getVarItems() {
        return this.varItems;
    }

    @Generated
    public HashSet<String> getLastPageItems() {
        return this.lastPageItems;
    }

    @Generated
    public HashSet<String> getNextPageItems() {
        return this.nextPageItems;
    }
}

