/*
 * Decompiled with CFR 0.152.
 */
package io.github.InsiderAnh.xPlayerKits.customize;

import io.github.InsiderAnh.xPlayerKits.PlayerKits;
import io.github.InsiderAnh.xPlayerKits.api.ColorUtils;
import io.github.InsiderAnh.xPlayerKits.customize.MenuSlots;
import io.github.InsiderAnh.xPlayerKits.customize.actions.MenuAction;
import io.github.InsiderAnh.xPlayerKits.executions.Execution;
import io.github.InsiderAnh.xPlayerKits.placeholders.Placeholder;
import io.github.InsiderAnh.xPlayerKits.utils.LanguageUtils;
import io.github.InsiderAnh.xPlayerKits.utils.XPKUtils;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import lombok.Generated;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class MenuItem {
    private final PlayerKits plugin = PlayerKits.getInstance();
    private final String material;
    private final short data;
    private final int amount;
    private final int customModelData;
    private final boolean glowing;
    private final String displayName;
    private final List<String> lore;
    private final MenuSlots slots;
    private final LinkedList<MenuAction> actions = new LinkedList();
    private final LinkedList<Execution> executions = new LinkedList();
    private final String itemId;

    public MenuItem(YamlConfiguration configuration, String itemId, String path) {
        this.itemId = itemId;
        this.material = configuration.getString(path + ".material");
        this.amount = configuration.getInt(path + ".amount");
        this.data = (short)configuration.getInt(path + ".data", 0);
        this.customModelData = configuration.getInt(path + ".custom-model-data");
        this.glowing = configuration.getBoolean(path + ".glowing");
        this.displayName = configuration.getString(path + ".display-name", "");
        this.lore = configuration.isSet(path + ".lore") ? configuration.getStringList(path + ".lore") : Collections.emptyList();
        this.slots = new MenuSlots(configuration, path + ".slots");
        if (configuration.isSet(path + ".actions")) {
            for (String action : configuration.getStringList(path + ".actions")) {
                if (action.equals("close_menu") || action.equals("last_page") || action.equals("next_page")) {
                    this.actions.add(MenuItem.getAction(action));
                    continue;
                }
                this.executions.add(PlayerKits.getInstance().getExecutionManager().getExecution(action));
            }
        }
    }

    public static MenuAction getAction(String action) {
        switch (action) {
            case "close_menu": {
                return new MenuAction(action);
            }
            case "last_page": {
                return new MenuAction(action);
            }
            case "next_page": {
                return new MenuAction(action);
            }
        }
        return null;
    }

    public String toString() {
        return "MenuItem{material='" + this.material + '\'' + ", amount=" + this.amount + ", customModelData=" + this.customModelData + ", glowing=" + this.glowing + ", displayName='" + this.displayName + '\'' + ", lore=" + this.lore + ", slots=" + this.slots + '}';
    }

    public ItemStack buildItem(Player player, Placeholder ... placeholders) {
        ColorUtils colorUtils = PlayerKits.getInstance().getColorUtils();
        ItemStack itemStack = XPKUtils.parseItemStack(player, this.material, this.amount, this.data);
        if (this.amount > 0) {
            itemStack.setAmount(this.amount);
        }
        ItemMeta itemMeta = itemStack.getItemMeta();
        if (this.customModelData != 0) {
            this.plugin.getPlayerKitsNMS().setCustomModelData(itemMeta, this.customModelData);
        }
        if (this.glowing) {
            this.plugin.getPlayerKitsNMS().setGlowing(itemMeta, true);
        }
        if (this.displayName != null) {
            itemMeta.setDisplayName(LanguageUtils.replacePlaceholders(colorUtils.color(this.displayName), placeholders));
        }
        if (!this.lore.isEmpty()) {
            itemMeta.setLore(LanguageUtils.replacePlaceholders(colorUtils.color(this.lore), placeholders));
        }
        itemStack.setItemMeta(itemMeta);
        return XPKUtils.applySimpleTag(itemStack, "xpk-menu:item", this.itemId);
    }

    @Generated
    public PlayerKits getPlugin() {
        return this.plugin;
    }

    @Generated
    public String getMaterial() {
        return this.material;
    }

    @Generated
    public short getData() {
        return this.data;
    }

    @Generated
    public int getAmount() {
        return this.amount;
    }

    @Generated
    public int getCustomModelData() {
        return this.customModelData;
    }

    @Generated
    public boolean isGlowing() {
        return this.glowing;
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public List<String> getLore() {
        return this.lore;
    }

    @Generated
    public MenuSlots getSlots() {
        return this.slots;
    }

    @Generated
    public LinkedList<MenuAction> getActions() {
        return this.actions;
    }

    @Generated
    public LinkedList<Execution> getExecutions() {
        return this.executions;
    }

    @Generated
    public String getItemId() {
        return this.itemId;
    }
}

