/*
 * Decompiled with CFR 0.152.
 */
package io.github.InsiderAnh.xPlayerKits.database;

import io.github.InsiderAnh.xPlayerKits.PlayerKits;
import io.github.InsiderAnh.xPlayerKits.data.PlayerKitData;
import io.github.InsiderAnh.xPlayerKits.database.Database;
import io.github.InsiderAnh.xPlayerKits.utils.XPKUtils;
import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.jetbrains.annotations.Nullable;

public class SQLiteDatabase
extends Database {
    private final PlayerKits playerKits = PlayerKits.getInstance();
    private Connection connection;

    @Override
    public void connect() {
        try {
            File dbFile = new File(this.playerKits.getDataFolder(), this.playerKits.getConfig().getString("databases.h2.database") + ".db");
            if (!dbFile.exists()) {
                dbFile.createNewFile();
            }
            Class.forName("org.sqlite.JDBC");
            try {
                this.connection = DriverManager.getConnection("jdbc:sqlite:" + dbFile);
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            try {
                Connection connection = this.getConnection();
                try (Statement statement = connection.createStatement();){
                    statement.executeUpdate("CREATE TABLE IF NOT EXISTS player_kits (uuid VARCHAR(36) PRIMARY KEY,name VARCHAR(36),data TEXT)");
                    this.close(null, statement, null);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                this.close(connection, null, null);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.playerKits.getLogger().warning("Error on connect to SQLite database.");
                return;
            }
            this.playerKits.getLogger().info("Connected to SQLite database correctly.");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.playerKits.getLogger().warning("Error on connect to SQLite database.");
        }
    }

    @Override
    public void close() {
        try {
            this.connection.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    @Override
    public CompletableFuture<PlayerKitData> getPlayerDataByName(String name) {
        CompletableFuture<PlayerKitData> completableFuture = new CompletableFuture<PlayerKitData>();
        this.playerKits.getExecutor().execute(() -> {
            try {
                Connection connection = this.getConnection();
                String data = this.getData(connection, "name", name);
                if (data != null) {
                    PlayerKitData playerKitData = (PlayerKitData)XPKUtils.getGson().fromJson(data, PlayerKitData.class);
                    completableFuture.complete(playerKitData);
                } else {
                    completableFuture.complete(null);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                completableFuture.complete(null);
            }
        });
        return completableFuture;
    }

    @Override
    public CompletableFuture<PlayerKitData> getPlayerData(UUID uuid, String name) {
        CompletableFuture<PlayerKitData> completableFuture = new CompletableFuture<PlayerKitData>();
        this.playerKits.getExecutor().execute(() -> {
            try {
                completableFuture.complete(this.getSyncPlayerData(uuid, name));
            }
            catch (Exception exception) {
                exception.printStackTrace();
                completableFuture.complete(null);
            }
        });
        return completableFuture;
    }

    @Override
    public CompletableFuture<Boolean> loadPlayerData(UUID uuid, String name) {
        CompletableFuture<Boolean> completableFuture = new CompletableFuture<Boolean>();
        this.playerKits.getExecutor().execute(() -> {
            try {
                PlayerKitData playerKitData;
                boolean firstJoin;
                Connection connection = this.getConnection();
                String data = this.getData(connection, "uuid", uuid.toString());
                if (data != null) {
                    firstJoin = false;
                    playerKitData = (PlayerKitData)XPKUtils.getGson().fromJson(data, PlayerKitData.class);
                } else {
                    firstJoin = true;
                    playerKitData = new PlayerKitData(uuid, name);
                    this.insertData(connection, uuid.toString(), name, XPKUtils.getGson().toJson((Object)playerKitData, PlayerKitData.class));
                }
                this.cachedPlayerKits.put(uuid, playerKitData);
                completableFuture.complete(firstJoin);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                completableFuture.complete(null);
            }
        });
        return completableFuture;
    }

    @Override
    public PlayerKitData getSyncPlayerData(UUID uuid, String name) {
        PlayerKitData playerKitData;
        Connection connection = this.getConnection();
        String data = this.getData(connection, "uuid", uuid.toString());
        if (data != null) {
            playerKitData = (PlayerKitData)XPKUtils.getGson().fromJson(data, PlayerKitData.class);
        } else {
            playerKitData = new PlayerKitData(uuid, name);
            this.insertData(connection, uuid.toString(), name, XPKUtils.getGson().toJson((Object)playerKitData, PlayerKitData.class));
        }
        this.cachedPlayerKits.put(uuid, playerKitData);
        return playerKitData;
    }

    @Override
    public void updatePlayerData(UUID uuid) {
        PlayerKitData playerKitData = (PlayerKitData)this.cachedPlayerKits.get(uuid);
        if (playerKitData == null) {
            return;
        }
        try {
            Connection connection = this.getConnection();
            this.updateData(connection, uuid.toString(), XPKUtils.getGson().toJson((Object)playerKitData, PlayerKitData.class));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public Connection getConnection() {
        return this.connection;
    }

    private void insertData(Connection connection, String uuid, String name, String data) {
        try {
            String insertSQL = "INSERT INTO player_kits (uuid, name, data) VALUES (?, ?, ?)";
            try (PreparedStatement preparedStatement = connection.prepareStatement(insertSQL);){
                preparedStatement.setString(1, uuid);
                preparedStatement.setString(2, name);
                preparedStatement.setString(3, data);
                preparedStatement.executeUpdate();
                this.close(connection, preparedStatement, null);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private String getData(Connection connection, String key, String uuid) {
        try {
            String selectSQL = "SELECT data FROM player_kits WHERE " + key + " = ?";
            try (PreparedStatement preparedStatement = connection.prepareStatement(selectSQL);){
                String string;
                block18: {
                    ResultSet resultSet;
                    block16: {
                        String string2;
                        block17: {
                            preparedStatement.setString(1, uuid);
                            resultSet = preparedStatement.executeQuery();
                            try {
                                if (!resultSet.next()) break block16;
                                String data = resultSet.getString("data");
                                this.close(connection, preparedStatement, resultSet);
                                string2 = data;
                                if (resultSet == null) break block17;
                            }
                            catch (Throwable throwable) {
                                if (resultSet != null) {
                                    try {
                                        resultSet.close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                }
                                throw throwable;
                            }
                            resultSet.close();
                        }
                        return string2;
                    }
                    string = null;
                    if (resultSet == null) break block18;
                    resultSet.close();
                }
                return string;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private void updateData(Connection connection, String uuid, String updateData) {
        try {
            String updateSQL = "UPDATE player_kits SET data = ? WHERE uuid = ?";
            try (PreparedStatement preparedStatement = connection.prepareStatement(updateSQL);){
                preparedStatement.setString(1, updateData);
                preparedStatement.setString(2, uuid);
                preparedStatement.executeUpdate();
                this.close(connection, preparedStatement, null);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void close(@Nullable Connection connection, @Nullable Statement preparedStatement, @Nullable ResultSet resultSet) {
        try {
            if (preparedStatement != null) {
                preparedStatement.close();
            }
            if (resultSet != null) {
                resultSet.close();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

