/*
 * Decompiled with CFR 0.152.
 */
package io.github.InsiderAnh.xPlayerKits.managers;

import io.github.InsiderAnh.xPlayerKits.PlayerKits;
import io.github.InsiderAnh.xPlayerKits.data.KitData;
import io.github.InsiderAnh.xPlayerKits.data.PlayerKitData;
import io.github.InsiderAnh.xPlayerKits.kits.Kit;
import io.github.InsiderAnh.xPlayerKits.libs.hikaricp.HikariConfig;
import io.github.InsiderAnh.xPlayerKits.libs.hikaricp.HikariDataSource;
import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class MigratorManager {
    private final PlayerKits playerKits = PlayerKits.getInstance();

    public void migrateKitsFromPlayerKits2(Player player) {
        File playerKitsDirectory = new File(Bukkit.getWorldContainer(), "plugins/PlayerKits2/kits");
        if (!playerKitsDirectory.exists()) {
            this.playerKits.getLogger().info("The PlayerKits2 folder does\u00b4t exist, (plugins/PlayerKits2/kits), please put kits files in this folder. " + playerKitsDirectory.getAbsolutePath());
            return;
        }
        if (!playerKitsDirectory.isDirectory()) {
            this.playerKits.getLogger().info("You don\u00b4t have kits yml in PlayerKits2 folder, (plugins/PlayerKits2/kits), please put kits files in this folder. " + playerKitsDirectory.getAbsolutePath());
            return;
        }
        ArrayList<File> kitFiles = new ArrayList<File>();
        Collections.addAll(kitFiles, playerKitsDirectory.listFiles());
        if (!kitFiles.isEmpty()) {
            this.migrateKitFromPlayerKits2(player, kitFiles);
        }
    }

    public void migrateKitFromPlayerKits2(final Player player, final ArrayList<File> kitFiles) {
        final File file = kitFiles.remove(0);
        new BukkitRunnable(){

            public void run() {
                YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
                String name = file.getName().replace(".yml", "");
                Kit kit = new Kit(name, 10);
                player.getInventory().clear();
                player.getInventory().setArmorContents(null);
                Bukkit.getScheduler().runTaskLater((Plugin)MigratorManager.this.playerKits, () -> Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)("playerkits give " + name + " " + player.getName())), 2L);
                Bukkit.getScheduler().runTaskLater((Plugin)MigratorManager.this.playerKits, () -> this.lambda$run$1(kit, player, (FileConfiguration)config, name, kitFiles), 4L);
            }

            private /* synthetic */ void lambda$run$1(Kit kit, Player player2, FileConfiguration config, String name, ArrayList kitFiles2) {
                kit.setInventory(player2.getInventory().getContents());
                kit.setArmor(player2.getInventory().getArmorContents());
                kit.getPropertyTiming().setOneTime(config.getBoolean("one_time"));
                kit.getPropertyInventory().setAutoArmor(config.getBoolean("auto_armor"));
                kit.getPropertyTiming().setCountdown(config.getInt("cooldown"));
                if (config.getBoolean("permission_required")) {
                    kit.setPermission("playerkits.kit." + name);
                }
                kit.setPreview(true);
                kit.save();
                MigratorManager.this.playerKits.getKitManager().addKit(kit);
                player2.sendMessage("\u00a7aMigrated correctly \u00a7e" + kit.getName() + "\u00a7a.");
                if (!kitFiles2.isEmpty()) {
                    MigratorManager.this.migrateKitFromPlayerKits2(player2, kitFiles2);
                }
            }
        }.runTaskLater((Plugin)this.playerKits, 5L);
    }

    public void migrateFromPlayerKits2MySQL() {
        long startAt = System.currentTimeMillis();
        this.playerKits.getLogger().info("Starting migration from PlayerKits2.");
        this.playerKits.getExecutor().execute(() -> {
            HikariConfig config = new HikariConfig();
            config.setJdbcUrl("jdbc:mysql://" + this.playerKits.getConfig().getString("migrate.mysql.host") + ":" + this.playerKits.getConfig().getInt("migrate.mysql.port") + "/" + this.playerKits.getConfig().getString("migrate.mysql.database"));
            config.setUsername(this.playerKits.getConfig().getString("migrate.mysql.user"));
            config.setPassword(this.playerKits.getConfig().getString("migrate.mysql.password"));
            config.addDataSourceProperty("cachePrepStmts", "true");
            config.addDataSourceProperty("prepStmtCacheSize", "250");
            config.addDataSourceProperty("prepStmtCacheSqlLimit", "2048");
            config.addDataSourceProperty("autoReconnect", "true");
            config.addDataSourceProperty("leakDetectionThreshold", "true");
            config.addDataSourceProperty("verifyServerCertificate", "false");
            config.addDataSourceProperty("useSSL", "false");
            config.setConnectionTimeout(5000L);
            HikariDataSource dataSource = new HikariDataSource(config);
            try (Connection connection = dataSource.getConnection();){
                PreparedStatement statement = connection.prepareStatement("SELECT playerkits_players.UUID, playerkits_players.PLAYER_NAME, playerkits_players_kits.NAME, playerkits_players_kits.COOLDOWN, playerkits_players_kits.ONE_TIME, playerkits_players_kits.BOUGHT FROM playerkits_players LEFT JOIN playerkits_players_kits ON playerkits_players.UUID = playerkits_players_kits.UUID");
                ResultSet result = statement.executeQuery();
                while (result.next()) {
                    String uuid = result.getString("UUID");
                    String playerName = result.getString("PLAYER_NAME");
                    String kitName = result.getString("NAME");
                    long countdown = result.getLong("COOLDOWN");
                    boolean oneTime = result.getBoolean("ONE_TIME");
                    boolean bought = result.getBoolean("BOUGHT");
                    PlayerKitData playerKitData = this.playerKits.getDatabase().getSyncPlayerData(UUID.fromString(uuid), playerName);
                    playerKitData.getKitsData().put(kitName, new KitData(kitName, countdown, oneTime, bought));
                    this.playerKits.getDatabase().updatePlayerData(playerKitData.getUuid());
                }
                this.playerKits.getLogger().info("Successfully migrated all player files in " + (System.currentTimeMillis() - startAt) + "ms.");
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        });
    }

    public void migrateFromPlayerKits2Yaml() {
        long startAt = System.currentTimeMillis();
        this.playerKits.getLogger().info("Starting migration from PlayerKits2.");
        this.playerKits.getExecutor().execute(() -> {
            File playerKitsDirectory = new File(this.playerKits.getServer().getWorldContainer(), "plugins/PlayerKits2/players");
            if (!playerKitsDirectory.exists() || !playerKitsDirectory.isDirectory()) {
                this.playerKits.getLogger().info("You don\u00b4t have data yml in this plugin.");
                return;
            }
            AtomicInteger migratedPlayers = new AtomicInteger();
            AtomicInteger noHaveKitDataPlayers = new AtomicInteger();
            for (File file : playerKitsDirectory.listFiles()) {
                YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
                String uuid = file.getName().replace(".yml", "");
                String name = config.getString("name");
                if (config.contains("kits")) {
                    PlayerKitData playerKitData = this.playerKits.getDatabase().getSyncPlayerData(UUID.fromString(uuid), name);
                    for (String key : config.getConfigurationSection("kits").getKeys(false)) {
                        long countdown = config.getLong("kits." + key + ".cooldown");
                        boolean oneTime = config.getBoolean("kits." + key + ".one_time");
                        boolean bought = config.getBoolean("kits." + key + ".bought");
                        playerKitData.getKitsData().put(key, new KitData(key, countdown, oneTime, bought));
                    }
                    this.playerKits.getDatabase().updatePlayerData(playerKitData.getUuid());
                    migratedPlayers.addAndGet(1);
                } else {
                    noHaveKitDataPlayers.addAndGet(1);
                }
                if (migratedPlayers.get() % 100 != 0) continue;
                this.playerKits.getLogger().info("Migrated " + migratedPlayers.get() + " players correctly.");
            }
            this.playerKits.getLogger().info("Successfully migrated " + migratedPlayers.get() + " player files and skipped " + noHaveKitDataPlayers.get() + " player files because they are unnecessary, lacking kit data in " + (System.currentTimeMillis() - startAt) + "ms.");
        });
    }
}

