/*
 * Decompiled with CFR 0.152.
 */
package io.github.InsiderAnh.xPlayerKits.menus.setup;

import io.github.InsiderAnh.xPlayerKits.PlayerKits;
import io.github.InsiderAnh.xPlayerKits.inventory.AInventory;
import io.github.InsiderAnh.xPlayerKits.inventory.InventorySizes;
import io.github.InsiderAnh.xPlayerKits.kits.Kit;
import io.github.InsiderAnh.xPlayerKits.libs.anvilgui.AnvilGUI;
import io.github.InsiderAnh.xPlayerKits.libs.nbtapi.NBTItem;
import io.github.InsiderAnh.xPlayerKits.libs.xseries.XMaterial;
import io.github.InsiderAnh.xPlayerKits.libs.xseries.XSound;
import io.github.InsiderAnh.xPlayerKits.menus.setup.KitClaimsSettingsMenu;
import io.github.InsiderAnh.xPlayerKits.menus.setup.KitContentMenu;
import io.github.InsiderAnh.xPlayerKits.menus.setup.KitInventorySettingsMenu;
import io.github.InsiderAnh.xPlayerKits.menus.setup.KitMainEditorMenu;
import io.github.InsiderAnh.xPlayerKits.menus.setup.actions.KitMainActionsMenu;
import io.github.InsiderAnh.xPlayerKits.utils.ItemUtils;
import io.github.InsiderAnh.xPlayerKits.utils.XPKUtils;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class KitEditorMenu
extends AInventory {
    private final PlayerKits playerKits = PlayerKits.getInstance();
    private final Kit kit;

    public KitEditorMenu(Player player, Kit kit) {
        super(player, InventorySizes.GENERIC_9X6, PlayerKits.getInstance().getLang().getString("menus.newKit.title"));
        this.kit = kit;
    }

    @Override
    protected void onClick(InventoryClickEvent event, ItemStack currentItem, ClickType click, Consumer<Boolean> canceled) {
        canceled.accept(true);
        Player player = this.getPlayer();
        NBTItem nbtItem = new NBTItem(currentItem);
        if (nbtItem.hasTag("icon")) {
            String icon = nbtItem.getString("icon");
            ItemStack itemStack = player.getItemInHand();
            if (itemStack == null || itemStack.getType().equals((Object)Material.AIR)) {
                player.sendMessage(this.playerKits.getLang().getString("messages.noItemHand"));
                player.playSound(player.getLocation(), (Sound)XSound.ENTITY_ENDERMAN_TELEPORT.get(), 1.0f, 1.0f);
                return;
            }
            this.kit.setIcon(icon, itemStack);
            player.sendMessage(this.playerKits.getLang().getString("messages.setIcon"));
            player.playSound(player.getLocation(), (Sound)XSound.BLOCK_NOTE_BLOCK_PLING.get(), 1.0f, 1.0f);
            this.onUpdate(this.getInventory());
            return;
        }
        if (nbtItem.hasTag("action")) {
            String action;
            switch (action = nbtItem.getString("action")) {
                case "claimsSettings": {
                    new KitClaimsSettingsMenu(player, this.kit).open();
                    return;
                }
                case "inventorySettings": {
                    new KitInventorySettingsMenu(player, this.kit).open();
                    return;
                }
                case "actionsRequirements": {
                    new KitMainActionsMenu(player, this.kit).open();
                    return;
                }
                case "preview": {
                    this.kit.setPreview(!this.kit.isPreview());
                    player.sendMessage(this.playerKits.getLang().getString("messages.setPreview").replace("<state>", this.kit.isPreview() ? this.playerKits.getLang().getString("messages.enabled") : this.playerKits.getLang().getString("messages.disabled")));
                    player.playSound(player.getLocation(), (Sound)XSound.BLOCK_NOTE_BLOCK_PLING.get(), 1.0f, 1.0f);
                    this.onUpdate(this.getInventory());
                    return;
                }
                case "parsePlaceholders": {
                    this.kit.setParsePlaceholdersOnClaim(!this.kit.isParsePlaceholdersOnClaim());
                    player.sendMessage(this.playerKits.getLang().getString("messages.setParsePlaceholders").replace("<state>", this.kit.isParsePlaceholdersOnClaim() ? this.playerKits.getLang().getString("messages.enabled") : this.playerKits.getLang().getString("messages.disabled")));
                    player.playSound(player.getLocation(), (Sound)XSound.BLOCK_NOTE_BLOCK_PLING.get(), 1.0f, 1.0f);
                    this.onUpdate(this.getInventory());
                    return;
                }
                case "save": {
                    this.kit.save();
                    this.playerKits.getKitManager().load();
                    player.sendMessage(this.playerKits.getLang().getString("messages.savedKit"));
                    player.playSound(player.getLocation(), (Sound)XSound.ENTITY_PLAYER_LEVELUP.get(), 1.0f, 1.0f);
                    this.close();
                    return;
                }
                case "back": {
                    new KitMainEditorMenu(player, 1).open();
                    return;
                }
                case "armor": 
                case "inv": {
                    new KitContentMenu(player, this.kit).open();
                    return;
                }
                case "name": {
                    this.handleAnvilGUI(player, "Write a name", "Write a name", string -> {
                        if (string.length() > 36) {
                            player.sendMessage(this.playerKits.getLang().getString("messages.longName"));
                            player.playSound(player.getLocation(), (Sound)XSound.ENTITY_ENDERMAN_TELEPORT.get(), 1.0f, 1.0f);
                            return;
                        }
                        this.playerKits.getKitManager().removeKit(this.kit.getName());
                        this.kit.setName((String)string);
                        this.playerKits.getKitManager().addKit(this.kit);
                        player.sendMessage(this.playerKits.getLang().getString("messages.setName").replace("<name>", this.kit.getName()));
                        player.playSound(player.getLocation(), (Sound)XSound.BLOCK_NOTE_BLOCK_PLING.get(), 1.0f, 1.0f);
                        new KitEditorMenu(player, this.kit).open();
                    });
                    return;
                }
                case "price": {
                    this.handleAnvilGUI(player, "Write a price", "Write a price", string -> {
                        double amount;
                        try {
                            amount = Double.parseDouble(string);
                        }
                        catch (Exception exception) {
                            player.sendMessage(this.playerKits.getLang().getString("messages.noNumber"));
                            player.playSound(player.getLocation(), (Sound)XSound.ENTITY_ENDERMAN_TELEPORT.get(), 1.0f, 1.0f);
                            return;
                        }
                        this.kit.setPrice(amount);
                        player.sendMessage(this.playerKits.getLang().getString("messages.setPrice").replace("<price>", String.valueOf(this.kit.getPrice())));
                        player.playSound(player.getLocation(), (Sound)XSound.BLOCK_NOTE_BLOCK_PLING.get(), 1.0f, 1.0f);
                        new KitEditorMenu(player, this.kit).open();
                    });
                    return;
                }
                case "permission": {
                    this.handleAnvilGUI(player, "Write a kit permission", "Write a permission", string -> {
                        if (string.contains(" ")) {
                            player.sendMessage(this.playerKits.getLang().getString("messages.permissionNoSpace"));
                            player.playSound(player.getLocation(), (Sound)XSound.ENTITY_ENDERMAN_TELEPORT.get(), 1.0f, 1.0f);
                        } else {
                            this.kit.setPermission((String)string);
                            player.sendMessage(this.playerKits.getLang().getString("messages.setPermission").replace("<name>", this.kit.getName()));
                            player.playSound(player.getLocation(), (Sound)XSound.BLOCK_NOTE_BLOCK_PLING.get(), 1.0f, 1.0f);
                            new KitEditorMenu(player, this.kit).open();
                        }
                    });
                    break;
                }
            }
        }
    }

    private void handleAnvilGUI(Player player, String title, String text, Consumer<String> execute) {
        new AnvilGUI.Builder().plugin((Plugin)this.playerKits).itemLeft(new ItemStack(Material.PAPER)).title(title).text(text).onClick((slot, type) -> {
            execute.accept(type.getText());
            return Collections.singletonList(AnvilGUI.ResponseAction.close());
        }).open(player);
    }

    @Override
    protected void onUpdate(Inventory inventory) {
        ItemStack name = new ItemUtils(XMaterial.PAPER.get()).displayName(this.playerKits.getLang().getString("menus.newKit.name.nameItem")).lore(this.playerKits.getLang().getString("menus.newKit.name.loreItem").replace("<name>", this.kit.getName())).build();
        ItemStack claimsSettings = new ItemUtils(XMaterial.ANVIL.get()).displayName(this.playerKits.getLang().getString("menus.newKit.claimsSettings.nameItem")).lore(this.playerKits.getLang().getString("menus.newKit.claimsSettings.loreItem")).build();
        ItemStack permission = new ItemUtils(XMaterial.BARRIER.get()).displayName(this.playerKits.getLang().getString("menus.newKit.permission.nameItem")).lore(this.playerKits.getLang().getString("menus.newKit.permission.loreItem").replace("<permission>", this.kit.getPermission())).build();
        ItemStack armor = new ItemUtils(XMaterial.IRON_CHESTPLATE.get()).displayName(this.playerKits.getLang().getString("menus.newKit.armor.nameItem")).lore(this.playerKits.getLang().getString("menus.newKit.armor.loreItem")).build();
        ItemStack inv = new ItemUtils(XMaterial.CHEST.get()).displayName(this.playerKits.getLang().getString("menus.newKit.inv.nameItem")).lore(this.playerKits.getLang().getString("menus.newKit.inv.loreItem")).build();
        ItemStack inventorySettings = new ItemUtils(XMaterial.ENDER_CHEST.get()).displayName(this.playerKits.getLang().getString("menus.newKit.inventorySettings.nameItem")).lore(this.playerKits.getLang().getString("menus.newKit.inventorySettings.loreItem")).build();
        ItemStack price = new ItemUtils(XMaterial.GOLD_NUGGET.get()).displayName(this.playerKits.getLang().getString("menus.newKit.price.nameItem")).lore(this.playerKits.getLang().getString("menus.newKit.price.loreItem").replace("<price>", String.valueOf(this.kit.getPrice()))).build();
        ItemStack actionsRequirements = new ItemUtils(XMaterial.BOOK.get()).displayName(this.playerKits.getLang().getString("menus.newKit.actionsRequirements.nameItem")).lore(this.playerKits.getLang().getString("menus.newKit.actionsRequirements.loreItem")).build();
        ItemStack preview = new ItemUtils(this.kit.isPreview() ? XMaterial.ENDER_EYE.get() : XMaterial.ENDER_PEARL.get()).displayName(this.playerKits.getLang().getString("menus.newKit.preview.nameItem")).lore(this.playerKits.getLang().getString("menus.newKit.preview.loreItem").replace("<state>", this.kit.isPreview() ? this.playerKits.getLang().getString("messages.enabled") : this.playerKits.getLang().getString("messages.disabled"))).build();
        ItemStack parsePlaceholders = new ItemUtils(this.kit.isParsePlaceholdersOnClaim() ? XMaterial.WRITABLE_BOOK.get() : XMaterial.BOOK.get()).displayName(this.playerKits.getLang().getString("menus.newKit.parsePlaceholders.nameItem")).lore(this.playerKits.getLang().getString("menus.newKit.parsePlaceholders.loreItem").replace("<state>", this.kit.isParsePlaceholdersOnClaim() ? this.playerKits.getLang().getString("messages.enabled") : this.playerKits.getLang().getString("messages.disabled"))).build();
        ItemStack back = new ItemUtils(XMaterial.ARROW.get()).displayName(this.playerKits.getLang().getString("menus.kitsMenu.back.nameItem")).build();
        ItemStack save = new ItemUtils(XMaterial.NETHER_STAR.get()).displayName(this.playerKits.getLang().getString("menus.newKit.save.nameItem")).lore(this.playerKits.getLang().getString("menus.newKit.save.loreItem")).build();
        inventory.setItem(10, XPKUtils.applySimpleTag(name, "action", "name"));
        inventory.setItem(11, XPKUtils.applySimpleTag(claimsSettings, "action", "claimsSettings"));
        inventory.setItem(13, XPKUtils.applySimpleTag(permission, "action", "permission"));
        inventory.setItem(15, XPKUtils.applySimpleTag(armor, "action", "armor"));
        inventory.setItem(16, XPKUtils.applySimpleTag(inv, "action", "inv"));
        inventory.setItem(19, XPKUtils.applySimpleTag(inventorySettings, "action", "inventorySettings"));
        inventory.setItem(20, XPKUtils.applySimpleTag(preview, "action", "preview"));
        inventory.setItem(22, XPKUtils.applySimpleTag(price, "action", "price"));
        inventory.setItem(24, XPKUtils.applySimpleTag(parsePlaceholders, "action", "parsePlaceholders"));
        inventory.setItem(25, XPKUtils.applySimpleTag(actionsRequirements, "action", "actionsRequirements"));
        ItemStack icons = new ItemUtils(XMaterial.GREEN_STAINED_GLASS_PANE.parseItem()).displayName(this.playerKits.getLang().getString("menus.newKit.icons.nameItem")).lore(this.playerKits.getLang().getString("menus.newKit.icons.loreItem").replace("<denyCommands>", this.kit.getActionsOnDenyString())).build();
        for (int i = 28; i <= 34; ++i) {
            inventory.setItem(i, icons);
        }
        AtomicInteger indexIcons = new AtomicInteger();
        for (String key : this.kit.getIcons().keySet()) {
            ItemStack icon = new ItemUtils(this.kit.getIcons().get(key)).displayName(this.playerKits.getLang().getString("menus.newKit." + key + ".nameItem")).lore(this.playerKits.getLang().getString("menus.newKit." + key + ".loreItem")).build();
            inventory.setItem(37 + indexIcons.getAndIncrement(), XPKUtils.applySimpleTag(icon, "icon", key));
        }
        inventory.setItem(45, XPKUtils.applySimpleTag(back, "action", "back"));
        inventory.setItem(53, XPKUtils.applySimpleTag(save, "action", "save"));
    }
}

