/*
 * Decompiled with CFR 0.152.
 */
package io.github.InsiderAnh.xPlayerKits.menus.setup;

import io.github.InsiderAnh.xPlayerKits.PlayerKits;
import io.github.InsiderAnh.xPlayerKits.inventory.AInventory;
import io.github.InsiderAnh.xPlayerKits.inventory.InventorySizes;
import io.github.InsiderAnh.xPlayerKits.kits.Kit;
import io.github.InsiderAnh.xPlayerKits.kits.properties.PropertyInventory;
import io.github.InsiderAnh.xPlayerKits.libs.anvilgui.AnvilGUI;
import io.github.InsiderAnh.xPlayerKits.libs.nbtapi.NBTItem;
import io.github.InsiderAnh.xPlayerKits.libs.xseries.XMaterial;
import io.github.InsiderAnh.xPlayerKits.libs.xseries.XSound;
import io.github.InsiderAnh.xPlayerKits.menus.setup.KitEditorMenu;
import io.github.InsiderAnh.xPlayerKits.utils.ItemUtils;
import io.github.InsiderAnh.xPlayerKits.utils.XPKUtils;
import java.util.Collections;
import java.util.function.Consumer;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class KitInventorySettingsMenu
extends AInventory {
    private final PlayerKits playerKits = PlayerKits.getInstance();
    private final Kit kit;

    public KitInventorySettingsMenu(Player player, Kit kit) {
        super(player, InventorySizes.GENERIC_9X4, PlayerKits.getInstance().getLang().getString("menus.inventorySettings.title"));
        this.kit = kit;
    }

    @Override
    protected void onClick(InventoryClickEvent event, ItemStack currentItem, ClickType click, Consumer<Boolean> canceled) {
        canceled.accept(true);
        Player player = this.getPlayer();
        PropertyInventory propertyInventory = this.kit.getPropertyInventory();
        NBTItem nbtItem = new NBTItem(currentItem);
        if (nbtItem.hasTag("action")) {
            String action;
            switch (action = nbtItem.getString("action")) {
                case "slot": {
                    this.handleAnvilGUI(player, "Write a kit slot", "Write a slot", string -> {
                        int slotI;
                        try {
                            slotI = Integer.parseInt(string);
                        }
                        catch (Exception exception) {
                            player.sendMessage(this.playerKits.getLang().getString("messages.noNumber"));
                            player.playSound(player.getLocation(), (Sound)XSound.ENTITY_ENDERMAN_TELEPORT.get(), 1.0f, 1.0f);
                            return;
                        }
                        propertyInventory.setSlot(slotI);
                        player.sendMessage(this.playerKits.getLang().getString("messages.setSlot").replace("<slot>", String.valueOf(propertyInventory.getSlot())));
                        player.playSound(player.getLocation(), (Sound)XSound.BLOCK_NOTE_BLOCK_PLING.get(), 1.0f, 1.0f);
                        new KitEditorMenu(player, this.kit).open();
                    });
                    return;
                }
                case "page": {
                    this.handleAnvilGUI(player, "Write a kit page", "Write a page", string -> {
                        int page;
                        try {
                            page = Integer.parseInt(string);
                        }
                        catch (Exception exception) {
                            player.sendMessage(this.playerKits.getLang().getString("messages.noNumber"));
                            player.playSound(player.getLocation(), (Sound)XSound.ENTITY_ENDERMAN_TELEPORT.get(), 1.0f, 1.0f);
                            return;
                        }
                        propertyInventory.setPage(page);
                        player.sendMessage(this.playerKits.getLang().getString("messages.setPage").replace("<page>", String.valueOf(propertyInventory.getPage())));
                        player.playSound(player.getLocation(), (Sound)XSound.BLOCK_NOTE_BLOCK_PLING.get(), 1.0f, 1.0f);
                        new KitEditorMenu(player, this.kit).open();
                    });
                    return;
                }
                case "back": {
                    new KitEditorMenu(player, this.kit).open();
                    return;
                }
                case "close": {
                    this.close();
                    return;
                }
            }
        }
    }

    private void handleAnvilGUI(Player player, String title, String text, Consumer<String> execute) {
        new AnvilGUI.Builder().plugin((Plugin)this.playerKits).itemLeft(new ItemStack(Material.PAPER)).title(title).text(text).onClick((slot, type) -> {
            execute.accept(type.getText());
            return Collections.singletonList(AnvilGUI.ResponseAction.close());
        }).open(player);
    }

    @Override
    protected void onUpdate(Inventory inventory) {
        PropertyInventory propertyInventory = this.kit.getPropertyInventory();
        ItemStack slot = new ItemUtils(XMaterial.GHAST_TEAR.get()).displayName(this.playerKits.getLang().getString("menus.inventorySettings.slot.nameItem")).lore(this.playerKits.getLang().getString("menus.inventorySettings.slot.loreItem").replace("<slot>", String.valueOf(propertyInventory.getSlot()))).build();
        ItemStack page = new ItemUtils(XMaterial.MAP.get()).displayName(this.playerKits.getLang().getString("menus.inventorySettings.page.nameItem")).lore(this.playerKits.getLang().getString("menus.inventorySettings.page.loreItem").replace("<page>", String.valueOf(propertyInventory.getPage()))).build();
        ItemStack back = new ItemUtils(XMaterial.ARROW.get()).displayName(this.playerKits.getLang().getString("menus.mainKitEditor.back.nameItem")).build();
        ItemStack close = new ItemUtils(XMaterial.BARRIER.get()).displayName(this.playerKits.getLang().getString("menus.mainKitEditor.close.nameItem")).build();
        inventory.setItem(11, XPKUtils.applySimpleTag(slot, "action", "slot"));
        inventory.setItem(15, XPKUtils.applySimpleTag(page, "action", "page"));
        inventory.setItem(27, XPKUtils.applySimpleTag(back, "action", "back"));
        inventory.setItem(31, XPKUtils.applySimpleTag(close, "action", "close"));
    }
}

